/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.utilities;

import com.ibm.sketch.connection.ParserConnectionPool;
import com.ibm.sketch.graph.GraphImpl;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.parser.SilentErrorHandler;
import com.ibm.sketch.schemaparser.composition.GraphBuilder;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class UsedSchemasFinder {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public URL[] find(URL uRL) throws IOException, SAXException {
        Vertex[] vertexArray;
        URI uRI = FactoryImpl.instance().createURI(uRL);
        XMLReader xMLReader = null;
        GraphBuilder graphBuilder = null;
        try {
            graphBuilder = new GraphBuilder(uRI);
            graphBuilder.setAddInvalidComposition(true);
            xMLReader = ParserConnectionPool.instance().acquireImpl();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            xMLReader.setErrorHandler(new SilentErrorHandler());
            xMLReader.setContentHandler(graphBuilder);
            xMLReader.parse(uRL.toString());
            vertexArray = null;
            if (xMLReader != null) {
                ParserConnectionPool.getInstance().releaseImpl(xMLReader);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (xMLReader != null) {
                ParserConnectionPool.getInstance().releaseImpl(xMLReader);
            }
            throw throwable;
        }
        if (graphBuilder != null) {
            GraphImpl graphImpl = graphBuilder.getGraph();
            if (graphImpl == null) {
                return new URL[]{uRL};
            }
            vertexArray = graphImpl.getVertices();
            if (vertexArray == null || vertexArray.length == 0) {
                return new URL[]{uRL};
            }
            Vector<URL> vector = new Vector<URL>(vertexArray.length);
            int n = 0;
            while (n < vertexArray.length) {
                try {
                    vector.add(((URI)vertexArray[n].getObject()).getAbsoluteURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n;
            }
            return vector.toArray(new URL[vector.size()]);
        }
        return new URL[]{uRL};
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("initializing UsedSchemasFinder. Please wait ...");
        List<URL> list = Arrays.asList(new UsedSchemasFinder().find(new URL("file:///C:\\SKETCH\\Testcases\\XMT\\ipoWithRedefine.xsd")));
        System.out.println("number of schemas : " + list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }
}

