/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.viewandvisitor;

import com.ibm.sketch.viewandvisitor.SchemaObjectVisitorImpl;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ComplexTypeSpec;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.IdentityConstraint;
import com.ibm.xml.ecm.schema.Key;
import com.ibm.xml.ecm.schema.KeyRef;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.Unique;
import java.util.Vector;

public class IdentityConstraintFinder
extends SchemaObjectVisitorImpl {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector fidConstraints = new Vector();

    public IdentityConstraint[] getIdentityConstraint() {
        if (this.fidConstraints.size() > 0) {
            return this.fidConstraints.toArray(new IdentityConstraint[this.fidConstraints.size()]);
        }
        return null;
    }

    public void visitComplexTypeDef(ComplexTypeDef complexTypeDef) {
        ComplexTypeSpec complexTypeSpec = complexTypeDef.getComplexTypeSpec();
        if (complexTypeSpec != null) {
            complexTypeSpec.accept(this);
        }
    }

    public void visitComplexTypeSpec(ComplexTypeSpec complexTypeSpec) {
        ContentModel contentModel = complexTypeSpec.getContentModel();
        if (contentModel != null) {
            contentModel.accept(this);
        }
    }

    public void visitContentModel(ContentModel contentModel) {
        if (!contentModel.isEmptyContentModel() && contentModel.getParticle() != null) {
            contentModel.getParticle().accept(this);
        }
    }

    public void visitGlobalElementDecl(GlobalElementDecl globalElementDecl) {
        IdentityConstraint[] identityConstraintArray = globalElementDecl.listIdentityConstraint();
        if (identityConstraintArray != null) {
            int n = 0;
            while (n < identityConstraintArray.length) {
                identityConstraintArray[n].accept(this);
                ++n;
            }
        }
        if (globalElementDecl.getTypeSpec() != null) {
            globalElementDecl.getTypeSpec().accept(this);
        }
    }

    public void visitGroup(Group group) {
        if (group.isEmpty()) {
            return;
        }
        Particle[] particleArray = group.listParticle();
        if (particleArray != null) {
            int n = 0;
            while (n < particleArray.length) {
                particleArray[n].accept(this);
                ++n;
            }
        }
    }

    public void visitKey(Key key) {
        this.fidConstraints.add(key);
    }

    public void visitKeyRef(KeyRef keyRef) {
        this.fidConstraints.add(keyRef);
    }

    public void visitLocalElementDecl(LocalElementDecl localElementDecl) {
        if (localElementDecl.getMaxOccurs().trim().equals("0") && localElementDecl.getMinOccursAsInt() == 0) {
            return;
        }
        IdentityConstraint[] identityConstraintArray = localElementDecl.listIdentityConstraint();
        if (identityConstraintArray != null) {
            int n = 0;
            while (n < identityConstraintArray.length) {
                identityConstraintArray[n].accept(this);
                ++n;
            }
        }
        if (localElementDecl.getTypeSpec() != null) {
            localElementDecl.getTypeSpec().accept(this);
        }
    }

    public void visitModelGroupDef(ModelGroupDef modelGroupDef) {
        Group group = modelGroupDef.getGroup();
        if (group != null) {
            group.accept(this);
        }
    }

    public void visitUnique(Unique unique) {
        this.fidConstraints.add(unique);
    }
}

