/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.viewandvisitor;

import com.ibm.sketch.graph.DefaultGraphVisitor;
import com.ibm.sketch.graph.DepthFirstTraversal;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.parser.NameWithPrefix;
import com.ibm.sketch.parser.SchemaTags;
import com.ibm.sketch.util.LocationComparator;
import com.ibm.sketch.util.URIComparator;
import com.ibm.sketch.viewandvisitor.SchemaObjectView;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitor;
import com.ibm.sketch.viewandvisitor.VisitorParcel;
import com.ibm.xml.ecm.schema.Annotation;
import com.ibm.xml.ecm.schema.AttributeDecl;
import com.ibm.xml.ecm.schema.AttributeGroupDef;
import com.ibm.xml.ecm.schema.AttributeGroupRef;
import com.ibm.xml.ecm.schema.AttributeRef;
import com.ibm.xml.ecm.schema.AttributeWildcard;
import com.ibm.xml.ecm.schema.AttributesSpec;
import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ComplexTypeRef;
import com.ibm.xml.ecm.schema.ComplexTypeSpec;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.DatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.DatatypeSpec;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.GlobalAttributeDecl;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.IdentityConstraint;
import com.ibm.xml.ecm.schema.ImportStatement;
import com.ibm.xml.ecm.schema.IncludeStatement;
import com.ibm.xml.ecm.schema.Info;
import com.ibm.xml.ecm.schema.Key;
import com.ibm.xml.ecm.schema.KeyRef;
import com.ibm.xml.ecm.schema.LocalAttributeDecl;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.ModelGroupRef;
import com.ibm.xml.ecm.schema.NotationDecl;
import com.ibm.xml.ecm.schema.NotationRef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ParticleWildcard;
import com.ibm.xml.ecm.schema.PrimitiveDatatype;
import com.ibm.xml.ecm.schema.RedefineStatement;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaComponent;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.Unique;
import com.ibm.xml.ecm.schema.Wildcard;
import com.ibm.xml.ecm.schema.XpathContainer;
import com.ibm.xml.ecm.schema.impl.AttributeRefImpl;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.DerivationByList;
import com.ibm.xml.ecm.schema.impl.DerivationByRestriction;
import com.ibm.xml.ecm.schema.impl.DerivationByUnion;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import com.ibm.xml.ecm.schema.impl.SchemaVertex;
import com.ibm.xml.ecm.schema.impl.WildcardImpl;
import java.rmi.server.UID;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PSVInfosetXmlDocumentVisitorImpl
implements SchemaObjectVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String INFOSET_NS = "http://www.w3.org/2001/05/XMLInfoset";
    public static final String INFOSET_PREFIX = "i";
    public static final String PSVI_NS = "http://www.w3.org/2001/05/PSVInfosetExtension";
    public static final String PSVI_PREFIX = "psvi";
    public static final String SCHEMA_INSTANCE_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA_INSTANCE_PREFIX = "xsi";
    public static final String SCHEMA_INFO = "schemaInformation";
    public static final String NAMESPACE_SCHEMA_INFO = "namespaceSchemaInformation";
    public static final String SCHEMA_NAMESPACE = "schemaNamespace";
    public static final String SCHEMA_COMPONENTS = "schemaComponents";
    public static final String SCHEMA_DOCUMENTS = "schemaDocuments";
    public static final String SCHEMA_DOCUMENT = "schemaDocument";
    public static final String SCHEMA_DOCUMENTLOCATION = "documentLocation";
    public static final String SCHEMA_ANNOTATIONS = "schemaAnnotations";
    public static final String ATTRIBUTE_DECLARATION = "attributeDeclaration";
    public static final String ELEMENT_DECLARATION = "elementDeclaration";
    public static final String COMPLEXTYPE = "complexTypeDefinition";
    public static final String SIMPLETYPE = "simpleTypeDefinition";
    public static final boolean DEBUG = true;
    private Node parent;
    private ObjectRegistry registry;

    public PSVInfosetXmlDocumentVisitorImpl(Document document) {
        this.parent = document;
        this.registry = new ObjectRegistry();
    }

    public PSVInfosetXmlDocumentVisitorImpl(Node node, ObjectRegistry objectRegistry) {
        this.parent = node;
        this.registry = objectRegistry;
    }

    public void addAnnotation(Element element, SchemaComponent schemaComponent) {
        Document document = element.getOwnerDocument();
        if (schemaComponent instanceof Type) {
            Element element2 = this.createPSVIElement("annotations", document);
            element.appendChild(element2);
        } else {
            Element element3 = this.createPSVIElement("annotation", document);
            this.nil(element3);
            element.appendChild(element3);
        }
    }

    protected Element createAttributeUse(AttributeDecl attributeDecl, Document document) {
        Object object;
        Element element = this.createPSVIElement("attributeUse", document);
        Element element2 = this.createPSVIElement("required", document);
        element.appendChild(element2);
        boolean bl = attributeDecl.getUse() == 4;
        element2.appendChild(document.createTextNode(bl ? "true" : "false"));
        if (attributeDecl instanceof AttributeRefImpl.GlobalAttributeDeclWrapper) {
            object = (AttributeRefImpl.GlobalAttributeDeclWrapper)attributeDecl;
            try {
                element.appendChild(this.createPointer(((AttributeRefImpl.GlobalAttributeDeclWrapper)object).getAttributeRef().resolve(false), document));
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                referenceResolutionException.printStackTrace(System.err);
            }
        } else if (this.registry.isAlreadyRegistered(attributeDecl) != null) {
            element.appendChild(this.createPointer(attributeDecl, document));
        } else {
            this.visitAttributeDecl(attributeDecl, element);
        }
        object = attributeDecl.getFixed();
        int n = 2;
        if (object == null) {
            object = attributeDecl.getDefault();
            n = 1;
        }
        Element element3 = this.createPSVIElement("valueConstraint", document);
        element.appendChild(element3);
        if (object != null) {
            element3.appendChild(this.createValueConstraintPropertyInstance((String)object, n, document));
        } else {
            this.nil(element3);
        }
        return element;
    }

    protected Element createAttributeUses(AttributeDecl[] attributeDeclArray, Document document) {
        Element element = this.createPSVIElement("attributeUses", document);
        if (attributeDeclArray != null) {
            int n = 0;
            while (n < attributeDeclArray.length) {
                Element element2 = this.createAttributeUse(attributeDeclArray[n], document);
                element.appendChild(element2);
                ++n;
            }
        }
        return element;
    }

    protected Element createAttributeWildcard(AttributeWildcard attributeWildcard, Document document) {
        Element element = this.createPSVIElement("attributeWildcard", document);
        if (attributeWildcard == null) {
            this.nil(element);
        } else {
            element.appendChild(this.createWildcard(attributeWildcard.getWildcard(), attributeWildcard, attributeWildcard.getProcessContents(), document));
        }
        return element;
    }

    protected Element createContentType(ContentType contentType, Document document) {
        Element element = this.createPSVIElement("contentType", document);
        Element element2 = this.createPSVIElement("variety", document);
        element.appendChild(element2);
        switch (contentType.getContentType()) {
            case 1: {
                element.appendChild(document.createTextNode("empty"));
                break;
            }
            case 2: {
                element.appendChild(document.createTextNode("simple"));
                Element element3 = this.createPSVIElement("simpleType", document);
                element.appendChild(element3);
                element3.appendChild(this.createTypeDefinitionOrPointerInstance(contentType.asSimpleType(), document));
                break;
            }
            case 3: {
                element.appendChild(document.createTextNode("mixed"));
            }
            case 4: {
                if (contentType.getContentType() == 4) {
                    element.appendChild(document.createTextNode("elementOnly"));
                }
                Element element4 = this.createPSVIElement("particle", document);
                element.appendChild(element4);
                element4.appendChild(this.createParticlePropertyInstance(contentType.asContentModel().getParticle(), document));
            }
        }
        return element;
    }

    protected DocumentFragment createContentTypePropertyInstance(ContentType contentType, Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        documentFragment.appendChild(this.createContentType(contentType, document));
        return documentFragment;
    }

    protected Element createIdentityConstraints(IdentityConstraint[] identityConstraintArray, Document document) {
        Element element = this.createPSVIElement("identityConstraintDefinitions", document);
        if (identityConstraintArray != null) {
            int n = 0;
            while (n < identityConstraintArray.length) {
                identityConstraintArray[n].accept(new PSVInfosetXmlDocumentVisitorImpl(element, this.registry));
                ++n;
            }
        }
        return element;
    }

    private Element createInfosetElement(String string, Document document) {
        return document.createElementNS(INFOSET_NS, new NameWithPrefix(INFOSET_PREFIX, string).toString());
    }

    protected Element createModelGroup(Group group, Document document) {
        Element element = this.createPSVIElement("modelGroup", document);
        element.setAttribute("id", this.registry.register(group).toString());
        Element element2 = this.createPSVIElement("compositor", document);
        element.appendChild(element2);
        String string = "sequence";
        switch (group.getCompositor()) {
            case 2: {
                string = "all";
                break;
            }
            case 1: {
                string = "choice";
                break;
            }
            case 0: {
                string = "sequence";
            }
        }
        element2.appendChild(document.createTextNode(string));
        Element element3 = this.createPSVIElement("particles", document);
        element.appendChild(element3);
        Particle[] particleArray = group.listParticle();
        if (particleArray != null) {
            int n = 0;
            while (n < particleArray.length) {
                particleArray[n].accept(new PSVInfosetXmlDocumentVisitorImpl(element3, this.registry));
                ++n;
            }
        }
        this.addAnnotation(element, group);
        return element;
    }

    protected DocumentFragment createModelGroupPropertyInstance(Group group, Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        documentFragment.appendChild(this.createModelGroup(group, document));
        return documentFragment;
    }

    protected DocumentFragment createNamespaceConstraintPropertyInstance(Wildcard wildcard, Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        Element element = this.createPSVIElement("namespaceConstraint", document);
        documentFragment.appendChild(element);
        Element element2 = this.createPSVIElement("variety", document);
        element.appendChild(element2);
        Element element3 = this.createPSVIElement("namespaces", document);
        element.appendChild(element3);
        int n = WildcardImpl.getCanonicalType(wildcard.getType());
        switch (n) {
            case 0: {
                element2.appendChild(document.createTextNode("any"));
                break;
            }
            case 3: {
                element2.appendChild(document.createTextNode("positive"));
                break;
            }
            case 2: {
                element2.appendChild(document.createTextNode("negative"));
            }
        }
        URI[] uRIArray = wildcard.listNamespace();
        if (uRIArray != null) {
            int n2 = 0;
            while (n2 < uRIArray.length) {
                if (uRIArray[n2] != null) {
                    element3.appendChild(document.createTextNode(uRIArray[n2].toString()));
                } else {
                    element3.appendChild(document.createTextNode("##none"));
                }
                ++n2;
            }
            element3.normalize();
        }
        return documentFragment;
    }

    protected Element createParticle(Particle particle, Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        particle.accept(new PSVInfosetXmlDocumentVisitorImpl(documentFragment, this.registry));
        return (Element)documentFragment.getFirstChild();
    }

    protected DocumentFragment createParticlePropertyInstance(Particle particle, Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        documentFragment.appendChild(this.createParticle(particle, document));
        return documentFragment;
    }

    protected Element createPointer(Object object, Document document) {
        Element element = this.createInfosetElement("pointer", document);
        UID uID = this.registry.register(object);
        element.setAttribute("ref", uID.toString());
        return element;
    }

    private Element createPSVIElement(String string, Document document) {
        return document.createElementNS(PSVI_NS, new NameWithPrefix(PSVI_PREFIX, string).toString());
    }

    protected Element createScope(Object object, Document document) {
        Element element = this.createPSVIElement("scope", document);
        if (object instanceof SchemaObject) {
            SchemaObject schemaObject = (SchemaObject)object;
            if (schemaObject instanceof TopComponent) {
                element.appendChild(document.createTextNode("global"));
            } else {
                SchemaObject schemaObject2 = schemaObject.getParent();
                while (schemaObject2 != null && !(schemaObject2 instanceof ComplexType)) {
                    schemaObject2 = schemaObject2.getParent();
                }
                if (schemaObject2 != null) {
                    element.appendChild(this.createPointer(schemaObject2, document));
                }
            }
        }
        return element;
    }

    protected DocumentFragment createTypeDefinitionOrPointerInstance(Type type, Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        if (type == null) {
            type = FactoryImpl.instance().getAnyType();
        }
        if (type.isAnonymous()) {
            ((SchemaObject)((Object)type)).accept(new PSVInfosetXmlDocumentVisitorImpl(documentFragment, this.registry));
        } else {
            Element element = this.createPointer(type, document);
            documentFragment.appendChild(element);
        }
        return documentFragment;
    }

    protected Element createValueConstraintPropertyInstance(String string, int n, Document document) {
        Element element = this.createPSVIElement("valueConstraint", document);
        if (string == null) {
            this.nil(element);
        } else {
            Element element2 = this.createPSVIElement("variety", document);
            element.appendChild(element2);
            switch (n) {
                case 2: {
                    element2.appendChild(document.createTextNode("fixed"));
                    break;
                }
                case 1: {
                    element2.appendChild(document.createTextNode("default"));
                }
            }
            Element element3 = this.createPSVIElement("value", document);
            element.appendChild(element3);
            element3.appendChild(document.createTextNode(string));
        }
        return element;
    }

    protected Element createWildcard(Wildcard wildcard, SchemaComponent schemaComponent, int n, Document document) {
        UID uID = this.registry.register(schemaComponent);
        Element element = this.createPSVIElement("wildcard", document);
        element.setAttribute("id", uID.toString());
        Element element2 = this.createPSVIElement("namespaceConstraint", document);
        element.appendChild(element2);
        element2.appendChild(this.createNamespaceConstraintPropertyInstance(wildcard, document));
        Element element3 = this.createPSVIElement("processContents", document);
        element.appendChild(element3);
        switch (n) {
            case 1: {
                element3.appendChild(document.createTextNode("skip"));
                break;
            }
            case 2: {
                element3.appendChild(document.createTextNode("lax"));
                break;
            }
            case 0: {
                element3.appendChild(document.createTextNode("strict"));
            }
        }
        this.addAnnotation(element, schemaComponent);
        return element;
    }

    public VisitorParcel getVisitorParcel() {
        return null;
    }

    private void nil(Element element) {
        element.setAttributeNS(SCHEMA_INSTANCE_NS, "xsi:nill", "true");
    }

    public void setVisitorParcel(VisitorParcel visitorParcel) {
    }

    public void visitAnnotation(Annotation annotation) {
    }

    protected void visitAttributeDecl(AttributeDecl attributeDecl, Node node) {
        Object object;
        Object object2;
        Document document = node.getOwnerDocument();
        if (document == null && node instanceof Document) {
            document = (Document)node;
        }
        Element element = this.createPSVIElement(ATTRIBUTE_DECLARATION, document);
        node.appendChild(element);
        element.setAttribute("id", this.registry.register(attributeDecl).toString());
        String string = attributeDecl.getNCName();
        Element element2 = this.createPSVIElement("name", document);
        element.appendChild(element2);
        if (string != null) {
            element2.appendChild(document.createTextNode(string));
        } else {
            this.nil(element2);
        }
        URI uRI = attributeDecl.getTargetNamespace();
        Element element3 = this.createPSVIElement("targetNamespace", document);
        element.appendChild(element3);
        if (uRI != null) {
            element3.appendChild(document.createTextNode(uRI.toString()));
        } else {
            this.nil(element3);
        }
        try {
            object2 = attributeDecl.getType();
            if (object2 == null) {
                object = FactoryImpl.instance();
                object2 = object.getBuiltInDatatype("anySimpleType");
            }
            object = this.createPSVIElement("typeDefinition", document);
            element.appendChild((Node)object);
            object.appendChild(this.createTypeDefinitionOrPointerInstance((Type)object2, document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
        object2 = this.createScope(attributeDecl, document);
        element.appendChild((Node)object2);
        object = attributeDecl.getFixed();
        int n = 2;
        if (object == null) {
            object = attributeDecl.getDefault();
            n = 1;
        }
        Element element4 = this.createPSVIElement("valueConstraint", document);
        element.appendChild(element4);
        if (object != null) {
            element4.appendChild(this.createValueConstraintPropertyInstance((String)object, n, document));
        } else {
            this.nil(element4);
        }
        if (attributeDecl instanceof SchemaComponent) {
            this.addAnnotation(element, (SchemaComponent)((Object)attributeDecl));
        }
    }

    public void visitAttributeGroupDef(AttributeGroupDef attributeGroupDef) {
    }

    public void visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
    }

    public void visitAttributeRef(AttributeRef attributeRef) {
    }

    public void visitAttributesSpec(AttributesSpec attributesSpec) {
    }

    public void visitAttributeWildcard(AttributeWildcard attributeWildcard) {
    }

    protected void visitComplexType(ComplexType complexType, Node node) {
        Object object;
        Element element;
        Object object2;
        Document document = node.getOwnerDocument();
        if (document == null && node instanceof Document) {
            document = (Document)node;
        }
        Element element2 = this.createPSVIElement(COMPLEXTYPE, document);
        node.appendChild(element2);
        element2.setAttribute("id", this.registry.register(complexType).toString());
        String string = complexType.getNCName();
        Element element3 = this.createPSVIElement("name", document);
        element2.appendChild(element3);
        if (string != null) {
            element3.appendChild(document.createTextNode(string));
        } else {
            this.nil(element3);
        }
        URI uRI = complexType.getTargetNamespace();
        Element element4 = this.createPSVIElement("targetNamespace", document);
        element2.appendChild(element4);
        if (uRI != null) {
            element4.appendChild(document.createTextNode(uRI.toString()));
        } else {
            this.nil(element4);
        }
        try {
            object2 = complexType.getBasetype();
            element = this.createPSVIElement("baseTypeDefinition", document);
            element2.appendChild(element);
            object = object2 != null ? object2.resolveToType() : FactoryImpl.instance().getAnyType();
            element.appendChild(this.createTypeDefinitionOrPointerInstance((Type)object, document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
        object2 = this.createPSVIElement("derivationMethod", document);
        element2.appendChild((Node)object2);
        object2.appendChild(document.createTextNode(ComplexTypeSpecImpl.derivationType(complexType.getDerivationType())));
        element = this.createPSVIElement("final", document);
        element2.appendChild(element);
        object = complexType.getFinalList();
        if (object != null) {
            Arrays.sort((int[])object);
            int n = 0;
            while (n < ((Object)object).length) {
                element.appendChild(document.createTextNode(ComplexTypeSpecImpl.derivationType((int)object[n])));
                ++n;
            }
            element.normalize();
        }
        Element element5 = this.createPSVIElement("abstract", document);
        element2.appendChild(element5);
        element5.appendChild(document.createTextNode(complexType.isAbstract() ? "true" : "false"));
        AttributeDecl[] attributeDeclArray = null;
        try {
            attributeDeclArray = complexType.getEffectiveAttributes();
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace(System.err);
        }
        element2.appendChild(this.createAttributeUses(attributeDeclArray, document));
        AttributeWildcard attributeWildcard = null;
        try {
            attributeWildcard = complexType.getEffectiveAttributeWildcard();
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace(System.err);
        }
        element2.appendChild(this.createAttributeWildcard(attributeWildcard, document));
        ContentType contentType = null;
        try {
            contentType = complexType.getEffectiveContentType();
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace(System.err);
        }
        Element element6 = this.createPSVIElement("contentType", document);
        element2.appendChild(element6);
        element6.appendChild(this.createContentTypePropertyInstance(contentType, document));
        Element element7 = this.createPSVIElement("prohibitedSubstitutions", document);
        element2.appendChild(element7);
        int[] nArray = complexType.getFinalList();
        if (nArray != null) {
            Arrays.sort(nArray);
            int n = 0;
            while (n < nArray.length) {
                element7.appendChild(document.createTextNode(ComplexTypeSpecImpl.derivationType(nArray[n])));
                ++n;
            }
            element7.normalize();
        }
        if (complexType instanceof SchemaComponent) {
            this.addAnnotation(element2, (SchemaComponent)((Object)complexType));
        }
    }

    public void visitComplexTypeDef(ComplexTypeDef complexTypeDef) {
        this.visitComplexType(complexTypeDef, this.parent);
    }

    public void visitComplexTypeRef(ComplexTypeRef complexTypeRef) {
        Document document = this.parent.getOwnerDocument();
        if (document == null & this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        try {
            Type type = (Type)((Object)complexTypeRef.resolve(false));
            this.parent.appendChild(this.createPointer(type, document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
    }

    public void visitComplexTypeSpec(ComplexTypeSpec complexTypeSpec) {
        this.visitComplexType(complexTypeSpec, this.parent);
    }

    public void visitContentModel(ContentModel contentModel) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        this.parent.appendChild(this.createContentType(contentModel, document));
    }

    public void visitDatatypeDef(DatatypeDef datatypeDef) {
        this.visitSimpleType(datatypeDef, this.parent);
    }

    public void visitDatatypeRef(DatatypeRef datatypeRef) {
    }

    public void visitDatatypeSpec(DatatypeSpec datatypeSpec) {
        this.visitSimpleType(datatypeSpec, this.parent);
    }

    public void visitDerivationByList(DerivationByList derivationByList) {
    }

    public Node visitDerivationByList(DerivationByList derivationByList, SchemaObjectView schemaObjectView) {
        return null;
    }

    public void visitDerivationByRestriction(DerivationByRestriction derivationByRestriction) {
    }

    public Node visitDerivationByRestriction(DerivationByRestriction derivationByRestriction, SchemaObjectView schemaObjectView) {
        return null;
    }

    public void visitDerivationByUnion(DerivationByUnion derivationByUnion) {
    }

    public Node visitDerivationByUnion(DerivationByUnion derivationByUnion, SchemaObjectView schemaObjectView) {
        return null;
    }

    protected void visitElementDecl(ElementDecl elementDecl, Node node) {
        Object object;
        Object object2;
        Document document = node.getOwnerDocument();
        if (document == null && node instanceof Document) {
            document = (Document)node;
        }
        Element element = this.createPSVIElement(ELEMENT_DECLARATION, document);
        node.appendChild(element);
        element.setAttribute("id", this.registry.register(elementDecl).toString());
        String string = elementDecl.getNCName();
        Element element2 = this.createPSVIElement("name", document);
        element.appendChild(element2);
        if (string != null) {
            element2.appendChild(document.createTextNode(string));
        } else {
            this.nil(element2);
        }
        URI uRI = elementDecl.getTargetNamespace();
        Element element3 = this.createPSVIElement("targetNamespace", document);
        element.appendChild(element3);
        if (uRI != null) {
            element3.appendChild(document.createTextNode(uRI.toString()));
        } else {
            this.nil(element3);
        }
        try {
            object2 = elementDecl.getEffectiveType();
            object = this.createPSVIElement("typeDefinition", document);
            element.appendChild((Node)object);
            object.appendChild(this.createTypeDefinitionOrPointerInstance((Type)object2, document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
        object2 = this.createScope(elementDecl, document);
        element.appendChild((Node)object2);
        object = elementDecl.getValue();
        int n = elementDecl.getValueConstraint();
        Element element4 = this.createPSVIElement("valueConstraint", document);
        element.appendChild(element4);
        if (object != null) {
            element4.appendChild(this.createValueConstraintPropertyInstance((String)object, n, document));
        } else {
            this.nil(element4);
        }
        Element element5 = this.createPSVIElement("nillable", document);
        element.appendChild(element5);
        element5.appendChild(document.createTextNode(elementDecl.isNillable() ? "true" : "false"));
        Element element6 = this.createIdentityConstraints(elementDecl.listIdentityConstraint(), document);
        element.appendChild(element6);
        Element element7 = this.createPSVIElement("substitutionGroupAffiliation", document);
        element.appendChild(element7);
        ElementRef elementRef = elementDecl.getSubstitutionAffiliation();
        try {
            if (elementRef != null) {
                element7.appendChild(document.createTextNode(this.registry.register(elementRef.resolve(false)).toString()));
            } else {
                this.nil(element7);
            }
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            this.nil(element7);
        }
        Element element8 = this.createPSVIElement("substitutionGroupExclusions", document);
        element.appendChild(element8);
        int[] nArray = elementDecl.getFinalList();
        if (nArray != null) {
            Arrays.sort(nArray);
            int n2 = 0;
            while (n2 < nArray.length) {
                element8.appendChild(document.createTextNode(SchemaTags.getFinal(nArray[n2])));
                ++n2;
            }
            element8.normalize();
        }
        Element element9 = this.createPSVIElement("disallowedSubstitutions", document);
        element.appendChild(element9);
        int[] nArray2 = elementDecl.getBlockList();
        if (nArray2 != null) {
            Arrays.sort(nArray2);
            int n3 = 0;
            while (n3 < nArray2.length) {
                element9.appendChild(document.createTextNode(SchemaTags.getBlockSubstitution(nArray2[n3])));
                ++n3;
            }
            element9.normalize();
        }
        Element element10 = this.createPSVIElement("abstract", document);
        element.appendChild(element10);
        element10.appendChild(document.createTextNode(elementDecl.isAbstract() ? "true" : "false"));
        if (elementDecl instanceof SchemaComponent) {
            this.addAnnotation(element, (SchemaComponent)((Object)elementDecl));
        }
    }

    public void visitElementRef(ElementRef elementRef) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        Element element = this.createPSVIElement("particle", document);
        element.setAttribute("id", this.registry.register(elementRef).toString());
        this.parent.appendChild(element);
        Element element2 = this.createPSVIElement("minOccurs", document);
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(elementRef.getMinOccurs()));
        Element element3 = this.createPSVIElement("maxOccurs", document);
        element.appendChild(element3);
        element3.appendChild(document.createTextNode(elementRef.getMaxOccurs()));
        Element element4 = this.createPSVIElement("term", document);
        element.appendChild(element4);
        try {
            GlobalElementDecl globalElementDecl = (GlobalElementDecl)elementRef.resolve(false);
            element4.appendChild(this.createPointer(globalElementDecl, document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
    }

    public void visitFacet(Facet facet) {
        String[] stringArray;
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        if ((stringArray = facet.getValuesAsString()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                Element element = this.createPSVIElement(facet.getFacetTypeAsString(), document);
                this.parent.appendChild(element);
                Element element2 = this.createPSVIElement("value", document);
                element.appendChild(element2);
                element2.appendChild(document.createTextNode(stringArray[n]));
                Element element3 = this.createPSVIElement("fixed", document);
                element.appendChild(element3);
                element3.appendChild(document.createTextNode(facet.isFixed() ? "true" : "false"));
                if (n == 0) {
                    this.addAnnotation(element, facet);
                }
                ++n;
            }
        }
    }

    public void visitGlobalAttributeDecl(GlobalAttributeDecl globalAttributeDecl) {
        this.visitAttributeDecl(globalAttributeDecl, this.parent);
    }

    public void visitGlobalElementDecl(GlobalElementDecl globalElementDecl) {
        this.visitElementDecl(globalElementDecl, this.parent);
    }

    public void visitGroup(Group group) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        Element element = this.createPSVIElement("particle", document);
        this.parent.appendChild(element);
        Element element2 = this.createPSVIElement("minOccurs", document);
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(group.getMinOccurs()));
        Element element3 = this.createPSVIElement("maxOccurs", document);
        element.appendChild(element3);
        element3.appendChild(document.createTextNode(group.getMaxOccurs()));
        Element element4 = this.createPSVIElement("term", document);
        element.appendChild(element4);
        element4.appendChild(this.createModelGroup(group, document));
    }

    public void visitImportStatement(ImportStatement importStatement) {
    }

    public void visitIncludeStatement(IncludeStatement includeStatement) {
    }

    public void visitInfo(Info info) {
    }

    public void visitKey(Key key) {
    }

    public void visitKeyRef(KeyRef keyRef) {
    }

    public void visitLocalAttributeDecl(LocalAttributeDecl localAttributeDecl) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        this.parent.appendChild(this.createAttributeUse(localAttributeDecl, document));
    }

    public void visitLocalElementDecl(LocalElementDecl localElementDecl) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        Element element = this.createPSVIElement("particle", document);
        element.setAttribute("id", this.registry.register(localElementDecl).toString());
        this.parent.appendChild(element);
        Element element2 = this.createPSVIElement("minOccurs", document);
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(localElementDecl.getMinOccurs()));
        Element element3 = this.createPSVIElement("maxOccurs", document);
        element.appendChild(element3);
        element3.appendChild(document.createTextNode(localElementDecl.getMaxOccurs()));
        Element element4 = this.createPSVIElement("term", document);
        element.appendChild(element4);
        this.visitElementDecl(localElementDecl, element4);
    }

    public void visitModelGroupDef(ModelGroupDef modelGroupDef) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        Element element = this.createPSVIElement("modelGroupDefinition", document);
        element.setAttribute("id", this.registry.register(modelGroupDef).toString());
        this.parent.appendChild(element);
        String string = modelGroupDef.getNCName();
        Element element2 = this.createPSVIElement("name", document);
        element.appendChild(element2);
        if (string != null) {
            element2.appendChild(document.createTextNode(string));
        } else {
            this.nil(element2);
        }
        URI uRI = modelGroupDef.getTargetNamespace();
        Element element3 = this.createPSVIElement("targetNamespace", document);
        element.appendChild(element3);
        if (uRI != null) {
            element3.appendChild(document.createTextNode(uRI.toString()));
        } else {
            this.nil(element3);
        }
        Element element4 = this.createPSVIElement("modelGroup", document);
        element4.appendChild(this.createModelGroupPropertyInstance(modelGroupDef.getGroup(), document));
        this.addAnnotation(element, modelGroupDef);
    }

    public void visitModelGroupRef(ModelGroupRef modelGroupRef) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        Element element = this.createPSVIElement("particle", document);
        element.setAttribute("id", this.registry.register(modelGroupRef).toString());
        this.parent.appendChild(element);
        Element element2 = this.createPSVIElement("minOccurs", document);
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(modelGroupRef.getMinOccurs()));
        Element element3 = this.createPSVIElement("maxOccurs", document);
        element.appendChild(element3);
        element3.appendChild(document.createTextNode(modelGroupRef.getMaxOccurs()));
        Element element4 = this.createPSVIElement("term", document);
        element.appendChild(element4);
        try {
            ModelGroupDef modelGroupDef = (ModelGroupDef)modelGroupRef.resolve(false);
            element4.appendChild(this.createPointer(modelGroupDef.getGroup(), document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
    }

    public void visitNotationDecl(NotationDecl notationDecl) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        Element element = this.createPSVIElement("notationDeclaration", document);
        this.parent.appendChild(element);
        element.setAttribute("id", this.registry.register(notationDecl).toString());
        String string = notationDecl.getNCName();
        Element element2 = this.createPSVIElement("name", document);
        element.appendChild(element2);
        if (string != null) {
            element2.appendChild(document.createTextNode(string));
        } else {
            this.nil(element2);
        }
        URI uRI = notationDecl.getTargetNamespace();
        Element element3 = this.createPSVIElement("targetNamespace", document);
        element.appendChild(element3);
        if (uRI != null) {
            element3.appendChild(document.createTextNode(uRI.toString()));
        } else {
            this.nil(element3);
        }
        URI uRI2 = notationDecl.getSystem();
        Element element4 = this.createInfosetElement("systemIdentifier", document);
        element.appendChild(element4);
        if (uRI2 != null) {
            element4.appendChild(document.createTextNode(uRI2.toString()));
        } else {
            this.nil(element4);
        }
        String string2 = notationDecl.getPublic();
        Element element5 = this.createInfosetElement("publicIdentifier", document);
        element.appendChild(element5);
        if (string2 != null) {
            element5.appendChild(document.createTextNode(string2));
        } else {
            this.nil(element5);
        }
        this.addAnnotation(element, notationDecl);
    }

    public void visitNotationRef(NotationRef notationRef) {
        Document document = this.parent.getOwnerDocument();
        if (document == null & this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        try {
            NotationDecl notationDecl = (NotationDecl)notationRef.resolve(false);
            this.parent.appendChild(this.createPointer(notationDecl, document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
    }

    public void visitParticleWildcard(ParticleWildcard particleWildcard) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        Element element = this.createPSVIElement("particle", document);
        this.parent.appendChild(element);
        Element element2 = this.createPSVIElement("minOccurs", document);
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(particleWildcard.getMinOccurs()));
        Element element3 = this.createPSVIElement("maxOccurs", document);
        element.appendChild(element3);
        element3.appendChild(document.createTextNode(particleWildcard.getMaxOccurs()));
        Element element4 = this.createPSVIElement("term", document);
        element.appendChild(element4);
        element4.appendChild(this.createWildcard(particleWildcard.getWildcard(), particleWildcard, particleWildcard.getProcessContents(), document));
    }

    public void visitPrimitiveDatatype(PrimitiveDatatype primitiveDatatype) {
        this.visitDatatypeDef(primitiveDatatype);
    }

    public void visitRedefineStatement(RedefineStatement redefineStatement) {
    }

    public void visitSchema(Schema schema) {
        Document document = this.parent.getOwnerDocument();
        if (document == null && this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        Element element = this.createPSVIElement(SCHEMA_INFO, document);
        element.setAttribute("xmlns:psvi", PSVI_NS);
        element.setAttribute("xmlns:i", INFOSET_NS);
        element.setAttribute("xmlns:xsi", SCHEMA_INSTANCE_NS);
        this.parent.appendChild(element);
        SchemaInfoCollector schemaInfoCollector = new SchemaInfoCollector();
        new DepthFirstTraversal().traverse(new SchemaVertex(schema), (GraphVisitor)schemaInfoCollector);
        SchemaInfo schemaInfo = schemaInfoCollector.getSchemaInfo();
        URI[] uRIArray = schemaInfo.getNamespaces();
        if (uRIArray != null) {
            int n = 0;
            while (n < uRIArray.length) {
                this.visitSchema(uRIArray[n], schemaInfo.getTopComponents(uRIArray[n]), schemaInfo.getLocations(uRIArray[n]), schemaInfo.getAnnotations(uRIArray[n]), element);
                ++n;
            }
        }
        schemaInfoCollector = new SchemaInfoCollector();
        BuiltInDatatypeDef builtInDatatypeDef = FactoryImpl.instance().getBuiltInDatatype("anySimpleType");
        Schema schema2 = builtInDatatypeDef.getSchema();
        new DepthFirstTraversal().traverse(new SchemaVertex(schema2), (GraphVisitor)schemaInfoCollector);
        schemaInfo = schemaInfoCollector.getSchemaInfo();
        uRIArray = schemaInfo.getNamespaces();
        if (uRIArray != null) {
            int n = 0;
            while (n < uRIArray.length) {
                this.visitSchema(uRIArray[n], schemaInfo.getTopComponents(uRIArray[n]), schemaInfo.getLocations(uRIArray[n]), schemaInfo.getAnnotations(uRIArray[n]), element);
                ++n;
            }
        }
    }

    private void visitSchema(URI uRI, TopComponent[] topComponentArray, URI[] uRIArray, Annotation[] annotationArray, Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = this.createPSVIElement(NAMESPACE_SCHEMA_INFO, document);
        element.appendChild(element2);
        Element element3 = this.createPSVIElement(SCHEMA_NAMESPACE, document);
        element2.appendChild(element3);
        if (uRI == null) {
            this.nil(element3);
        } else {
            element3.appendChild(document.createTextNode(uRI.toString()));
        }
        Element element4 = this.createPSVIElement(SCHEMA_COMPONENTS, document);
        element2.appendChild(element4);
        if (topComponentArray != null && topComponentArray.length > 0) {
            int n = 0;
            while (n < topComponentArray.length) {
                topComponentArray[n].accept(new PSVInfosetXmlDocumentVisitorImpl(element4, this.registry));
                ++n;
            }
        } else {
            this.nil(element4);
        }
        Element element5 = this.createPSVIElement(SCHEMA_DOCUMENTS, document);
        element2.appendChild(element5);
        if (uRIArray != null && uRIArray.length > 0) {
            int n = 0;
            while (n < uRIArray.length) {
                Element element6 = this.createPSVIElement(SCHEMA_DOCUMENT, document);
                element5.appendChild(element6);
                Element element7 = this.createPSVIElement(SCHEMA_DOCUMENTLOCATION, document);
                element6.appendChild(element7);
                if (uRIArray[n] == null) {
                    this.nil(element7);
                } else {
                    element7.appendChild(document.createTextNode(uRIArray[n].toString()));
                }
                Element element8 = this.createPSVIElement("document", document);
                element6.appendChild(element8);
                ++n;
            }
        }
        Element element9 = this.createPSVIElement(SCHEMA_ANNOTATIONS, document);
        element2.appendChild(element9);
        if (annotationArray != null && annotationArray.length > 0) {
            int n = 0;
            while (n < annotationArray.length) {
                annotationArray[n].accept(new PSVInfosetXmlDocumentVisitorImpl(element9, this.registry));
                ++n;
            }
        } else {
            this.nil(element9);
        }
    }

    protected void visitSimpleType(SimpleType simpleType, Node node) {
        Object object;
        Object object2;
        Document document = node.getOwnerDocument();
        if (document == null && node instanceof Document) {
            document = (Document)node;
        }
        Element element = this.createPSVIElement(SIMPLETYPE, document);
        node.appendChild(element);
        element.setAttribute("id", this.registry.register(simpleType).toString());
        String string = simpleType.getNCName();
        Element element2 = this.createPSVIElement("name", document);
        element.appendChild(element2);
        if (string != null) {
            element2.appendChild(document.createTextNode(string));
        } else {
            this.nil(element2);
        }
        URI uRI = simpleType.getTargetNamespace();
        Element element3 = this.createPSVIElement("targetNamespace", document);
        element.appendChild(element3);
        if (uRI != null) {
            element3.appendChild(document.createTextNode(uRI.toString()));
        } else {
            this.nil(element3);
        }
        try {
            object2 = simpleType.getBasetype();
            object = this.createPSVIElement("baseTypeDefinition", document);
            element.appendChild((Node)object);
            Type type = object2 != null ? object2.resolveToType() : FactoryImpl.instance().getBuiltInDatatype("anySimpleType");
            object.appendChild(this.createTypeDefinitionOrPointerInstance(type, document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
        object2 = this.createPSVIElement("facets", document);
        element.appendChild((Node)object2);
        try {
            object = simpleType.getAllFacets();
            if (object != null) {
                int n = 0;
                while (n < ((Facet[])object).length) {
                    object[n].accept(new PSVInfosetXmlDocumentVisitorImpl((Node)object2, this.registry));
                    ++n;
                }
            }
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace(System.err);
        }
        object2 = this.createPSVIElement("fundamentalFacets", document);
        element.appendChild((Node)object2);
        try {
            object = simpleType.getAllFundamentalFacets();
            if (object != null) {
                int n = 0;
                while (n < ((Facet[])object).length) {
                    object[n].accept(new PSVInfosetXmlDocumentVisitorImpl((Node)object2, this.registry));
                    ++n;
                }
            }
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace(System.err);
        }
        object = this.createPSVIElement("final", document);
        element.appendChild((Node)object);
        int[] nArray = simpleType.getFinalList();
        if (nArray != null) {
            Arrays.sort(nArray);
            int n = 0;
            while (n < nArray.length) {
                object.appendChild(document.createTextNode(ComplexTypeSpecImpl.derivationType(nArray[n])));
                ++n;
            }
            object.normalize();
        }
        Element element4 = this.createPSVIElement("variety", document);
        element.appendChild(element4);
        try {
            String string2;
            switch (simpleType.getVariety()) {
                case 0: {
                    string2 = "atomic";
                    Element element5 = this.createPSVIElement("primitiveTypeDefinition", document);
                    element.appendChild(element5);
                    try {
                        BuiltInDatatypeDef builtInDatatypeDef = simpleType.getPrimitiveDatatype();
                        if (builtInDatatypeDef == null) {
                            builtInDatatypeDef = FactoryImpl.instance().getBuiltInDatatype("anySimpleType");
                        }
                        element5.appendChild(this.createTypeDefinitionOrPointerInstance(builtInDatatypeDef, document));
                    }
                    catch (SchemaException schemaException) {
                        schemaException.printStackTrace(System.err);
                    }
                    break;
                }
                case 1: {
                    string2 = "list";
                    Element element6 = this.createPSVIElement("itemTypeDefinition", document);
                    element.appendChild(element6);
                    try {
                        DatatypeDef datatypeDef = DatatypeSpecImpl.getNearestNonListSupertype(simpleType);
                        if (datatypeDef == null) {
                            datatypeDef = FactoryImpl.instance().getBuiltInDatatype("anySimpleType");
                        }
                        element6.appendChild(this.createTypeDefinitionOrPointerInstance(datatypeDef, document));
                    }
                    catch (SchemaException schemaException) {
                        schemaException.printStackTrace(System.err);
                    }
                    break;
                }
                case 2: {
                    string2 = "union";
                    Element element7 = this.createPSVIElement("memberTypeDefinitions", document);
                    element.appendChild(element7);
                    try {
                        TypeInfo[] typeInfoArray = DatatypeSpecImpl.getUnionMembers(simpleType);
                        if (typeInfoArray == null) break;
                        int n = 0;
                        while (n < typeInfoArray.length) {
                            element7.appendChild(this.createTypeDefinitionOrPointerInstance(typeInfoArray[n].resolveToType(), document));
                            ++n;
                        }
                    }
                    catch (SchemaException schemaException) {
                        schemaException.printStackTrace(System.err);
                    }
                    break;
                }
                default: {
                    string2 = "unknown";
                }
            }
            element4.appendChild(document.createTextNode(string2));
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace(System.err);
        }
        if (simpleType instanceof SchemaComponent) {
            this.addAnnotation(element, (SchemaComponent)((Object)simpleType));
        }
    }

    public void visitTypeRef(TypeRef typeRef) {
        Document document = this.parent.getOwnerDocument();
        if (document == null & this.parent instanceof Document) {
            document = (Document)this.parent;
        }
        try {
            Type type = (Type)((Object)typeRef.resolve(false));
            this.parent.appendChild(this.createPointer(type, document));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            referenceResolutionException.printStackTrace(System.err);
        }
    }

    public void visitUnique(Unique unique) {
    }

    public void visitWildcard(Wildcard wildcard) {
    }

    public void visitXpathContainer(XpathContainer xpathContainer) {
    }

    public static class SchemaInfoCollector
    extends DefaultGraphVisitor {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private SchemaInfo schemaInfo = new SchemaInfo();

        public void visitVertex(Vertex vertex) {
            Annotation[] annotationArray;
            TopComponent[] topComponentArray;
            SchemaImpl schemaImpl = (SchemaImpl)((SchemaVertex)vertex).getObject();
            URI uRI = schemaImpl.getSaveAsLocation();
            URI uRI2 = schemaImpl.getTargetNamespace();
            this.schemaInfo.addNamespace(uRI2);
            if (uRI != null) {
                this.schemaInfo.add(uRI2, uRI);
            }
            if ((topComponentArray = schemaImpl.listTopComponent(true)) != null) {
                this.schemaInfo.add(uRI2, topComponentArray);
            }
            if ((annotationArray = schemaImpl.listAnnotation()) != null) {
                this.schemaInfo.add(uRI2, annotationArray);
            }
        }

        public SchemaInfo getSchemaInfo() {
            return this.schemaInfo;
        }
    }

    public static class SchemaInfo {
        private static final String nullURIKey = "nullURIKey";
        private Hashtable ns_locations = new Hashtable();
        private Hashtable ns_topComps = new Hashtable();
        private Hashtable ns_annos = new Hashtable();
        private TreeSet namespaces = new TreeSet(new URIComparator());

        private void addNamespace(URI uRI) {
            this.namespaces.add(uRI);
        }

        private void add(URI uRI, URI uRI2) {
            if (uRI2 == null) {
                return;
            }
            Object object = uRI == null ? nullURIKey : uRI;
            TreeSet<URI> treeSet = (TreeSet<URI>)this.ns_locations.get(object);
            if (treeSet == null) {
                treeSet = new TreeSet<URI>(new LocationComparator());
                this.ns_locations.put(object, treeSet);
            }
            treeSet.add(uRI2);
        }

        private void add(URI uRI, TopComponent[] topComponentArray) {
            if (topComponentArray == null) {
                return;
            }
            Object object = uRI == null ? nullURIKey : uRI;
            Vector<TopComponent> vector = (Vector<TopComponent>)this.ns_topComps.get(object);
            if (vector == null) {
                vector = new Vector<TopComponent>();
                this.ns_topComps.put(object, vector);
            }
            vector.addAll(Arrays.asList(topComponentArray));
        }

        private void add(URI uRI, Annotation[] annotationArray) {
            if (annotationArray == null) {
                return;
            }
            Object object = uRI == null ? nullURIKey : uRI;
            Vector<Annotation> vector = (Vector<Annotation>)this.ns_annos.get(object);
            if (vector == null) {
                vector = new Vector<Annotation>();
                this.ns_annos.put(object, vector);
            }
            vector.addAll(Arrays.asList(annotationArray));
        }

        public URI[] getLocations(URI uRI) {
            Object object = uRI == null ? nullURIKey : uRI;
            Collection collection = (Collection)this.ns_locations.get(object);
            if (collection == null || collection.size() == 0) {
                return null;
            }
            return collection.toArray(new URI[collection.size()]);
        }

        public Annotation[] getAnnotations(URI uRI) {
            Object object = uRI == null ? nullURIKey : uRI;
            Collection collection = (Collection)this.ns_annos.get(object);
            if (collection == null || collection.size() == 0) {
                return null;
            }
            return collection.toArray(new Annotation[collection.size()]);
        }

        public TopComponent[] getTopComponents(URI uRI) {
            Object object = uRI == null ? nullURIKey : uRI;
            Collection collection = (Collection)this.ns_topComps.get(object);
            if (collection == null || collection.size() == 0) {
                return null;
            }
            return collection.toArray(new TopComponent[collection.size()]);
        }

        public URI[] getNamespaces() {
            return this.namespaces.toArray(new URI[this.namespaces.size()]);
        }
    }

    public class ObjectRegistry {
        private Hashtable registry = new Hashtable();

        public UID register(Object object) {
            Entry entry;
            Vector<Entry> vector = (Vector<Entry>)this.registry.get(object);
            if (vector == null) {
                vector = new Vector<Entry>();
                this.registry.put(object, vector);
            }
            int n = 0;
            while (n < vector.size()) {
                entry = (Entry)vector.get(n);
                if (entry.obj == object) {
                    return entry.uid;
                }
                ++n;
            }
            entry = new Entry(object);
            vector.add(entry);
            return entry.uid;
        }

        public UID isAlreadyRegistered(Object object) {
            Vector vector = (Vector)this.registry.get(object);
            if (vector == null) {
                vector = new Vector();
                this.registry.put(object, vector);
            }
            int n = 0;
            while (n < vector.size()) {
                Entry entry = (Entry)vector.get(n);
                if (entry.obj == object) {
                    return entry.uid;
                }
                ++n;
            }
            return null;
        }

        private class Entry {
            private Object obj;
            private UID uid;

            private Entry(Object object) {
                this.obj = object;
                this.uid = new UID();
            }
        }
    }
}

