/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.viewandvisitor;

import com.ibm.sketch.viewandvisitor.SchemaObjectView;
import com.ibm.sketch.viewandvisitor.ViewModifiedVisitor;
import com.ibm.sketch.viewandvisitor.ViewModifiedVisitorParcel;
import com.ibm.xml.ecm.schema.SchemaObject;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class SchemaObjectViewImpl
implements SchemaObjectView {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SchemaObject schemaObject;
    private boolean modified;

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setChildrenModified(boolean bl) {
        SchemaObject schemaObject = this.getSchemaObject();
        if (schemaObject == null) {
            return;
        }
        ViewModifiedVisitor viewModifiedVisitor = new ViewModifiedVisitor();
        ViewModifiedVisitorParcel viewModifiedVisitorParcel = new ViewModifiedVisitorParcel();
        viewModifiedVisitorParcel.setModified(bl);
        viewModifiedVisitor.setVisitorParcel(viewModifiedVisitorParcel);
        schemaObject.accept(viewModifiedVisitor);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (this.areParentsModifiedOnChange()) {
            this.setParentModified(bl);
        }
        if (this.areChildrenModifiedOnChange()) {
            this.setChildrenModified(bl);
        }
    }

    public void setModifiedNoRecursion(boolean bl) {
        this.modified = bl;
    }

    public void setParentModified(boolean bl) {
        SchemaObject schemaObject = this.getSchemaObject();
        if (schemaObject == null) {
            return;
        }
        SchemaObject schemaObject2 = schemaObject.getParent();
        if (schemaObject2 == null) {
            return;
        }
        Hashtable[] hashtableArray = schemaObject2.getViews();
        if (hashtableArray != null) {
            int n = 0;
            while (n < hashtableArray.length) {
                Hashtable hashtable = hashtableArray[n];
                if (hashtable != null) {
                    Enumeration enumeration = hashtable.elements();
                    while (enumeration.hasMoreElements()) {
                        SchemaObjectViewImpl schemaObjectViewImpl = (SchemaObjectViewImpl)enumeration.nextElement();
                        schemaObjectViewImpl.setModified(bl);
                    }
                }
                ++n;
            }
        }
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }

    public abstract String toXMLString();

    public abstract void removeFromParent();

    public abstract boolean areParentsModifiedOnChange();

    public abstract boolean areChildrenModifiedOnChange();
}

