/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.viewandvisitor;

import com.ibm.sketch.viewandvisitor.SchemaObjectVisitorImpl;
import com.ibm.xml.ecm.schema.AttributeGroupDef;
import com.ibm.xml.ecm.schema.AttributesSpec;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ComplexTypeSpec;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.LocalAttributeDecl;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.RedefineStatement;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.TypeSpec;
import com.ibm.xml.ecm.schema.impl.RedefineStatementImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;

public class SetFormVisitor
extends SchemaObjectVisitorImpl {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final byte UNSET = 0;
    public static final byte TRUE = 1;
    public static final byte FALSE = 2;
    private byte attributeFormQualified = 0;
    private byte elementFormQualified = 0;

    public SetFormVisitor() {
    }

    protected SetFormVisitor(byte by, byte by2) {
        this.attributeFormQualified = by;
        this.elementFormQualified = by2;
    }

    public void setElementFormQualified(boolean bl) {
        this.elementFormQualified = (byte)(bl ? 1 : 2);
    }

    public void setAttributeFormQualified(boolean bl) {
        this.attributeFormQualified = (byte)(bl ? 1 : 2);
    }

    public void visitAttributeGroupDef(AttributeGroupDef attributeGroupDef) {
        AttributesSpec attributesSpec = attributeGroupDef.getAttributesSpec();
        if (attributesSpec != null) {
            attributesSpec.accept(this);
        }
    }

    public void visitAttributesSpec(AttributesSpec attributesSpec) {
        LocalAttributeDecl[] localAttributeDeclArray = attributesSpec.listAttributeDecl();
        if (localAttributeDeclArray != null) {
            int n = 0;
            while (n < localAttributeDeclArray.length) {
                localAttributeDeclArray[n].accept(this);
                ++n;
            }
        }
    }

    public void visitLocalAttributeDecl(LocalAttributeDecl localAttributeDecl) {
        if (!localAttributeDecl.isFormAttributeSpecified()) {
            if (this.attributeFormQualified == 1) {
                localAttributeDecl.setFormQualified(true);
            } else if (this.attributeFormQualified == 2) {
                localAttributeDecl.setFormQualified(false);
            }
        }
    }

    public void visitModelGroupDef(ModelGroupDef modelGroupDef) {
        Group group = modelGroupDef.getGroup();
        if (group != null) {
            group.accept(this);
        }
    }

    public void visitGroup(Group group) {
        Particle[] particleArray = group.listParticle();
        if (particleArray != null) {
            int n = 0;
            while (n < particleArray.length) {
                particleArray[n].accept(this);
                ++n;
            }
        }
    }

    public void visitLocalElementDecl(LocalElementDecl localElementDecl) {
        TypeSpec typeSpec;
        if (!localElementDecl.isFormAttributeSpecified()) {
            if (this.elementFormQualified == 1) {
                localElementDecl.setFormQualified(true);
            } else if (this.elementFormQualified == 2) {
                localElementDecl.setFormQualified(false);
            }
        }
        if ((typeSpec = localElementDecl.getTypeSpec()).getParent() == localElementDecl) {
            typeSpec.accept(this);
        }
    }

    public void visitComplexTypeDef(ComplexTypeDef complexTypeDef) {
        ComplexTypeSpec complexTypeSpec = complexTypeDef.getComplexTypeSpec();
        if (complexTypeSpec != null) {
            complexTypeSpec.accept(this);
        }
    }

    public void visitComplexTypeSpec(ComplexTypeSpec complexTypeSpec) {
        ContentModel contentModel;
        AttributesSpec attributesSpec = complexTypeSpec.getExplicitAttributesSpec();
        if (attributesSpec != null) {
            attributesSpec.accept(this);
        }
        if ((contentModel = complexTypeSpec.getExplicitContentModel()) != null) {
            contentModel.accept(this);
        }
    }

    public void visitContentModel(ContentModel contentModel) {
        Particle particle = contentModel.getParticle();
        if (particle != null) {
            particle.accept(this);
        }
    }

    public void visitRedefineStatement(RedefineStatement redefineStatement) {
        if (redefineStatement == null) {
            return;
        }
        SchemaObject[] schemaObjectArray = ((RedefineStatementImpl)redefineStatement).getChildren();
        int n = 0;
        while (n < schemaObjectArray.length) {
            schemaObjectArray[n].accept(this);
            ++n;
        }
    }

    public void visitSchema(Schema schema) {
        SchemaObject[] schemaObjectArray = ((SchemaImpl)schema).getChildren();
        if (schemaObjectArray != null) {
            int n = 0;
            while (n < schemaObjectArray.length) {
                schemaObjectArray[n].accept(this);
                ++n;
            }
        }
    }
}

