/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.viewandvisitor;

import com.ibm.sketch.viewandvisitor.ReferenceVisitor;
import com.ibm.xml.ecm.schema.AttributeGroupRef;
import com.ibm.xml.ecm.schema.AttributeRef;
import com.ibm.xml.ecm.schema.ComplexTypeRef;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.ModelGroupRef;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.impl.ReferenceImpl;

public class UnlinkReferencesVisitor
extends ReferenceVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TopComponent[] topComps;

    public UnlinkReferencesVisitor(TopComponent[] topComponentArray) {
        this.topComps = topComponentArray;
    }

    public void visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
        this.visitReference(attributeGroupRef);
    }

    public void visitAttributeRef(AttributeRef attributeRef) {
        this.visitReference(attributeRef);
    }

    public void visitComplexTypeRef(ComplexTypeRef complexTypeRef) {
        this.visitReference(complexTypeRef);
    }

    public void visitDatatypeRef(DatatypeRef datatypeRef) {
        this.visitReference(datatypeRef);
    }

    public void visitElementRef(ElementRef elementRef) {
        this.visitReference(elementRef);
    }

    public void visitModelGroupRef(ModelGroupRef modelGroupRef) {
        this.visitReference(modelGroupRef);
    }

    public void visitReference(Reference reference) {
        if (this.topComps != null) {
            int n = 0;
            while (n < this.topComps.length) {
                if (ReferenceImpl.isAReferenceTo(this.topComps[n], reference)) {
                    reference.unlink();
                    break;
                }
                ++n;
            }
        }
    }

    public void visitTypeRef(TypeRef typeRef) {
        this.visitReference(typeRef);
    }
}

