/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.viewandvisitor;

import com.ibm.sketch.viewandvisitor.SchemaObjectView;
import com.ibm.sketch.viewandvisitor.SchemaObjectViewImpl;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitor;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitorImpl;
import com.ibm.sketch.viewandvisitor.ViewModifiedVisitorParcel;
import com.ibm.xml.ecm.schema.Annotation;
import com.ibm.xml.ecm.schema.AttributeGroupDef;
import com.ibm.xml.ecm.schema.AttributeGroupRef;
import com.ibm.xml.ecm.schema.AttributeRef;
import com.ibm.xml.ecm.schema.AttributeWildcard;
import com.ibm.xml.ecm.schema.AttributesSpec;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ComplexTypeRef;
import com.ibm.xml.ecm.schema.ComplexTypeSpec;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.DatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.DatatypeSpec;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.GlobalAttributeDecl;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.IdentityConstraint;
import com.ibm.xml.ecm.schema.ImportStatement;
import com.ibm.xml.ecm.schema.IncludeStatement;
import com.ibm.xml.ecm.schema.Info;
import com.ibm.xml.ecm.schema.Key;
import com.ibm.xml.ecm.schema.KeyRef;
import com.ibm.xml.ecm.schema.LocalAttributeDecl;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.ModelGroupRef;
import com.ibm.xml.ecm.schema.NotationDecl;
import com.ibm.xml.ecm.schema.NotationRef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ParticleWildcard;
import com.ibm.xml.ecm.schema.PrimitiveDatatype;
import com.ibm.xml.ecm.schema.RedefineStatement;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.TypeSpec;
import com.ibm.xml.ecm.schema.Unique;
import com.ibm.xml.ecm.schema.Wildcard;
import com.ibm.xml.ecm.schema.XpathContainer;
import com.ibm.xml.ecm.schema.impl.AnnotationImpl;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeDefImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.DerivationByList;
import com.ibm.xml.ecm.schema.impl.DerivationByRestriction;
import com.ibm.xml.ecm.schema.impl.DerivationByUnion;
import com.ibm.xml.ecm.schema.impl.GlobalElementDeclImpl;
import com.ibm.xml.ecm.schema.impl.LocalElementDeclImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ViewModifiedVisitor
extends SchemaObjectVisitorImpl
implements SchemaObjectVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void setViewsModified(SchemaObject schemaObject) {
        if (schemaObject == null) {
            return;
        }
        ViewModifiedVisitorParcel viewModifiedVisitorParcel = (ViewModifiedVisitorParcel)this.getVisitorParcel();
        boolean bl = viewModifiedVisitorParcel.getModified();
        Hashtable[] hashtableArray = schemaObject.getViews();
        if (hashtableArray != null) {
            int n = 0;
            while (n < hashtableArray.length) {
                Hashtable hashtable = hashtableArray[n];
                if (hashtable != null) {
                    Enumeration enumeration = hashtable.elements();
                    while (enumeration.hasMoreElements()) {
                        SchemaObjectViewImpl schemaObjectViewImpl = (SchemaObjectViewImpl)enumeration.nextElement();
                        schemaObjectViewImpl.setModifiedNoRecursion(bl);
                    }
                }
                ++n;
            }
        }
    }

    public void visitAnnotation(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        this.setViewsModified(annotation);
        if (annotation.listInfo() != null) {
            int n = 0;
            while (n < annotation.listInfo().length) {
                if (annotation.listInfo()[n] != null) {
                    ((AnnotationImpl)annotation).accept(this);
                }
                ++n;
            }
        }
    }

    public void visitAttributeGroupDef(AttributeGroupDef attributeGroupDef) {
        if (attributeGroupDef == null) {
            return;
        }
        this.setViewsModified(attributeGroupDef);
        if (attributeGroupDef.getAttributesSpec() != null) {
            attributeGroupDef.getAttributesSpec().accept(this);
        }
        if (attributeGroupDef.getAnnotation() != null) {
            attributeGroupDef.getAnnotation().accept(this);
        }
    }

    public void visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
        if (attributeGroupRef == null) {
            return;
        }
        this.setViewsModified(attributeGroupRef);
        if (attributeGroupRef != null && attributeGroupRef.getAnnotation() != null) {
            attributeGroupRef.getAnnotation().accept(this);
        }
    }

    public void visitAttributeRef(AttributeRef attributeRef) {
        if (attributeRef == null) {
            return;
        }
        this.setViewsModified(attributeRef);
        if (attributeRef.getAnnotation() != null) {
            attributeRef.getAnnotation().accept(this);
        }
    }

    public void visitAttributesSpec(AttributesSpec attributesSpec) {
        if (attributesSpec == null) {
            return;
        }
        this.setViewsModified(attributesSpec);
        LocalAttributeDecl[] localAttributeDeclArray = attributesSpec.listAttributeDecl();
        int n = 0;
        while (n < localAttributeDeclArray.length) {
            ((SchemaObject)localAttributeDeclArray[n]).accept(this);
            ++n;
        }
        AttributeGroupRef[] attributeGroupRefArray = attributesSpec.listAttrGroupRef();
        int n2 = 0;
        while (n2 < attributeGroupRefArray.length) {
            attributeGroupRefArray[n2].accept(this);
            ++n2;
        }
        AttributeRef[] attributeRefArray = attributesSpec.listAttributeRef();
        int n3 = 0;
        while (n3 < attributeRefArray.length) {
            attributeRefArray[n3].accept(this);
            ++n3;
        }
        AttributeWildcard attributeWildcard = attributesSpec.getExplicitWildcard();
        if (attributeWildcard != null) {
            attributeWildcard.accept(this);
        }
        if (attributesSpec.getAnnotation() != null) {
            attributesSpec.getAnnotation().accept(this);
        }
    }

    public void visitAttributeWildcard(AttributeWildcard attributeWildcard) {
        if (attributeWildcard == null) {
            return;
        }
        this.setViewsModified(attributeWildcard);
        Wildcard wildcard = attributeWildcard.getWildcard();
        wildcard.accept(this);
        if (attributeWildcard.getAnnotation() != null) {
            attributeWildcard.getAnnotation().accept(this);
        }
    }

    public void visitComplexTypeDef(ComplexTypeDef complexTypeDef) {
        if (complexTypeDef == null) {
            return;
        }
        this.setViewsModified(complexTypeDef);
    }

    public void visitComplexTypeRef(ComplexTypeRef complexTypeRef) {
    }

    public void visitComplexTypeSpec(ComplexTypeSpec complexTypeSpec) {
        ContentType contentType;
        block18: {
            if (complexTypeSpec == null) {
                return;
            }
            this.setViewsModified(complexTypeSpec);
            if (complexTypeSpec.getAnnotation() != null) {
                complexTypeSpec.getAnnotation().accept(this);
            }
            contentType = null;
            try {
                contentType = ((ComplexTypeSpecImpl)complexTypeSpec).getEffectiveContentTypeWithoutErrorChecking();
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                if (!Debug.DEBUG) break block18;
                referenceResolutionException.printStackTrace(System.err);
            }
        }
        boolean bl = false;
        if (contentType != null) {
            bl = contentType.isSimpleType();
        } else if (complexTypeSpec.listFacet() != null && complexTypeSpec.listFacet().length > 0) {
            bl = true;
        }
        TypeInfo typeInfo = complexTypeSpec.getBasetype();
        if (bl) {
            Facet[] facetArray;
            if (complexTypeSpec.getDerivationType() == 0 && (facetArray = complexTypeSpec.listFacet()) != null) {
                int n = 0;
                while (n < facetArray.length) {
                    facetArray[n].accept(this);
                    ++n;
                }
            }
        } else {
            Particle particle;
            ContentModel contentModel = complexTypeSpec.getContentModel();
            if (contentModel != null && !contentModel.isEmptyContentModel() && (particle = contentModel.getParticle()) != null) {
                if (!particle.isGroup() && !particle.isModelGroupRef()) {
                    particle.accept(this);
                } else if (particle.isGroup()) {
                    particle.asGroup().accept(this);
                } else {
                    particle.asModelGroupRef().accept(this);
                }
            }
        }
        if (complexTypeSpec.getExplicitAttributesSpec() != null) {
            complexTypeSpec.getExplicitAttributesSpec().accept(this);
        }
        if (typeInfo != null && !typeInfo.isAReference()) {
            ((SchemaObject)((Object)typeInfo)).accept(this);
        }
    }

    public void visitDatatypeDef(DatatypeDef datatypeDef) {
        if (datatypeDef == null) {
            return;
        }
        this.setViewsModified(datatypeDef);
        DatatypeSpec datatypeSpec = ((DatatypeDefImpl)datatypeDef).getDatatypeSpec();
        datatypeSpec.accept(this);
    }

    public void visitDatatypeRef(DatatypeRef datatypeRef) {
    }

    public void visitDatatypeSpec(DatatypeSpec datatypeSpec) {
        if (datatypeSpec == null) {
            return;
        }
        this.setViewsModified(datatypeSpec);
        if (datatypeSpec.getAnnotation() != null) {
            datatypeSpec.getAnnotation().accept(this);
        }
        if (((DatatypeSpecImpl)datatypeSpec).getMethod() != null) {
            ((DatatypeSpecImpl)datatypeSpec).getMethod().accept(this, null);
        }
    }

    public Node visitDerivationByList(DerivationByList derivationByList, SchemaObjectView schemaObjectView) {
        Facet[] facetArray;
        if (derivationByList == null) {
            return null;
        }
        TypeInfo[] typeInfoArray = derivationByList.getType().listUsedtype();
        if (typeInfoArray != null && !typeInfoArray[0].isAReference()) {
            ((SchemaObject)((Object)typeInfoArray[0])).accept(this);
        }
        if ((facetArray = derivationByList.getType().getFacets()) != null) {
            int n = 0;
            while (n < facetArray.length) {
                facetArray[n].accept(this);
                ++n;
            }
        }
        return null;
    }

    public Node visitDerivationByRestriction(DerivationByRestriction derivationByRestriction, SchemaObjectView schemaObjectView) {
        Facet[] facetArray;
        if (derivationByRestriction == null) {
            return null;
        }
        TypeInfo typeInfo = derivationByRestriction.getType().getBasetype();
        if (typeInfo != null && !typeInfo.isAReference()) {
            ((SchemaObject)((Object)typeInfo)).accept(this);
        }
        if ((facetArray = derivationByRestriction.getType().getFacets()) != null) {
            int n = 0;
            while (n < facetArray.length) {
                facetArray[n].accept(this);
                ++n;
            }
        }
        return null;
    }

    public Node visitDerivationByUnion(DerivationByUnion derivationByUnion, SchemaObjectView schemaObjectView) {
        Facet[] facetArray;
        if (derivationByUnion == null) {
            return null;
        }
        TypeRef[] typeRefArray = derivationByUnion.getType().listUsedtypeRef();
        TypeSpec[] typeSpecArray = derivationByUnion.getType().listUsedtypeSpec();
        if (typeSpecArray != null) {
            int n = 0;
            while (n < typeSpecArray.length) {
                typeSpecArray[n].accept(this);
                ++n;
            }
        }
        if ((facetArray = derivationByUnion.getType().getFacets()) != null) {
            int n = 0;
            while (n < facetArray.length) {
                facetArray[n].accept(this);
                ++n;
            }
        }
        return null;
    }

    public void visitElementRef(ElementRef elementRef) {
        if (elementRef == null) {
            return;
        }
        this.setViewsModified(elementRef);
        if (elementRef.getAnnotation() != null) {
            elementRef.getAnnotation().accept(this);
        }
    }

    public void visitFacet(Facet facet) {
        if (facet == null) {
            return;
        }
        this.setViewsModified(facet);
        String[] stringArray = facet.getValuesAsString();
        if (stringArray != null && facet.getAnnotation() != null) {
            facet.getAnnotation().accept(this);
        }
    }

    public void visitGlobalAttributeDecl(GlobalAttributeDecl globalAttributeDecl) {
        TypeInfo typeInfo;
        DatatypeSpecImpl datatypeSpecImpl;
        if (globalAttributeDecl == null) {
            return;
        }
        this.setViewsModified(globalAttributeDecl);
        if (globalAttributeDecl.getAnnotation() != null) {
            globalAttributeDecl.getAnnotation().accept(this);
        }
        if (globalAttributeDecl.getDatatypeSpec() != null && (datatypeSpecImpl = (DatatypeSpecImpl)globalAttributeDecl.getDatatypeSpec()) != null && (typeInfo = datatypeSpecImpl.getBasetype()) != null) {
            TypeRef typeRef = typeInfo.asTypeRef();
            if (!datatypeSpecImpl.isIdenticalToItsBasetype() || typeRef == null) {
                datatypeSpecImpl.accept(this);
            }
        }
    }

    public void visitGlobalElementDecl(GlobalElementDecl globalElementDecl) {
        if (globalElementDecl == null) {
            return;
        }
        this.setViewsModified(globalElementDecl);
        if (globalElementDecl.getAnnotation() != null) {
            globalElementDecl.getAnnotation().accept(this);
        }
        if (globalElementDecl.getTypeSpec() != null) {
            TypeRef typeRef;
            TypeRef typeRef2 = typeRef = globalElementDecl.getTypeSpec().getBasetype() == null ? null : globalElementDecl.getTypeSpec().getBasetype().asTypeRef();
            if (((GlobalElementDeclImpl)globalElementDecl).mustReturnTypeSpec()) {
                globalElementDecl.getTypeSpec().accept(this);
            }
        }
        if (globalElementDecl.listIdentityConstraint() != null) {
            int n = 0;
            while (n < globalElementDecl.listIdentityConstraint().length) {
                if (globalElementDecl.listIdentityConstraint()[n] != null) {
                    globalElementDecl.listIdentityConstraint()[n].accept(this);
                }
                ++n;
            }
        }
    }

    public void visitGroup(Group group) {
        if (group == null) {
            return;
        }
        this.setViewsModified(group);
        if (group.getAnnotation() != null) {
            group.getAnnotation().accept(this);
        }
        Particle[] particleArray = group.listParticle();
        int n = 0;
        while (n < particleArray.length) {
            particleArray[n].accept(this);
            ++n;
        }
    }

    public Element visitIdentityConstraint(IdentityConstraint identityConstraint) {
        if (identityConstraint == null) {
            return null;
        }
        if (identityConstraint.getSelector() != null) {
            identityConstraint.getSelector().accept(this);
        }
        if (identityConstraint.listField() != null) {
            int n = 0;
            while (n < identityConstraint.listField().length) {
                if (identityConstraint.listField()[n].getValue() != null) {
                    identityConstraint.listField()[n].accept(this);
                }
                ++n;
            }
        }
        return null;
    }

    public void visitImportStatement(ImportStatement importStatement) {
        if (importStatement == null) {
            return;
        }
        this.setViewsModified(importStatement);
    }

    public void visitIncludeStatement(IncludeStatement includeStatement) {
        if (includeStatement == null) {
            return;
        }
        this.setViewsModified(includeStatement);
    }

    public void visitInfo(Info info) {
        this.setViewsModified(info);
    }

    public void visitKey(Key key) {
        if (key == null) {
            return;
        }
        this.setViewsModified(key);
        this.visitUnique(key);
    }

    public void visitKeyRef(KeyRef keyRef) {
        if (keyRef == null) {
            return;
        }
        this.setViewsModified(keyRef);
    }

    public void visitLocalAttributeDecl(LocalAttributeDecl localAttributeDecl) {
        this.setViewsModified(localAttributeDecl);
        if (localAttributeDecl.getAnnotation() != null) {
            localAttributeDecl.getAnnotation().accept(this);
        }
        if (localAttributeDecl.getDatatypeSpec() != null) {
            TypeRef typeRef;
            TypeRef typeRef2 = typeRef = localAttributeDecl.getDatatypeSpec().getBasetype() == null ? null : localAttributeDecl.getDatatypeSpec().getBasetype().asTypeRef();
            if (!((DatatypeSpecImpl)localAttributeDecl.getDatatypeSpec()).isIdenticalToItsBasetype() || typeRef == null) {
                localAttributeDecl.getDatatypeSpec().accept(this);
            }
        }
    }

    public void visitLocalElementDecl(LocalElementDecl localElementDecl) {
        IdentityConstraint[] identityConstraintArray;
        if (localElementDecl == null) {
            return;
        }
        this.setViewsModified(localElementDecl);
        if (localElementDecl.getAnnotation() != null) {
            localElementDecl.getAnnotation().accept(this);
        }
        if (localElementDecl.getTypeSpec() != null) {
            IdentityConstraint[] identityConstraintArray2 = identityConstraintArray = localElementDecl.getTypeSpec().getBasetype() == null ? null : localElementDecl.getTypeSpec().getBasetype().asTypeRef();
            if (((LocalElementDeclImpl)localElementDecl).mustReturnTypeSpec()) {
                localElementDecl.getTypeSpec().accept(this);
            }
        }
        identityConstraintArray = localElementDecl.listIdentityConstraint();
        int n = 0;
        while (n < identityConstraintArray.length) {
            identityConstraintArray[n].accept(this);
            ++n;
        }
    }

    public void visitModelGroupDef(ModelGroupDef modelGroupDef) {
        if (modelGroupDef == null) {
            return;
        }
        this.setViewsModified(modelGroupDef);
        if (modelGroupDef.getAnnotation() != null) {
            modelGroupDef.getAnnotation().accept(this);
        }
        if (modelGroupDef.getGroup() != null) {
            modelGroupDef.getGroup().accept(this);
        }
    }

    public void visitModelGroupRef(ModelGroupRef modelGroupRef) {
        if (modelGroupRef == null) {
            return;
        }
        this.setViewsModified(modelGroupRef);
        if (modelGroupRef.getAnnotation() != null) {
            modelGroupRef.getAnnotation().accept(this);
        }
    }

    public void visitNotationDecl(NotationDecl notationDecl) {
        if (notationDecl == null) {
            return;
        }
        this.setViewsModified(notationDecl);
        if (notationDecl.getAnnotation() != null) {
            notationDecl.getAnnotation().accept(this);
        }
    }

    public void visitNotationRef(NotationRef notationRef) {
    }

    public void visitParticleWildcard(ParticleWildcard particleWildcard) {
        if (particleWildcard == null) {
            return;
        }
        this.setViewsModified(particleWildcard);
    }

    public void visitPrimitiveDatatype(PrimitiveDatatype primitiveDatatype) {
        if (primitiveDatatype == null) {
            return;
        }
        this.setViewsModified(primitiveDatatype);
    }

    public void visitRedefineStatement(RedefineStatement redefineStatement) {
        TopComponent[] topComponentArray;
        if (redefineStatement == null) {
            return;
        }
        this.setViewsModified(redefineStatement);
        Annotation[] annotationArray = redefineStatement.listAnnotation();
        if (annotationArray != null) {
            int n = 0;
            while (n < annotationArray.length) {
                annotationArray[n].accept(this);
                ++n;
            }
        }
        if ((topComponentArray = redefineStatement.listRedefinedComponent()) != null) {
            int n = 0;
            while (n < topComponentArray.length) {
                topComponentArray[n].accept(this);
                ++n;
            }
        }
    }

    public void visitSchema(Schema schema) {
        if (schema == null) {
            return;
        }
        this.setViewsModified(schema);
        Vector vector = ((SchemaImpl)schema).getChildrenOfSchemaElt();
        int n = 0;
        while (n < vector.size()) {
            ((SchemaObject)vector.elementAt(n)).accept(this);
            ++n;
        }
    }

    public void visitUnique(Unique unique) {
        if (unique == null) {
            return;
        }
        this.visitIdentityConstraint(unique);
    }

    public void visitWildcard(Wildcard wildcard) {
        this.setViewsModified(wildcard);
    }

    public void visitXpathContainer(XpathContainer xpathContainer) {
        if (xpathContainer == null) {
            return;
        }
        this.setViewsModified(xpathContainer);
        if (xpathContainer.getAnnotation() != null) {
            xpathContainer.getAnnotation().accept(this);
        }
    }
}

