/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.viewandvisitor;

import com.ibm.sketch.viewandvisitor.W3cXmlDocumentView;
import com.ibm.sketch.viewandvisitor.XmlDocumentViewImpl;
import com.ibm.xml.ecm.schema.SchemaObject;
import java.io.StringWriter;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class W3cXmlDocumentViewImpl
extends XmlDocumentViewImpl
implements W3cXmlDocumentView {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Node domNode;
    private static Document document;
    private String xmlString;

    public boolean areChildrenModifiedOnChange() {
        return true;
    }

    public boolean areParentsModifiedOnChange() {
        return false;
    }

    public Document getDocument() {
        if (document == null) {
            document = new DocumentImpl();
        }
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node getDomNode() {
        if (!(this.domNode instanceof NodeImpl)) return null;
        if (this.domNode == null) return null;
        SchemaObject schemaObject = this.getSchemaObject();
        if (schemaObject == null) return null;
        if (document == null) {
            return null;
        }
        ((NodeImpl)this.domNode).setUserData(schemaObject);
        return this.domNode;
    }

    public String getXmlString() {
        if (this.xmlString == null) {
            this.xmlString = this.toXMLString();
        }
        return this.xmlString;
    }

    public void removeFromParent() {
        Node node;
        Node node2 = this.getDomNode();
        if (node2 != null && (node = node2.getParentNode()) != null) {
            node.removeChild(node2);
            return;
        }
    }

    public void setDocument(Document document) {
        W3cXmlDocumentViewImpl.document = document;
    }

    public void setDomNode(Node node) {
        Node node2;
        if (this.domNode != null && (node2 = this.domNode.getParentNode()) != null) {
            node2.replaceChild(node, this.domNode);
        }
        this.domNode = node;
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        this.xmlString = null;
    }

    public void setTheString(String string) {
        this.xmlString = string;
    }

    public String toXMLString() {
        try {
            Node node = this.getDomNode();
            Object object = null;
            if (node instanceof NodeImpl) {
                object = ((NodeImpl)node).getUserData();
            }
            DocumentImpl documentImpl = new DocumentImpl();
            Node node2 = documentImpl.importNode(node, true);
            documentImpl.appendChild(node2);
            if (object != null && node2 instanceof NodeImpl) {
                ((NodeImpl)node2).setUserData(object);
            }
            StringWriter stringWriter = new StringWriter();
            OutputFormat outputFormat = new OutputFormat(documentImpl);
            outputFormat.setOmitXMLDeclaration(true);
            outputFormat.setIndenting(false);
            XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
            xMLSerializer.serialize(documentImpl);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }
}

