/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.GroupException;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.impl.TypeSpecImpl;

public class AllGroupNotAllowedException
extends GroupException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Group notAllowedAllGroup;

    public AllGroupNotAllowedException(Group group, Group group2) {
        this(group, group2, null);
    }

    public AllGroupNotAllowedException(Group group, Group group2, ComplexType complexType) {
        super(group, complexType);
        if (group2.getCompositor() != 2) {
            throw new IllegalArgumentException(group2 + " must be an AllGroup");
        }
        this.notAllowedAllGroup = group2;
    }

    public Group getAllGroup() {
        return this.notAllowedAllGroup;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Type getFirstAncestorWithAllGroup() {
        Type type = null;
        try {
            Particle particle;
            ComplexType complexType;
            ContentModel contentModel;
            TypeInfo typeInfo;
            Type type2 = this.getComplexType();
            if (type2 == null) {
                return null;
            }
            while (!((typeInfo = type2.getBasetype()) == null || (type2 = (type = typeInfo.resolveToType())).isComplexType() && (contentModel = (complexType = (ComplexType)type2).getExplicitContentModel()) != null && (particle = contentModel.getParticle()) != null && particle.isGroup() && particle.asGroup().getCompositor() == 2)) {
            }
            if (typeInfo != null) return type;
            return null;
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            return null;
        }
    }

    public String getMessage() {
        if (this.getComplexType() != null) {
            Particle particle;
            Type type = null;
            if (this.getComplexType() instanceof TypeSpecImpl) {
                type = ((TypeSpecImpl)((Object)this.getComplexType())).getNamedType();
            }
            type = type == null ? this.getComplexType() : type;
            Type type2 = this.getFirstAncestorWithAllGroup();
            Type type3 = null;
            if (type2 instanceof TypeSpecImpl) {
                type3 = ((TypeSpecImpl)type2).getNamedType();
            }
            Type type4 = type2 = type3 == null ? type2 : type3;
            if (type2 != null) {
                return "Effective content model of " + type + " includes the <all> as part of an implied" + " sequence with the <all> from that type's ancestor, " + type2 + ".  Since <all> cannot" + " appear inside sequence, even implied, " + type + " is invalid.  <all> cannot be used" + " in a complexType which is derived.";
            }
            ContentModel contentModel = this.getComplexType().getExplicitContentModel();
            if (contentModel != null && (particle = contentModel.getParticle()) != null && particle.isGroup() && particle.asGroup().getCompositor() == 2) {
                return "Effective content model of " + type + " includes the <all> as part of an implied" + " sequence with the <all> from that type.  Since <all> cannot" + " appear inside sequence, even implied, " + type + " is invalid.  <all> cannot be used" + " in a complexType which is derived.";
            }
            return "Effective content model of " + type + " includes the <all> as part of an implied" + " sequence with the <all> from that type or one of its ancestors.  Since <all> cannot" + " appear inside sequence, even implied, " + type + " is invalid.  <all> cannot be used" + " in a complexType which is derived.";
        }
        return "An all group is not allowed as member of another group";
    }
}

