/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.sketch.util.DuplicationFinder;
import com.ibm.sketch.util.ElementDeclComparator;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.GroupException;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.TopComponent;
import java.util.Arrays;

public class AmbiguousContentModelException
extends GroupException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Particle[] overlappingParticles;
    private Particle invalidParticle;

    public AmbiguousContentModelException(Group group, Particle[] particleArray) {
        this(group, particleArray, null);
    }

    public AmbiguousContentModelException(Group group, Particle[] particleArray, ComplexType complexType) {
        super(group, complexType);
        this.overlappingParticles = particleArray;
    }

    private static boolean areInSameSubstitutionGroup(Particle particle, Particle particle2) {
        return AmbiguousContentModelException.isPartOfSubstitutionGroup(particle, particle2) || AmbiguousContentModelException.isPartOfSubstitutionGroup(particle2, particle);
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ambiguous content model");
        if (this.getComplexType() != null) {
            stringBuffer.append(" in the effective content model of " + this.getComplexType());
        }
        if (this.overlappingParticles != null) {
            stringBuffer.append(" : the following particles overlap :\n");
            TopComponent topComponent = null;
            int n = 0;
            while (n < this.overlappingParticles.length) {
                topComponent = this.overlappingParticles[n].getTopComponentAncestor();
                if (topComponent != null && topComponent.getComponentType() == 5) {
                    if (n < this.overlappingParticles.length - 1) {
                        stringBuffer.append(this.overlappingParticles[n] + " from " + topComponent + ", \n");
                    } else {
                        stringBuffer.append(this.overlappingParticles[n] + " from " + topComponent + " \n");
                    }
                } else if (n < this.overlappingParticles.length - 1) {
                    stringBuffer.append(this.overlappingParticles[n] + ", \n");
                } else {
                    stringBuffer.append(this.overlappingParticles[n] + " \n");
                }
                ++n;
            }
            try {
                if (this.overlappingParticles.length == 2) {
                    ElementDeclComparator elementDeclComparator = new ElementDeclComparator();
                    ElementDecl elementDecl = null;
                    ElementDecl elementDecl2 = null;
                    if (this.overlappingParticles[0].isElementRef()) {
                        elementDecl = (GlobalElementDecl)this.overlappingParticles[0].asElementRef().resolve(false);
                    } else if (this.overlappingParticles[0].isElementDecl()) {
                        elementDecl = this.overlappingParticles[0].asElementDecl();
                    }
                    if (this.overlappingParticles[1].isElementRef()) {
                        elementDecl2 = (GlobalElementDecl)this.overlappingParticles[1].asElementRef().resolve(false);
                    } else if (this.overlappingParticles[1].isElementDecl()) {
                        elementDecl2 = this.overlappingParticles[1].asElementDecl();
                    }
                    if (elementDecl != null && elementDecl2 != null && elementDeclComparator.compare(elementDecl, elementDecl2) != 0 && AmbiguousContentModelException.areInSameSubstitutionGroup(this.overlappingParticles[0], this.overlappingParticles[1])) {
                        if (!this.overlappingParticles[0].isElementDecl() && !this.overlappingParticles[1].isElementDecl()) {
                            stringBuffer.append(" because the two particles are members of the same substitution Group");
                        } else {
                            String string = null;
                            String string2 = null;
                            if (this.overlappingParticles[0].isElementDecl()) {
                                string = "first";
                                string2 = "second";
                            } else if (this.overlappingParticles[1].isElementDecl()) {
                                string = "second";
                                string2 = "first";
                            }
                            if (string != null && string2 != null) {
                                stringBuffer.append(" because the " + string + " particle has the same name and target namespace as");
                                stringBuffer.append(" a member of the substitution group of the " + string2 + " particle");
                            }
                        }
                    }
                }
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                // empty catch block
            }
        }
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public Particle[] getOverlappingParticles() {
        return this.overlappingParticles;
    }

    private static boolean isPartOfSubstitutionGroup(Particle particle, Particle particle2) {
        try {
            GlobalElementDecl globalElementDecl;
            Object[] objectArray;
            if (!particle.isElementRef()) {
                return false;
            }
            ElementRef elementRef = particle.asElementRef();
            ElementDecl elementDecl = particle2.asElementDecl();
            if (elementDecl == null && particle2.isElementRef()) {
                elementDecl = (GlobalElementDecl)particle2.asElementRef().resolve(false);
            }
            if ((objectArray = (globalElementDecl = (GlobalElementDecl)elementRef.resolve(false)).getSubstitutionGroupMembers()) == null) {
                return false;
            }
            ElementDeclComparator elementDeclComparator = new ElementDeclComparator();
            Arrays.sort(objectArray, elementDeclComparator);
            return DuplicationFinder.getObjectsEqualToInAnOrderedArray(objectArray, elementDecl, elementDeclComparator) != null;
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            return false;
        }
    }
}

