/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.xml.ecm.schema.AttributeDecl;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.RefinementException;
import com.ibm.xml.ecm.schema.Type;

public class AttributeIncompatibleWithBasetypeAttributeException
extends RefinementException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final short OCCURENCE_INCOMPATIBLE = 1;
    public static final short FIXED_VALUE_INCOMPATIBLE = 2;
    public static final short TYPE_INCOMPATIBLE = 3;
    private int explaination = -1;
    private AttributeDecl basetypeAttribute;
    private AttributeDecl incompatibleAttribute;

    public AttributeIncompatibleWithBasetypeAttributeException(ComplexType complexType, AttributeDecl attributeDecl, AttributeDecl attributeDecl2) {
        this(complexType, attributeDecl, attributeDecl2, 0);
    }

    public AttributeIncompatibleWithBasetypeAttributeException(ComplexType complexType, AttributeDecl attributeDecl, AttributeDecl attributeDecl2, short s) {
        super(complexType);
        this.incompatibleAttribute = attributeDecl2;
        this.basetypeAttribute = attributeDecl;
        this.explaination = s;
    }

    public AttributeDecl getBasetypeAttribute() {
        return this.basetypeAttribute;
    }

    public AttributeDecl getIncompatibleAttribute() {
        return this.incompatibleAttribute;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TYPE REFINEMENT ERROR :\n");
        stringBuffer.append("In the definition of " + this.getType() + ", " + this.incompatibleAttribute + " is not ");
        Type type = this.getType();
        switch (type.getDerivationType()) {
            case 0: {
                stringBuffer.append(" a restriction of ");
                break;
            }
            case 1: {
                stringBuffer.append(" an extension of ");
                break;
            }
            default: {
                stringBuffer.append(" compatible with ");
            }
        }
        stringBuffer.append(this.basetypeAttribute + " which is defined in one of its ancestors.");
        switch (this.explaination) {
            case 3: {
                if (type.getDerivationType() == 0) {
                    stringBuffer.append(" The type of " + this.incompatibleAttribute + " must be derived from or must be  equal to the type of " + this.basetypeAttribute + ".");
                    break;
                }
                stringBuffer.append(" The type of " + this.incompatibleAttribute + " must be equal to the type of " + this.basetypeAttribute + ".");
                break;
            }
            case 2: {
                if (type.getDerivationType() != 0) break;
                stringBuffer.append(" The fixed value of " + this.incompatibleAttribute + " must be the same as the one of " + this.basetypeAttribute + ".");
                break;
            }
            case 1: {
                if (type.getDerivationType() != 0) break;
                stringBuffer.append("The use attribute of " + this.incompatibleAttribute + " must restrict the use attribute of " + this.basetypeAttribute + ".");
            }
        }
        return stringBuffer.toString();
    }
}

