/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.RefinementException;
import com.ibm.xml.ecm.schema.Type;

public class ContentTypeIncompatibleWithBasetypeContentTypeException
extends RefinementException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ContentType basetypeEffectiveContentType;
    private ContentType candidateEffectiveContentType;

    public ContentTypeIncompatibleWithBasetypeContentTypeException(Type type, ContentType contentType, ContentType contentType2) {
        super(type);
        this.basetypeEffectiveContentType = contentType;
        this.candidateEffectiveContentType = contentType2;
    }

    public ContentType getBasetypeEffectiveContentType() {
        return this.basetypeEffectiveContentType;
    }

    public ContentType getCandidateEffectiveContentType() {
        return this.candidateEffectiveContentType;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TYPE REFINEMENT ERROR (content type incompatible with the content type of the basetype):\n");
        stringBuffer.append("In the definition of " + this.getType() + ", " + this.candidateEffectiveContentType + " is not");
        Type type = this.getType();
        if (type == null) {
            stringBuffer.append(" compatible with ");
        } else {
            switch (type.getDerivationType()) {
                case 0: {
                    stringBuffer.append(" a restriction of ");
                    break;
                }
                case 1: {
                    stringBuffer.append(" an extension of ");
                    break;
                }
                default: {
                    stringBuffer.append(" compatible with ");
                }
            }
        }
        stringBuffer.append(this.basetypeEffectiveContentType + ", the content type defined by the basetype.");
        return stringBuffer.toString();
    }
}

