/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.sketch.parser.SchemaTags;
import com.ibm.xml.ecm.schema.DatatypeException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.SimpleType;

public class DatatypeFormatException
extends DatatypeException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int CONTEXT_DEFAULT = -3;
    public static final int CONTEXT_FIXED = -2;
    public static final int CONTEXT_NOCONTEXT = -1;
    public static final int CONTEXT_LENGH = 7;
    public static final int CONTEXT_MAXLENGH = 10;
    public static final int CONTEXT_MINLENGTH = 11;
    public static final int CONTEXT_PATTERN = 5;
    public static final int CONTEXT_ENUMERATION = 6;
    public static final int CONTEXT_WHITESPACE = 12;
    public static final int CONTEXT_MAXINCLUSIVE = 1;
    public static final int CONTEXT_MAXEXCLUSIVE = 3;
    public static final int CONTEXT_MININCLUSIVE = 2;
    public static final int CONTEXT_MINEXCLUSIVE = 4;
    public static final int CONTEXT_PRECISION = 8;
    public static final int CONTEXT_SCALE = 9;
    private String invalidString;
    private Facet[] facetsNotSatisfied;
    private SimpleType type;
    private Exception[] exs;
    private int context = -1;
    private String errorMessage;

    public DatatypeFormatException(SimpleType simpleType, Facet[] facetArray, String string, Exception[] exceptionArray) {
        this(simpleType, facetArray, string, exceptionArray, -1);
    }

    public DatatypeFormatException(SimpleType simpleType, Facet[] facetArray, String string, Exception[] exceptionArray, int n) {
        this.type = simpleType;
        this.facetsNotSatisfied = facetArray;
        this.invalidString = string;
        this.exs = exceptionArray;
        this.context = n;
    }

    public DatatypeFormatException(SimpleType simpleType, String string) {
        this(simpleType, string, -1);
    }

    public DatatypeFormatException(SimpleType simpleType, String string, String string2) {
        this(simpleType, string, -1);
        this.errorMessage = string2;
    }

    public DatatypeFormatException(SimpleType simpleType, String string, Exception[] exceptionArray) {
        this(simpleType, string, exceptionArray, -1);
    }

    public DatatypeFormatException(SimpleType simpleType, String string, Exception[] exceptionArray, int n) {
        this(simpleType, null, string, exceptionArray, n);
    }

    public DatatypeFormatException(SimpleType simpleType, String string, int n) {
        this(simpleType, null, string, null, n);
    }

    public String getContext() {
        switch (this.context) {
            case -3: {
                return "default";
            }
            case -2: {
                return "fixed";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return SchemaTags.getFacetName(this.context);
            }
        }
        return null;
    }

    public Facet[] getFacets() {
        return this.facetsNotSatisfied;
    }

    public String getInvalidString() {
        return this.invalidString;
    }

    public String getMessage() {
        String string = "\"" + this.invalidString + "\"" + this.printContext() + " is not of the type : " + this.type + ".";
        if (this.errorMessage != null) {
            return string + " " + this.errorMessage;
        }
        if (this.exs == null || this.exs.length == 0) {
            return string;
        }
        if (this.exs.length == 1) {
            return string + " " + this.exs[0].getMessage();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + " due to the following errors : \n");
        int n = 0;
        while (n < this.exs.length) {
            stringBuffer.append(this.exs[n].getMessage() + " \n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public SimpleType getSimpleType() {
        return this.type;
    }

    protected final String printContext() {
        String string = this.getContext();
        return string == null ? "" : " which was specified for " + string + " value,";
    }

    public void setContext(int n) {
        this.context = n;
    }
}

