/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.sketch.parser.SchemaTags;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.RefinementException;
import com.ibm.xml.ecm.schema.Type;

public class FacetsRequiredException
extends RefinementException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int[] requiredFacets;

    public FacetsRequiredException(GlobalElementDecl globalElementDecl, int[] nArray) {
        super(globalElementDecl);
        this.requiredFacets = nArray;
    }

    public FacetsRequiredException(Type type, int[] nArray) {
        super(type);
        this.requiredFacets = nArray;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getGlobalElementDecl() == null) {
            stringBuffer.append(this.getType());
        } else {
            stringBuffer.append(this.getGlobalElementDecl());
        }
        stringBuffer.append(" requires the following facets : \n");
        if (this.requiredFacets != null) {
            int n = 0;
            while (n < this.requiredFacets.length) {
                stringBuffer.append(SchemaTags.getFacetName(this.requiredFacets[n]) + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public int[] getRequiredFacets() {
        return this.requiredFacets;
    }
}

