/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.sketch.parser.SchemaTags;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.RefinementException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;

public class IncompatibleFacetException
extends RefinementException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Facet incompatibleFacet;
    private Facet facet;
    private boolean isIncompatibleWithAncestor;
    private Type ancestorWithIncompatibleFacet;

    public IncompatibleFacetException(Type type, Facet facet, Facet facet2, boolean bl) {
        super(type);
        this.facet = facet;
        this.incompatibleFacet = facet2;
        this.isIncompatibleWithAncestor = bl;
    }

    public Type getAncestorWithIncompatibleFacet() {
        if (!this.isIncompatibleWithAncestor) {
            return null;
        }
        if (this.ancestorWithIncompatibleFacet != null) {
            return this.ancestorWithIncompatibleFacet;
        }
        try {
            TypeInfo typeInfo = this.getType().getBasetype();
            while (typeInfo != null) {
                Type type = typeInfo.resolveToType();
                if (type.isSimpleType()) {
                    if (((SimpleType)type).getFacetDefinedHere(this.incompatibleFacet.getFacetType()) != null) {
                        this.ancestorWithIncompatibleFacet = type;
                        return type;
                    }
                } else if (type.isComplexType() && ((ComplexType)type).getFacetDefinedHere(this.incompatibleFacet.getFacetType()) != null) {
                    this.ancestorWithIncompatibleFacet = type;
                    return type;
                }
                typeInfo = type.getBasetype();
            }
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            // empty catch block
        }
        this.ancestorWithIncompatibleFacet = null;
        return null;
    }

    public Facet getFacet() {
        return this.facet;
    }

    public Facet getIncompatibleFacet() {
        return this.incompatibleFacet;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.incompatibleFacet == null) {
            stringBuffer.append("Facet " + SchemaTags.getFacetName(this.facet.getFacetType()) + " is not allowed by " + this.getType());
        } else {
            stringBuffer.append("In the definition of " + this.getType() + ", " + this.facet + " is not compatible with the following facets defined in ");
            Type type = null;
            if (this.isIncompatibleWithAncestor) {
                stringBuffer.append("one of the ancestors of " + this.getType());
                type = this.getAncestorWithIncompatibleFacet();
                if (type != null) {
                    stringBuffer.append(", specifically " + type + " :\n");
                }
            } else {
                stringBuffer.append(this.getType() + " :\n");
            }
            stringBuffer.append(this.incompatibleFacet);
            if (type != null && type.getDerivationType() == 2 && this.incompatibleFacet.getFacetType() == 12) {
                stringBuffer.append("(this fixed facet is implicitly defined by list datatypes).");
            }
            stringBuffer.append(" \n");
        }
        return stringBuffer.toString();
    }

    public boolean isIncompatibleWithAncestor() {
        return this.isIncompatibleWithAncestor;
    }
}

