/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.sketch.util.xpath.XPath;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.IdentityConstraint;
import com.ibm.xml.ecm.schema.IdentityConstraintException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.XpathContainer;

public class InconsistentIdentityConstraintException
extends IdentityConstraintException {
    private XpathContainer inconsistentXPath;

    public InconsistentIdentityConstraintException(IdentityConstraint identityConstraint, XpathContainer xpathContainer) {
        super(identityConstraint);
        this.inconsistentXPath = xpathContainer;
        this.setSchemaExceptionType(1);
    }

    protected String getExplanation(String string, Integer[] integerArray, Boolean[] booleanArray) throws SchemaException {
        StringBuffer stringBuffer = new StringBuffer();
        ElementDecl elementDecl = (ElementDecl)((Object)this.getInvalidIdentityConstraint().getParent());
        if (elementDecl == null) {
            return stringBuffer.toString();
        }
        XPath xPath = this.getInconstistentXPath().getXPath();
        XPath.LocationPath[] locationPathArray = xPath.getLocationPaths();
        if (integerArray != null && locationPathArray != null) {
            int n = 0;
            while (n < integerArray.length) {
                try {
                    if (integerArray[n] != null) {
                        XPath.Step[] stepArray = new XPath.Step[integerArray[n] + 1];
                        System.arraycopy(locationPathArray[n].steps, 0, stepArray, 0, integerArray[n] + 1);
                        XPath.LocationPath locationPath = new XPath.LocationPath(stepArray);
                        String string2 = elementDecl.getTargetNamespace() == null ? "" : elementDecl.getTargetNamespace().toString() + ":";
                        string2 = string2 + elementDecl.getNCName();
                        string = string == null || string.trim().equals("") ? "" : "(" + string + ")/";
                        stringBuffer.append("Invalid XPath starting from " + string2 + ":" + string + locationPath);
                        if (booleanArray[n] == null) {
                            stringBuffer.append(". \n");
                        } else {
                            XPath.Step[] stepArray2;
                            if (booleanArray[n].booleanValue() && (stepArray2 = locationPath.steps) != null && stepArray2.length > 0) {
                                stringBuffer.append(", but there is an attribute " + stepArray2[stepArray2.length - 1] + ";");
                                stringBuffer.append(" check if you omitted the '@' character before " + stepArray2[stepArray2.length - 1] + " in the xpath");
                            }
                            stringBuffer.append(". \n");
                        }
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    stringBuffer.append(". \n");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public XpathContainer getInconstistentXPath() {
        return this.inconsistentXPath;
    }
}

