/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.xmi.xmi11temp.IBMXMIDocument;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;

public class InvalidOrNotExistingSchemaException
extends ReferenceResolutionException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Schema schema;
    private URI location;
    private Exception exception;

    public InvalidOrNotExistingSchemaException(Schema schema, Exception exception) {
        this.schema = schema;
        String string = schema.getXMIDocument().getDocumentURL();
        URI uRI = (URI)((Object)((IBMXMIDocument)schema.getXMIDocument()).newInstance(FactoryImplGen.URI_MOFClass));
        if (string.endsWith(".xmi")) {
            uRI.setValue(string.substring(0, string.length() - 4));
        } else {
            uRI.setValue(string);
        }
        this.location = uRI;
        this.exception = exception;
    }

    public InvalidOrNotExistingSchemaException(URI uRI, Exception exception) {
        this.location = uRI;
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public URI getLocation() {
        return this.location;
    }

    public String getMessage() {
        if (this.exception == null) {
            return "The schema locatted at  " + this.location + " is invalid or is not found";
        }
        return "The schema named at " + this.location + " is invalid or is not found due to the following error :\n" + this.exception.getMessage();
    }

    public Schema getSchema() {
        return this.schema;
    }
}

