/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.URI;

public class MalformedURIException
extends SchemaException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String malformedURI;
    protected URI uri;
    protected Exception ex;
    protected boolean malformedAbsoluteURI = false;

    public MalformedURIException(URI uRI) {
        this(uRI, false);
    }

    public MalformedURIException(URI uRI, boolean bl) {
        this(uRI, bl, null);
    }

    public MalformedURIException(URI uRI, boolean bl, Exception exception) {
        this.malformedURI = uRI.toString();
        this.uri = uRI;
        this.malformedAbsoluteURI = bl;
        this.ex = exception;
    }

    public MalformedURIException(String string) {
        this(string, false);
    }

    public MalformedURIException(String string, boolean bl) {
        this(string, bl, null);
    }

    public MalformedURIException(String string, boolean bl, Exception exception) {
        this.malformedURI = string;
        this.malformedAbsoluteURI = bl;
        this.ex = exception;
    }

    public URI getInvalidURI() {
        return this.uri;
    }

    public String getMalformedURI() {
        return this.malformedURI;
    }

    public String getMessage() {
        String string = "";
        if (this.ex != null) {
            string = this.ex.getMessage();
        }
        String string2 = " is not a valid " + (this.malformedAbsoluteURI ? "absolute " : "") + "URI. ";
        String string3 = "The empty string" + string2 + string;
        if (this.uri != null) {
            if (this.uri.toString().equals("")) {
                return string3;
            }
            return this.uri.toString() + string2 + string;
        }
        if (this.malformedURI != null && !this.malformedURI.trim().equals("")) {
            return this.malformedURI + string2 + string;
        }
        return string3;
    }
}

