/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.RedefinitionException;

public class ModelGroupRedefinitionException
extends RedefinitionException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int nbOfReferencesToTheRedefinedComponent = 0;
    private boolean minAndMaxOccursConsistent = true;

    public ModelGroupRedefinitionException(ModelGroupDef modelGroupDef, int n) {
        super(modelGroupDef);
        this.nbOfReferencesToTheRedefinedComponent = n;
        if (n == 1) {
            this.minAndMaxOccursConsistent = false;
        }
    }

    public String getMessage() {
        if (this.nbOfReferencesToTheRedefinedComponent > 1) {
            return "REDEFINITION ERROR : " + this.getTopComponent() + " must include exactly one reference to itself";
        }
        if (this.nbOfReferencesToTheRedefinedComponent == 1) {
            return "REDEFINITION ERROR : the model group reference to " + this.getTopComponent() + " must have its minOccurs and its maxOccurs equal to \"1\"";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("REDEFINITION ERROR : " + this.getTopComponent() + "  must either : \n");
        stringBuffer.append("1/ include exactly one reference to itself \n");
        stringBuffer.append("or \n");
        stringBuffer.append("2/ be a valid restriction of the model group with the same name and target namespace defined in the redefined schema");
        return stringBuffer.toString();
    }

    public int numberOfReferencesToTheRedefinedComponent() {
        return this.nbOfReferencesToTheRedefinedComponent;
    }
}

