/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.sketch.util.URIComparator;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import java.util.Arrays;

public class NoSchemaDeclarationFoundException
extends ReferenceResolutionException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String location;
    protected static URI[] previousTNSForSchemaForSchema;
    protected String schemaNS;

    public NoSchemaDeclarationFoundException(String string, String string2) {
        this.location = string;
        this.schemaNS = string2;
        try {
            if (previousTNSForSchemaForSchema == null) {
                Factory factory = FactoryImpl.instance();
                previousTNSForSchemaForSchema = new URI[]{factory.createURI("http://www.w3.org/1999/XMLSchema"), factory.createURI("http://www.w3.org/2000/03/XMLSchema"), factory.createURI("http://www.w3.org/2000/10/XMLSchema")};
                Arrays.sort(previousTNSForSchemaForSchema, new URIComparator());
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException(" Application Unexpected Exception : " + datatypeFormatException);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessage() {
        String string = "There is no W3C XML schema found at " + this.location + ".  Either specify  -wsdl -xform  or  -emb, if the schema is contained" + " as content of another element, or make sure that the document element is of the form <prefix:schema>" + " and  there is the namespace declaration xmlns:prefix=\"" + "http://www.w3.org/2001/XMLSchema" + "\".";
        try {
            if (this.schemaNS != null) {
                URI uRI = FactoryImpl.instance().createURI(this.schemaNS);
                if (Arrays.binarySearch(previousTNSForSchemaForSchema, uRI, new URIComparator()) < 0) {
                    return string;
                }
                return "The version of Schema Quality Checker you are running checks schema in the \"http://www.w3.org/2001/XMLSchema\" syntax. The schema located at " + this.location + " uses an earlier syntax. No checking can be performed on this schema.";
            }
            return string;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            return string;
        }
    }

    public String getSchemaNS() {
        return this.schemaNS;
    }
}

