/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;

public class NoSchemaOfAGivenNamespaceFoundException
extends ReferenceResolutionException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private URI location;
    private URI namespace;
    private int composition = 0;
    public static final int IMPORT = 3;
    public static final int INCLUDE = 1;
    public static final int REDEFINE = 2;

    public NoSchemaOfAGivenNamespaceFoundException(URI uRI, URI uRI2, int n) {
        this.namespace = uRI;
        this.location = uRI2;
        this.composition = n;
    }

    public NoSchemaOfAGivenNamespaceFoundException(URI uRI, String string, int n) {
        this.namespace = uRI;
        URI uRI2 = FactoryImpl.instance().createURI();
        uRI2.setValue(string);
        this.location = uRI2;
        this.composition = n;
    }

    public URI getLocation() {
        return this.location;
    }

    public String getMessage() {
        Object var1_1 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.namespace == null) {
            stringBuffer.append("There is no W3C XML Schema found at " + this.location + " without any target namespace. ");
        } else {
            stringBuffer.append("There is no W3C XML Schema found at " + this.location + " with the target namespace " + this.namespace + ". ");
        }
        if (this.composition == 1 || this.composition == 2) {
            String string;
            String string2 = this.composition == 1 ? "including" : "redefining";
            String string3 = this.composition == 1 ? "included" : "redefined";
            String string4 = string = this.composition == 1 ? "include" : "redefine";
            if (this.namespace == null) {
                stringBuffer.append("The " + string2 + " schema has no target namespace. ");
                stringBuffer.append("Either add a targetNamespace to the " + string2 + "schema, or ");
                stringBuffer.append(string + " a file which does not specify targetNamespace");
            } else {
                stringBuffer.append("The targetNamespaces of the " + string2 + " and the " + string3 + " schema document must be the same ");
                stringBuffer.append("or the " + string3 + " schema document must not specify targetNamespace");
            }
        } else if (this.composition == 3) {
            stringBuffer.append("The namespace in the \"import\" declaration and the targetNamespace of the imported file must be the same.");
        }
        return stringBuffer.toString();
    }

    public URI getNamespace() {
        return this.namespace;
    }
}

