/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.sketch.parser.NameWithPrefix;
import com.ibm.sketch.parser.SchemaTags;
import com.ibm.xml.ecm.schema.ImportStatement;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;

public class TopComponentNotFoundException
extends ReferenceResolutionException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Reference ref;
    private Exception ex;
    private String[] suggestedPrefixes = null;
    private ImportStatement[] suggestedImports = null;

    public TopComponentNotFoundException(Reference reference, Exception exception) {
        this(reference, exception, null, null);
    }

    public TopComponentNotFoundException(Reference reference, Exception exception, String[] stringArray, ImportStatement[] importStatementArray) {
        this.ref = reference;
        this.ex = exception;
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        if (importStatementArray != null && importStatementArray.length == 0) {
            importStatementArray = null;
        }
        this.suggestedPrefixes = stringArray;
        this.suggestedImports = importStatementArray;
    }

    public String capitalizationMismatchMessage() {
        Schema schema;
        if (this.ref == null || (schema = this.ref.getSchema()) == null) {
            return "";
        }
        String string = this.ref.getPrefix();
        URI uRI = this.ref.getTargetNamespace();
        if (string == null || uRI == null) {
            return "";
        }
        String string2 = uRI.toString();
        if (string2 == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.equals("")) {
            stringBuffer.append("The prefix \"" + string + "\" is associated with a namespace \"" + uRI + "\"");
        } else {
            stringBuffer.append("The empty string prefix is associated with a namespace \"" + uRI + "\"");
        }
        boolean bl = false;
        if (schema.getTargetNamespace() != null && schema.getTargetNamespace().toString() != null && string2.equalsIgnoreCase(schema.getTargetNamespace().toString()) && !string2.equals(schema.getTargetNamespace().toString())) {
            ImportStatement[] importStatementArray = schema.listImportStatement();
            bl = true;
            if (importStatementArray != null) {
                int n = 0;
                while (n < importStatementArray.length) {
                    URI uRI2 = importStatementArray[n].getExplicitTargetNamespace();
                    if (uRI2 != null && string2.equals(uRI2.toString())) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            if (bl) {
                stringBuffer.append(" which is not identical to the targetNamespace");
                stringBuffer.append(" although it is identical if capitalization was ignored.");
            }
        } else {
            ImportStatement[] importStatementArray = schema.listImportStatement();
            if (importStatementArray != null) {
                int n = 0;
                while (n < importStatementArray.length) {
                    URI uRI3 = importStatementArray[n].getExplicitTargetNamespace();
                    if (uRI3 != null && uRI3.toString() != null) {
                        if (string2.equals(uRI3.toString())) {
                            bl = false;
                            break;
                        }
                        if (!bl && string2.equalsIgnoreCase(uRI3.toString())) {
                            stringBuffer.append(" which is not identical to the namespace of " + importStatementArray[n]);
                            stringBuffer.append(" although it is identical if capitalization was ignored.");
                            bl = true;
                        }
                    }
                    ++n;
                }
            }
        }
        if (!bl) {
            return "";
        }
        stringBuffer.append(" XML is capitalization sensitive.  Please check");
        stringBuffer.append(" if these two namespace should be the same.");
        return stringBuffer.toString();
    }

    public Exception getException() {
        return this.ex;
    }

    public String getMessage() {
        String string = new NameWithPrefix(this.ref.getPrefix(), this.ref.getNCName()).toString();
        String string2 = "The global " + SchemaTags.getTopComponentTagName(this.ref.getTopComponentType()) + " referenced by '" + string + "' does not exist.";
        if (this.suggestedPrefixes != null && this.suggestedPrefixes.length > 0) {
            if (this.suggestedPrefixes.length == 1) {
                String string3 = new NameWithPrefix(this.suggestedPrefixes[0], this.ref.getNCName()).toString();
                string2 = string2 + " '" + string3 + "' would be a valid reference.";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < this.suggestedPrefixes.length) {
                    String string4 = "'" + new NameWithPrefix(this.suggestedPrefixes[n], this.ref.getNCName()).toString() + "'";
                    if (n == 0) {
                        stringBuffer.append(string4);
                    } else {
                        stringBuffer.append(", " + string4);
                    }
                    ++n;
                }
                string2 = string2 + " There are several schemas among those read as a result of <import> or <include> that might" + " be what you meant: " + stringBuffer + ".  Decide which was meant and insert the appropriate namespace prefix before " + this.ref.getNCName() + ".";
            }
        } else if (this.suggestedImports != null && this.suggestedImports.length > 0) {
            String string5 = this.ref.getSchemaComponentType() == 127 ? "type" : SchemaTags.getTopComponentTagName(this.ref.getTopComponentType());
            if (this.suggestedImports.length == 1) {
                URI uRI = this.suggestedImports[0].getExplicitTargetNamespace();
                URI uRI2 = this.suggestedImports[0].getLocation();
                string2 = string2 + " The imported namespace '" + uRI + "' from schemaLocation '" + uRI2 + "' contains a definition of " + string5 + " '" + this.ref.getNCName() + "'.  Action: add a namespace declaration to associate a prefix with '" + uRI + "' and then add that prefix before the reference to '" + this.ref.getNCName() + "'.";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < this.suggestedImports.length) {
                    URI uRI = this.suggestedImports[n].getExplicitTargetNamespace();
                    URI uRI3 = this.suggestedImports[n].getLocation();
                    String string6 = "namespace '" + uRI + "' from schemaLocation '" + uRI3 + "'";
                    if (n == 0) {
                        stringBuffer.append("\n" + string6);
                    } else {
                        stringBuffer.append(", \n" + string6);
                    }
                    ++n;
                }
                string2 = string2 + " There are several imported namespaces with schemaLocations that contain a definition of " + string5 + " '" + this.ref.getNCName() + "'.  These are \n" + stringBuffer + "." + " Action: Decide which was meant in this particular reference to '" + this.ref.getNCName() + "'." + " Add a namespace declaration to associate a prefix with that namespace" + " and then add that prefix before the reference to name. ";
            }
        } else {
            string2 = this.ex != null ? "The global " + SchemaTags.getTopComponentTagName(this.ref.getTopComponentType()) + " " + this.ref.getFullName() + " is not found due to the following error :\n " + this.ex + ". " + this.importStatementNeededMessage() + this.capitalizationMismatchMessage() : "The global " + SchemaTags.getTopComponentTagName(this.ref.getTopComponentType()) + " " + this.ref.getFullName() + " is not found. " + this.importStatementNeededMessage() + this.capitalizationMismatchMessage();
        }
        return string2;
    }

    public Reference getReference() {
        return this.ref;
    }

    public String importStatementNeededMessage() {
        URI uRI = this.ref.getTargetNamespace();
        if (uRI == null) {
            return "";
        }
        Schema schema = this.ref.getSchema();
        if (schema == null) {
            return "";
        }
        if (uRI.equals(schema.getTargetNamespace())) {
            return "";
        }
        URI uRI2 = FactoryImpl.instance().createURI();
        uRI2.setValue("http://www.w3.org/2001/XMLSchema");
        URI uRI3 = FactoryImpl.instance().createURI();
        uRI3.setValue("http://www.w3.org/2001/XMLSchema-datatypes");
        if (uRI2.equals(uRI) || uRI3.equals(uRI)) {
            return "";
        }
        ImportStatement[] importStatementArray = schema.listImportStatement();
        boolean bl = false;
        boolean bl2 = false;
        if (importStatementArray != null) {
            int n = 0;
            while (n < importStatementArray.length) {
                if (uRI.equals(importStatementArray[n].getExplicitTargetNamespace())) {
                    bl = true;
                    if (importStatementArray[n].getLocation() != null) {
                        bl2 = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            return "There is no import statement associated with the namespace '" + uRI + "'. ";
        }
        if (!bl2) {
            return "There is no schema location associated with the namespace '" + uRI + "', Schema Quality Checker needs schema location information ( defined in <import> elements) to resolve references. ";
        }
        return "";
    }
}

