/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema;

import com.ibm.sketch.parser.NameWithPrefix;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.TopComponentNotFoundException;
import com.ibm.xml.ecm.schema.impl.ReferenceImpl;

public class UnknownPrefixException
extends TopComponentNotFoundException {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String prefix;
    private String message = null;
    private String NCName;

    public UnknownPrefixException(Reference reference, String string) {
        super(reference, null);
        this.prefix = string;
    }

    public UnknownPrefixException(String string, String string2) {
        super(null, null);
        this.prefix = string;
        this.NCName = string2;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = new NameWithPrefix(this.prefix, this.getNCName()).toString();
        try {
            ReferenceImpl referenceImpl = (ReferenceImpl)this.getReference();
            if (referenceImpl != null && referenceImpl.getSchema() != null && referenceImpl.getSchema().getTopComponent(3, string) != null) {
                String string2 = referenceImpl.getSchema().getTargetNamespace() == null ? null : referenceImpl.getSchema().getTargetNamespace().toString();
                TopComponent topComponent = referenceImpl.getSchema().getTopComponent(referenceImpl.getTopComponentType(), string);
                String string3 = this.prefix == null ? null : this.prefix.trim();
                string3 = this.prefix == null || string3.equals("") ? "the empty string" : "\"" + string3 + "\"";
                string2 = "\"" + string2 + "\"";
                stringBuffer.append("The reference \"" + string + "\" uses " + string3 + " as its prefix." + "  But there is no namespace declaration which associates " + string3 + " with a namespace. The reference is to \"" + string + "\", and \"" + string + "\" is declared as " + "part of the targetNamespace " + string2 + " in this file.  You may have " + "omitted the attribute xmlns=" + string2 + ".");
                this.message = stringBuffer.toString();
                return this.message;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append("The reference " + string + " uses ");
        if (this.prefix.trim().equals("")) {
            stringBuffer.append("the empty string as its prefix. But there is no namespace declaration which associates the empty string with a namespace. To fix the problem, you may add the attribute \"xmlns\" in the root element (<schema>)");
        } else {
            stringBuffer.append("\"" + this.prefix + "\" as its prefix. But there is no namespace declaration which associates \"" + this.prefix + "\" with a namespace. To fix the problem, you may add the attribute \"xmlns:" + this.prefix + "\" in the root element (<schema>)");
        }
        this.message = stringBuffer.toString();
        return this.message;
    }

    public String getNCName() {
        if (this.NCName != null) {
            return this.NCName;
        }
        if (this.getReference() != null) {
            return this.getReference().getNCName();
        }
        return null;
    }

    public String getUnknownPrefix() {
        return this.prefix;
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

