/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.AllGroupNotAllowedException;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.GroupException;
import com.ibm.xml.ecm.schema.IllegalOccursValueForParticleInAllGroupException;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import java.util.Vector;

public class AllGroupLimitations_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SchemaException[] exceptions;
    private ComplexType complextype;
    public static CheckType ID = new CheckType("All Group limitations Checker");
    private Particle[] childrenParticles;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$Group;

    public AllGroupLimitations_Checker() {
    }

    public AllGroupLimitations_Checker(Group group) {
        super(group);
    }

    public AllGroupLimitations_Checker(Group group, ComplexType complexType) {
        super(group);
        this.complextype = complexType;
    }

    public boolean check(boolean bl) {
        Group group = (Group)this.subject;
        boolean bl2 = group.getCompositor() == 2;
        this.exceptions = null;
        Vector<GroupException> vector = new Vector<GroupException>();
        if (this.childrenParticles != null) {
            int n = 0;
            while (n < this.childrenParticles.length) {
                if (this.childrenParticles[n].isGroup() && this.childrenParticles[n].asGroup().getCompositor() == 2) {
                    vector.add(new AllGroupNotAllowedException(group, this.childrenParticles[n].asGroup(), this.complextype));
                    break;
                }
                if (bl2) {
                    String string = this.childrenParticles[n].getMaxOccurs();
                    if (!string.equals("0") && !string.equals("1")) {
                        vector.add(new IllegalOccursValueForParticleInAllGroupException(group, this.childrenParticles[n]));
                    } else {
                        SchemaObject schemaObject = group.getParent();
                        if (schemaObject instanceof Group) {
                            vector.add(new AllGroupNotAllowedException((Group)schemaObject, group, this.complextype));
                            break;
                        }
                    }
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            this.exceptions = new SchemaException[vector.size()];
            vector.copyInto(this.exceptions);
            return false;
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 2;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$Group == null ? (class$com$ibm$xml$ecm$schema$Group = AllGroupLimitations_Checker.class$("com.ibm.xml.ecm.schema.Group")) : class$com$ibm$xml$ecm$schema$Group;
    }

    public void setParticlesToCheck(Particle[] particleArray) {
        this.childrenParticles = particleArray;
    }

    public void setParticleToCheck(Particle particle) {
        this.setParticlesToCheck(new Particle[]{particle});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

