/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.AttributeWildcard;
import com.ibm.xml.ecm.schema.AttributeWildcardIncompatibleWithBasetypeException;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.Wildcard;
import com.ibm.xml.ecm.schema.WildcardIntersectionNotExpressibleException;
import com.ibm.xml.ecm.schema.WildcardUnionNotExpressibleException;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.ComplexTypeDerivationMethod_Checker;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.Debug;

public class AttributeWildcardCompatibleWithBasetype_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static CheckType ID = new CheckType("Attribute Wildcard Compatible with basetype's contentType Checker");
    private AttributeWildcard basetypeAnyAtt;
    private AttributeWildcard candidateAnyAtt;
    public static final Wildcard anyTypeWildcard = BuiltInDatatypeFactory.getInstance().getAnyType().getComplexTypeSpec().getExplicitAttributeWildcard();
    private SchemaException[] exceptions;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl;

    public AttributeWildcardCompatibleWithBasetype_Checker() {
    }

    public AttributeWildcardCompatibleWithBasetype_Checker(ComplexTypeSpecImpl complexTypeSpecImpl) {
        super(complexTypeSpecImpl);
    }

    public boolean check(boolean bl) {
        block19: {
            try {
                this.exceptions = null;
                ComplexTypeSpecImpl complexTypeSpecImpl = (ComplexTypeSpecImpl)this.subject;
                if (ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(complexTypeSpecImpl.getNamedType() == null ? complexTypeSpecImpl : complexTypeSpecImpl.getNamedType()) != null) {
                    return true;
                }
                TypeInfo typeInfo = complexTypeSpecImpl.getBasetype();
                if (typeInfo == null) {
                    return true;
                }
                this.basetypeAnyAtt = complexTypeSpecImpl.getBasetypeEffectiveAttributeWildcard();
                if (this.basetypeAnyAtt == null) {
                    return true;
                }
                this.candidateAnyAtt = complexTypeSpecImpl.getEffectiveAttributeWildcardWithoutChecking();
                ComplexType complexType = (ComplexType)complexTypeSpecImpl.getNamedType();
                ComplexType complexType2 = complexType = complexType == null ? complexTypeSpecImpl : complexType;
                if (complexTypeSpecImpl.getDerivationType() == 0) {
                    if (BuiltInDatatypeFactory.getInstance().getAnyType().equals(typeInfo.resolveToType())) {
                        return true;
                    }
                    if (this.candidateAnyAtt != null) {
                        switch (this.basetypeAnyAtt.getProcessContents()) {
                            case 0: {
                                if (this.candidateAnyAtt.getProcessContents() == 0) break;
                                this.exceptions = new SchemaException[]{new AttributeWildcardIncompatibleWithBasetypeException(complexType, this.basetypeAnyAtt, this.candidateAnyAtt)};
                                return false;
                            }
                            case 2: {
                                if (this.candidateAnyAtt.getProcessContents() != 1) break;
                                this.exceptions = new SchemaException[]{new AttributeWildcardIncompatibleWithBasetypeException(complexType, this.basetypeAnyAtt, this.candidateAnyAtt)};
                                return false;
                            }
                        }
                        if (this.basetypeAnyAtt == null || !this.candidateAnyAtt.isSubsetOf(this.basetypeAnyAtt)) {
                            this.exceptions = new SchemaException[]{new AttributeWildcardIncompatibleWithBasetypeException(complexType, this.basetypeAnyAtt, this.candidateAnyAtt)};
                            return false;
                        }
                    }
                    return true;
                }
                if (complexTypeSpecImpl.getDerivationType() == 1) {
                    if (!(this.basetypeAnyAtt == null || this.candidateAnyAtt != null && this.basetypeAnyAtt.isSubsetOf(this.candidateAnyAtt))) {
                        this.exceptions = new SchemaException[]{new AttributeWildcardIncompatibleWithBasetypeException(complexType, this.basetypeAnyAtt, this.candidateAnyAtt)};
                        return false;
                    }
                    return true;
                }
            }
            catch (WildcardIntersectionNotExpressibleException wildcardIntersectionNotExpressibleException) {
                if (Debug.DEBUG) {
                    wildcardIntersectionNotExpressibleException.printStackTrace(System.err);
                }
                this.exceptions = new SchemaException[]{wildcardIntersectionNotExpressibleException};
                return false;
            }
            catch (WildcardUnionNotExpressibleException wildcardUnionNotExpressibleException) {
                if (Debug.DEBUG) {
                    wildcardUnionNotExpressibleException.printStackTrace(System.err);
                }
                this.exceptions = new SchemaException[]{wildcardUnionNotExpressibleException};
                return false;
            }
            catch (SchemaException schemaException) {
                if (!Debug.DEBUG) break block19;
                schemaException.printStackTrace(System.err);
            }
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 3;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl == null ? (class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl = AttributeWildcardCompatibleWithBasetype_Checker.class$("com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl")) : class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl;
    }

    public void setBasetypeAttributeWildcard(AttributeWildcard attributeWildcard) {
        this.basetypeAnyAtt = attributeWildcard;
    }

    public void setCandidateAttributeWildcard(AttributeWildcard attributeWildcard) {
        this.candidateAnyAtt = attributeWildcard;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

