/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.AttributeDeclComparator;
import com.ibm.sketch.util.DuplicationFinder;
import com.ibm.xml.ecm.schema.AttributeDecl;
import com.ibm.xml.ecm.schema.AttributeIncompatibleWithBasetypeAttributeException;
import com.ibm.xml.ecm.schema.AttributeWildcard;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ComplexTypeSpec;
import com.ibm.xml.ecm.schema.DerivationByRestriction_AttributeDeclNotDefinedByBasetypeException;
import com.ibm.xml.ecm.schema.ProhibitedAttrNotInBaseTypeException;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.RefinementException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.AttributesSpecImpl;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.ComplexTypeDerivationMethod_Checker;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import java.util.Arrays;
import java.util.Vector;

public class AttributesCompatibleWithBasetype_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static CheckType ID = new CheckType("Attributes  Compatible with basetype's contentType Checker");
    private AttributeDecl[] basetypeAttributes;
    private AttributeDecl[] candidateAttributes;
    private SchemaException[] exceptions;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl;

    public AttributesCompatibleWithBasetype_Checker() {
    }

    public AttributesCompatibleWithBasetype_Checker(ComplexTypeSpecImpl complexTypeSpecImpl) {
        super(complexTypeSpecImpl);
    }

    public boolean check(boolean bl) {
        block8: {
            try {
                ComplexTypeSpecImpl complexTypeSpecImpl = (ComplexTypeSpecImpl)this.subject;
                this.exceptions = null;
                if (ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(complexTypeSpecImpl.getNamedType() == null ? complexTypeSpecImpl : complexTypeSpecImpl.getNamedType()) != null) {
                    return true;
                }
                TypeInfo typeInfo = complexTypeSpecImpl.getBasetype();
                if (typeInfo == null) {
                    return true;
                }
                this.basetypeAttributes = complexTypeSpecImpl.getBasetypeEffectiveAttributes();
                if (this.basetypeAttributes == null && complexTypeSpecImpl.getDerivationType() == 1) {
                    return true;
                }
                this.candidateAttributes = complexTypeSpecImpl.getEffectiveAttributesWithoutErrorChecking();
                if (complexTypeSpecImpl.getDerivationType() == 0) {
                    if (BuiltInDatatypeFactory.getInstance().getAnyType().equals(typeInfo.resolveToType())) {
                        return true;
                    }
                    return this.checkForDerivationByRestriction(bl);
                }
                if (complexTypeSpecImpl.getDerivationType() == 1) {
                    return this.checkForDerivationByExtension(bl);
                }
            }
            catch (SchemaException schemaException) {
                if (!Debug.DEBUG) break block8;
                schemaException.printStackTrace(System.err);
            }
        }
        return true;
    }

    public boolean checkForDerivationByExtension(boolean bl) {
        ComplexTypeSpecImpl complexTypeSpecImpl = (ComplexTypeSpecImpl)this.subject;
        ComplexType complexType = (ComplexType)complexTypeSpecImpl.getNamedType();
        complexType = complexType == null ? complexTypeSpecImpl : complexType;
        Vector<AttributeIncompatibleWithBasetypeAttributeException> vector = new Vector<AttributeIncompatibleWithBasetypeAttributeException>();
        this.exceptions = null;
        if (this.candidateAttributes != null) {
            AttributeDeclComparator attributeDeclComparator = new AttributeDeclComparator();
            Arrays.sort(this.candidateAttributes, attributeDeclComparator);
            if (this.basetypeAttributes != null) {
                int n = 0;
                while (n < this.basetypeAttributes.length) {
                    Object[] objectArray = DuplicationFinder.getObjectsEqualToInAnOrderedArray(this.candidateAttributes, this.basetypeAttributes[n], attributeDeclComparator);
                    if (objectArray == null) {
                        throw new RuntimeException("Implemenetation error : {attribute Declaration}  of the basetype is not a subset of {attribute declaration} of the ComplexType itself : " + this.basetypeAttributes[n]);
                    }
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        block11: {
                            try {
                                if (!AttributesCompatibleWithBasetype_Checker.isExtensionOf((AttributeDecl)objectArray[n2], this.basetypeAttributes[n])) {
                                    vector.add(new AttributeIncompatibleWithBasetypeAttributeException(complexType, this.basetypeAttributes[n], (AttributeDecl)objectArray[n2]));
                                }
                            }
                            catch (ReferenceResolutionException referenceResolutionException) {
                                if (!Debug.DEBUG) break block11;
                                referenceResolutionException.printStackTrace(System.err);
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        } else if (this.basetypeAttributes != null) {
            throw new RuntimeException("Implemenetation error : {attribute Declaration}  of the basetype is not a subset of {attribute declaration} of the ComplexType itself ");
        }
        if (vector.size() > 0) {
            this.exceptions = new SchemaException[vector.size()];
            vector.copyInto(this.exceptions);
            return false;
        }
        return true;
    }

    public boolean checkForDerivationByRestriction(boolean bl) {
        Vector<RefinementException> vector;
        block15: {
            block11: {
                ComplexType complexType;
                AttributeWildcard attributeWildcard;
                block9: {
                    ComplexTypeSpecImpl complexTypeSpecImpl = (ComplexTypeSpecImpl)this.subject;
                    vector = new Vector<RefinementException>();
                    this.exceptions = null;
                    attributeWildcard = null;
                    complexType = (ComplexType)complexTypeSpecImpl.getNamedType();
                    complexType = complexType == null ? complexTypeSpecImpl : complexType;
                    try {
                        attributeWildcard = AttributesCompatibleWithBasetype_Checker.getBasetypeAttributeWildcard(complexTypeSpecImpl);
                    }
                    catch (SchemaException schemaException) {
                        if (!Debug.DEBUG) break block9;
                        schemaException.printStackTrace(System.err);
                    }
                }
                if (this.candidateAttributes == null) break block11;
                AttributeDeclComparator attributeDeclComparator = new AttributeDeclComparator();
                this.basetypeAttributes = this.basetypeAttributes == null ? new AttributeDecl[]{} : this.basetypeAttributes;
                Arrays.sort(this.basetypeAttributes, attributeDeclComparator);
                int n = 0;
                while (n < this.candidateAttributes.length) {
                    block14: {
                        Object[] objectArray;
                        block12: {
                            block13: {
                                objectArray = DuplicationFinder.getObjectsEqualToInAnOrderedArray(this.basetypeAttributes, this.candidateAttributes[n], attributeDeclComparator);
                                if (objectArray != null) break block12;
                                if (this.candidateAttributes[n].getUse() != 3) break block13;
                                vector.add(new ProhibitedAttrNotInBaseTypeException(complexType, this.candidateAttributes[n]));
                                break block14;
                            }
                            if (attributeWildcard != null && attributeWildcard.validate(this.candidateAttributes[n].getTargetNamespace())) break block14;
                            vector.add(new DerivationByRestriction_AttributeDeclNotDefinedByBasetypeException(complexType, this.candidateAttributes[n]));
                            break block14;
                        }
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            block10: {
                                try {
                                    short[] sArray = new short[1];
                                    if (!AttributesCompatibleWithBasetype_Checker.isRestrictionOf(this.candidateAttributes[n], (AttributeDecl)objectArray[n2], sArray)) {
                                        vector.add(new AttributeIncompatibleWithBasetypeAttributeException(complexType, (AttributeDecl)objectArray[n2], this.candidateAttributes[n], sArray[0]));
                                    }
                                }
                                catch (ReferenceResolutionException referenceResolutionException) {
                                    if (!Debug.DEBUG) break block10;
                                    referenceResolutionException.printStackTrace(System.err);
                                }
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
                break block15;
            }
            if (this.basetypeAttributes != null) {
                throw new RuntimeException("Implemenetation error : {attribute Declaration}  of the basetype is not a subset of {attribute declaration} of the ComplexType itself ");
            }
        }
        if (vector.size() > 0) {
            this.exceptions = new SchemaException[vector.size()];
            vector.copyInto(this.exceptions);
            return false;
        }
        return true;
    }

    static AttributeWildcard getBasetypeAttributeWildcard(ComplexType complexType) throws SchemaException {
        TypeInfo typeInfo;
        AttributeWildcard attributeWildcard = null;
        if (complexType instanceof ComplexTypeSpecImpl) {
            return ((ComplexTypeSpecImpl)complexType).getBasetypeEffectiveAttributeWildcard();
        }
        if (complexType instanceof ComplexTypeDef && (typeInfo = ((ComplexTypeDef)complexType).getComplexTypeSpec()) instanceof ComplexTypeSpecImpl) {
            return ((ComplexTypeSpecImpl)typeInfo).getBasetypeEffectiveAttributeWildcard();
        }
        typeInfo = complexType.getBasetype();
        if (typeInfo != null) {
            Type type = typeInfo.resolveToType();
            if (type.isComplexType()) {
                ComplexTypeSpec complexTypeSpec = type.isAnonymous() ? (ComplexTypeSpec)type : ((ComplexTypeDef)type).getComplexTypeSpec();
                attributeWildcard = complexTypeSpec.getEffectiveAttributeWildcard();
            }
            return attributeWildcard;
        }
        return null;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 3;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl == null ? (class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl = AttributesCompatibleWithBasetype_Checker.class$("com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl")) : class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl;
    }

    private static boolean isExtensionOf(AttributeDecl attributeDecl, AttributeDecl attributeDecl2) throws ReferenceResolutionException {
        SimpleType simpleType = attributeDecl.getType();
        if (simpleType == null) {
            return attributeDecl2.getType() == null || attributeDecl2.getType().equals(BuiltInDatatypeFactory.get("anySimpleType"));
        }
        return simpleType.equals(attributeDecl2.getType());
    }

    private static boolean isRestrictionOf(AttributeDecl attributeDecl, AttributeDecl attributeDecl2, short[] sArray) throws ReferenceResolutionException {
        return AttributesSpecImpl.isRestrictionOf(attributeDecl, attributeDecl2, sArray);
    }

    public void setBasetypeAttributes(AttributeDecl[] attributeDeclArray) {
        this.basetypeAttributes = attributeDeclArray;
    }

    public void setCandidateAttributes(AttributeDecl[] attributeDeclArray) {
        this.candidateAttributes = attributeDeclArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

