/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;

public abstract class BinaryLiteral
extends LiteralValueImpl {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String valueAsString;
    private CharacterDecoder decoder;
    public static final int ENCODING_BASE64 = 0;
    public static final int ENCODING_HEX = 1;
    protected int enc = -1;
    private byte[] value;
    private static final CharacterDecoder BASE64DECODER = new Base64Decoder();
    private static boolean initializedBuiltins = false;
    private static final CharacterDecoder HEXDECODER = new HexDecoder();
    private static DatatypeDef BASE64_BINARY;
    private static DatatypeDef HEX_BINARY;

    public static void main(String[] stringArray) {
        System.out.println(Byte.parseByte("F", 16));
    }

    public BinaryLiteral(String string) throws DatatypeFormatException {
        super(string);
        this.valueAsString = string;
        BinaryLiteral.initBinaryTypes();
    }

    protected void conversion(String string) throws DatatypeFormatException {
        BinaryLiteral.initBinaryTypes();
        if (this.enc != -1) {
            this.value = this.decoder.decode(string);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BinaryLiteral) {
            BinaryLiteral binaryLiteral = (BinaryLiteral)object;
            try {
                byte[] byArray = this.getBytes();
                byte[] byArray2 = binaryLiteral.getBytes();
                if (byArray == null || byArray2 == null) {
                    return this.valueAsString.equals(binaryLiteral.valueAsString);
                }
                if (byArray.length != byArray2.length) {
                    return false;
                }
                int n = 0;
                while (n < byArray.length) {
                    if (byArray[n] != byArray2[n]) {
                        return false;
                    }
                    ++n;
                }
            }
            catch (DatatypeFormatException datatypeFormatException) {
                if (Debug.DEBUG) {
                    datatypeFormatException.printStackTrace(System.err);
                }
                return this.valueAsString.equals(object);
            }
            return this.value.equals(binaryLiteral.value);
        }
        return false;
    }

    public byte[] getBytes() throws DatatypeFormatException {
        if (this.enc == -1) {
            return null;
        }
        if (this.value == null) {
            this.value = this.decoder.decode(this.valueAsString);
        }
        return this.value;
    }

    public int getEncoding() {
        return this.enc;
    }

    public Object getValue() {
        return null;
    }

    private static void initBinaryTypes() {
        BuiltInDatatypeFactory builtInDatatypeFactory = BuiltInDatatypeFactory.getInstance();
        if (BASE64_BINARY == null) {
            BASE64_BINARY = builtInDatatypeFactory.getBuiltInDatatype("base64Binary");
        }
        if (HEX_BINARY == null) {
            HEX_BINARY = builtInDatatypeFactory.getBuiltInDatatype("hexBinary");
        }
    }

    public boolean inOrder(Object object) throws IllegalArgumentException {
        return false;
    }

    public boolean isComparable(Object object, boolean[] blArray) {
        return false;
    }

    public boolean isEncodingKnown() {
        return this.enc != -1;
    }

    public static boolean isInitializedBuiltins() {
        return initializedBuiltins;
    }

    public boolean isTotallyOrdered() {
        return false;
    }

    protected void setEncoding(int n) {
        switch (n) {
            case 0: {
                this.enc = 0;
                this.value = null;
                this.decoder = BASE64DECODER;
                break;
            }
            case 1: {
                this.enc = 1;
                this.value = null;
                this.decoder = HEXDECODER;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a supported encoding");
            }
        }
    }

    public static void setInitializedBuiltins(boolean bl) {
        initializedBuiltins = bl;
    }

    public String toString() {
        return this.valueAsString;
    }

    public static class Base64Decoder
    extends CharacterDecoder {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public byte[] decode(String string) throws DatatypeFormatException {
            byte[] byArray = Base64.decode(string);
            if (byArray == null) {
                throw new DatatypeFormatException(BASE64_BINARY, string);
            }
            return byArray;
        }
    }

    public static class HexDecoder
    extends CharacterDecoder {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public byte[] decode(String string) throws DatatypeFormatException {
            byte[] byArray = HexBin.decode(string);
            if (byArray == null) {
                throw new DatatypeFormatException(BASE64_BINARY, string);
            }
            return byArray;
        }
    }

    public static abstract class CharacterDecoder {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public abstract byte[] decode(String var1) throws DatatypeFormatException;
    }
}

