/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;

public class BooleanLiteral
extends LiteralValueImpl {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Boolean value;
    private String valueAsString;

    private BooleanLiteral() {
    }

    public BooleanLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        BooleanLiteral booleanLiteral = new BooleanLiteral();
        booleanLiteral.value = new Boolean(this.value);
        return booleanLiteral;
    }

    public int compareTo(Object object) throws IllegalArgumentException {
        return 0;
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        if (string.equals("true") || string.equals("1")) {
            this.value = new Boolean(true);
        } else if (string.equals("false") || string.equals("0")) {
            this.value = new Boolean(false);
        } else {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("boolean"), string);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BooleanLiteral) {
            return this.value.equals(((BooleanLiteral)object).value);
        }
        return false;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean inOrder(Object object) throws IllegalArgumentException {
        return false;
    }

    public boolean isTotallyOrdered() {
        return false;
    }

    public String toString() {
        return this.valueAsString;
    }
}

