/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.mof.mof13.extn.MofClassExtn;
import com.ibm.mof.mof13.extn.impl.MofClassExtnImpl;
import com.ibm.xml.ecm.schema.AnyType;
import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.Document;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.impl.AnyTypeImpl;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.GeneratedBuiltInDatatypeImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import java.util.Hashtable;
import java.util.Vector;

public class BuiltInDatatypeFactory {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static BuiltInDatatypeFactory theFactory = null;
    private static Hashtable registry = new Hashtable();
    private static char underscore = new String("_").charAt(0);
    private static char minus = new String("-").charAt(0);
    private Document fDocument;
    private FactoryImpl factory;
    private static final MofClassExtnImpl mofClass = FactoryImplGen.GeneratedBuiltInDatatype_MOFClass;
    private static Class defaultClass = mofClass.getJavaClass();
    private static AnyType theAnyType;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$impl$GeneratedBuiltInDatatypeImpl;

    protected BuiltInDatatypeFactory() {
        theFactory = this;
        if (defaultClass != null) {
            defaultClass = class$com$ibm$xml$ecm$schema$impl$GeneratedBuiltInDatatypeImpl == null ? (class$com$ibm$xml$ecm$schema$impl$GeneratedBuiltInDatatypeImpl = BuiltInDatatypeFactory.class$("com.ibm.xml.ecm.schema.impl.GeneratedBuiltInDatatypeImpl")) : class$com$ibm$xml$ecm$schema$impl$GeneratedBuiltInDatatypeImpl;
        }
        try {
            this.factory = (FactoryImpl)FactoryImpl.instance();
            this.factory.getCheckerController().enableCheckType(CheckType.NCNAME_CHECKER, false);
            if (Debug.DEBUG) {
                System.out.println("In BuitInDatatypeFactory Constructor : factory = " + this.factory);
            }
            this.fDocument = this.factory.createDocument("/PrimitiveTypes.xmi");
            BuiltInDatatypeDef builtInDatatypeDef = (BuiltInDatatypeDef)((Object)this.fDocument.getXMIDocument().newInstance(this.getIMOFClass("anyURI")));
            registry.put("anyURI", builtInDatatypeDef);
            builtInDatatypeDef.setNCName(builtInDatatypeDef.getNCName());
            Schema schema = FactoryImpl.instance().createSchema();
            ((SchemaImpl)schema).setTargetNamespace(schema.getXmlSchemaRef());
            schema.setVersion("1.0");
            this.fDocument.addSchema(schema);
            schema.addTopComponent(builtInDatatypeDef);
            Schema schema2 = FactoryImpl.instance().createSchema();
            ((SchemaImpl)schema2).setTargetNamespace(schema.getXmlSchemaRef());
            schema2.setVersion("1.0");
            this.fDocument.addSchema(schema2);
            this.createAndRegisterAnyType(schema2);
            this.createAndRegisterPrimitiveType("anySimpleType", schema);
            this.createAndRegisterPrimitiveType("string", schema);
            this.createAndRegisterPrimitiveType("decimal", schema);
            this.createAndRegisterPrimitiveType("double", schema);
            this.createAndRegisterPrimitiveType("float", schema);
            this.createAndRegisterPrimitiveType("boolean", schema);
            BuiltInDatatypeDef builtInDatatypeDef2 = this.createAndRegisterPrimitiveType("QName", schema);
            this.createAndRegisterPrimitiveType("duration", schema);
            this.createAndRegisterPrimitiveType("dateTime", schema);
            this.createAndRegisterPrimitiveType("time", schema);
            this.createAndRegisterPrimitiveType("date", schema);
            this.createAndRegisterPrimitiveType("gYearMonth", schema);
            this.createAndRegisterPrimitiveType("gYear", schema);
            this.createAndRegisterPrimitiveType("gMonth", schema);
            this.createAndRegisterPrimitiveType("gMonthDay", schema);
            this.createAndRegisterPrimitiveType("gDay", schema);
            this.createAndRegisterPrimitiveType("hexBinary", schema);
            this.createAndRegisterPrimitiveType("base64Binary", schema);
            BuiltInDatatypeDef builtInDatatypeDef3 = this.getBuiltInDatatype("string");
            Hashtable<Integer, String[]> hashtable = new Hashtable<Integer, String[]>();
            hashtable.clear();
            hashtable.put(new Integer(12), new String[]{"replace"});
            this.createAndRegisterGeneratedType("normalizedString", schema, builtInDatatypeDef3, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(12), new String[]{"collapse"});
            BuiltInDatatypeDef builtInDatatypeDef4 = this.createAndRegisterGeneratedType("token", schema, builtInDatatypeDef3, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(5), new String[]{"([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*"});
            this.createAndRegisterGeneratedType("language", schema, builtInDatatypeDef4, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(5), new String[]{"\\i\\c*"});
            BuiltInDatatypeDef builtInDatatypeDef5 = this.createAndRegisterGeneratedType("Name", schema, builtInDatatypeDef4, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(5), new String[]{"\\c+"});
            BuiltInDatatypeDef builtInDatatypeDef6 = this.createAndRegisterGeneratedType("NMTOKEN", schema, builtInDatatypeDef4, hashtable);
            hashtable.clear();
            this.createAndRegisterGeneratedType("NMTOKENS", schema, builtInDatatypeDef6, null, 2);
            hashtable.clear();
            hashtable.put(new Integer(5), new String[]{"[\\i-[:]][\\c-[:]]*"});
            BuiltInDatatypeDef builtInDatatypeDef7 = this.createAndRegisterGeneratedType("NCName", schema, builtInDatatypeDef5, hashtable);
            hashtable.clear();
            BuiltInDatatypeDef builtInDatatypeDef8 = this.createAndRegisterGeneratedType("ID", schema, builtInDatatypeDef7, hashtable);
            BuiltInDatatypeDef builtInDatatypeDef9 = this.createAndRegisterGeneratedType("IDREF", schema, builtInDatatypeDef7, hashtable);
            BuiltInDatatypeDef builtInDatatypeDef10 = this.createAndRegisterGeneratedType("ENTITY", schema, builtInDatatypeDef7, hashtable);
            BuiltInDatatypeDef builtInDatatypeDef11 = this.createAndRegisterGeneratedType("NOTATION", schema, builtInDatatypeDef2, hashtable);
            builtInDatatypeDef11.setAbstract(true);
            this.createAndRegisterGeneratedType("IDREFS", schema, builtInDatatypeDef9, null, 2);
            this.createAndRegisterGeneratedType("ENTITIES", schema, builtInDatatypeDef10, null, 2);
            builtInDatatypeDef3 = this.getBuiltInDatatype("decimal");
            hashtable.clear();
            hashtable.put(new Integer(9), new String[]{"0"});
            hashtable.put(new Integer(5), new String[]{"[+\\-]?[0-9]+"});
            BuiltInDatatypeDef builtInDatatypeDef12 = this.createAndRegisterGeneratedType("integer", schema, builtInDatatypeDef3, hashtable);
            builtInDatatypeDef12.getFacet(9).setFixed(true);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"0"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("nonPositiveInteger", schema, builtInDatatypeDef12, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"-1"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("negativeInteger", schema, builtInDatatypeDef, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"9223372036854775807"});
            hashtable.put(new Integer(2), new String[]{"-9223372036854775808"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("long", schema, builtInDatatypeDef12, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"2147483647"});
            hashtable.put(new Integer(2), new String[]{"-2147483648"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("int", schema, builtInDatatypeDef, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"32767"});
            hashtable.put(new Integer(2), new String[]{"-32768"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("short", schema, builtInDatatypeDef, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"127"});
            hashtable.put(new Integer(2), new String[]{"-128"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("byte", schema, builtInDatatypeDef, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(2), new String[]{"0"});
            BuiltInDatatypeDef builtInDatatypeDef13 = this.createAndRegisterGeneratedType("nonNegativeInteger", schema, builtInDatatypeDef12, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"18446744073709551615"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("unsignedLong", schema, builtInDatatypeDef13, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"4294967295"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("unsignedInt", schema, builtInDatatypeDef, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"65535"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("unsignedShort", schema, builtInDatatypeDef, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(1), new String[]{"255"});
            builtInDatatypeDef = this.createAndRegisterGeneratedType("unsignedByte", schema, builtInDatatypeDef, hashtable);
            hashtable.clear();
            hashtable.put(new Integer(2), new String[]{"1"});
            this.createAndRegisterGeneratedType("positiveInteger", schema, builtInDatatypeDef13, hashtable);
            this.factory.getCheckerController().enableCheckType(CheckType.NCNAME_CHECKER, true);
            if (Debug.DEBUG) {
                System.out.println(" done \n" + registry);
            }
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace(System.err);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace(System.err);
            throw runtimeException;
        }
    }

    private AnyType createAndRegisterAnyType(Schema schema) {
        theAnyType = (AnyType)((Object)this.fDocument.getXMIDocument().newInstance(FactoryImplGen.AnyType_MOFClass));
        theAnyType.setNCName("anyType");
        schema.addTopComponent(theAnyType);
        ((AnyTypeImpl)theAnyType).init();
        return theAnyType;
    }

    private BuiltInDatatypeDef createAndRegisterGeneratedType(String string, Schema schema, BuiltInDatatypeDef builtInDatatypeDef, Hashtable hashtable) throws SchemaException {
        return this.createAndRegisterGeneratedType(string, schema, builtInDatatypeDef, hashtable, 0);
    }

    private BuiltInDatatypeDef createAndRegisterGeneratedType(String string, Schema schema, BuiltInDatatypeDef builtInDatatypeDef, Hashtable hashtable, int n) throws SchemaException {
        GeneratedBuiltInDatatypeImpl generatedBuiltInDatatypeImpl = (GeneratedBuiltInDatatypeImpl)this.fDocument.getXMIDocument().newInstance(this.getIMOFClass("GeneratedBuiltInDatatype"));
        generatedBuiltInDatatypeImpl.setNCName(string);
        schema.addTopComponent(generatedBuiltInDatatypeImpl);
        generatedBuiltInDatatypeImpl.addUsedtype((DatatypeRef)builtInDatatypeDef.makeReference(schema, "xsd"));
        generatedBuiltInDatatypeImpl.setDerivationType(n);
        generatedBuiltInDatatypeImpl.initFacets(hashtable);
        registry.put(string, generatedBuiltInDatatypeImpl);
        generatedBuiltInDatatypeImpl.setID(string);
        return generatedBuiltInDatatypeImpl;
    }

    private BuiltInDatatypeDef createAndRegisterPrimitiveType(String string, Schema schema) {
        BuiltInDatatypeDef builtInDatatypeDef = (BuiltInDatatypeDef)((Object)this.fDocument.getXMIDocument().newInstance(this.getIMOFClass(string)));
        registry.put(string, builtInDatatypeDef);
        schema.addTopComponent(builtInDatatypeDef);
        builtInDatatypeDef.setNCName(builtInDatatypeDef.getNCName());
        builtInDatatypeDef.setID(string);
        return builtInDatatypeDef;
    }

    protected void finalize() throws Throwable {
        this.fDocument = null;
        theFactory = null;
    }

    public Document geBuiltInDatatypeXMIDocument() {
        return this.fDocument;
    }

    public static BuiltInDatatypeDef get(String string) {
        return BuiltInDatatypeFactory.getInstance().getBuiltInDatatype(string);
    }

    public AnyType getAnyType() {
        return theAnyType;
    }

    public BuiltInDatatypeDef getBuiltInDatatype(String string) {
        return (BuiltInDatatypeDef)registry.get(string);
    }

    private MofClassExtn getIMOFClass(String string) {
        if (string.trim().equalsIgnoreCase("string")) {
            return FactoryImplGen.BuiltIn_STRING_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("boolean")) {
            return FactoryImplGen.BuiltIn_BOOLEAN_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("double")) {
            return FactoryImplGen.BuiltIn_DOUBLE_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("decimal")) {
            return FactoryImplGen.BuiltIn_Decimal_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("anyURI")) {
            return FactoryImplGen.BuiltIn_ANYURI_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("float")) {
            return FactoryImplGen.BuiltIn_FLOAT_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("QName")) {
            return FactoryImplGen.BuiltIn_QNAME_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("hexBinary")) {
            return FactoryImplGen.BuiltIn_HEXBINARY_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("base64Binary")) {
            return FactoryImplGen.BuiltIn_BASE64BINARY_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("duration")) {
            return FactoryImplGen.BuiltIn_DURATION_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("dateTime")) {
            return FactoryImplGen.BuiltIn_DATETIME_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("time")) {
            return FactoryImplGen.BuiltIn_TIME_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("gMonth")) {
            return FactoryImplGen.BuiltIn_MONTH_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("date")) {
            return FactoryImplGen.BuiltIn_DATE_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("gYearMonth")) {
            return FactoryImplGen.BuiltIn_YEARMONTH_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("gMonthDay")) {
            return FactoryImplGen.BuiltIn_MONTHDAY_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("gDay")) {
            return FactoryImplGen.BuiltIn_DAY_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("gYear")) {
            return FactoryImplGen.BuiltIn_YEAR_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("anySimpleType")) {
            return FactoryImplGen.AnySimpleType_MOFClass;
        }
        if (string.trim().equalsIgnoreCase("GeneratedBuiltInDatatype")) {
            return FactoryImplGen.GeneratedBuiltInDatatype_MOFClass;
        }
        return null;
    }

    public static BuiltInDatatypeFactory getInstance() {
        if (theFactory == null) {
            theFactory = new BuiltInDatatypeFactory();
        }
        return theFactory;
    }

    public Hashtable getRegistry() {
        return registry;
    }

    public boolean isBuiltInDatatype(String string) {
        return this.getBuiltInDatatype(string) != null;
    }

    public static void main(String[] stringArray) throws Exception {
        BuiltInDatatypeFactory builtInDatatypeFactory = BuiltInDatatypeFactory.getInstance();
        BuiltInDatatypeDef builtInDatatypeDef = builtInDatatypeFactory.getBuiltInDatatype("ID");
        System.out.println("id type = " + builtInDatatypeDef);
        Vector vector = new Vector();
        System.out.println("ID facet = " + builtInDatatypeDef.getAllFacets());
        if (builtInDatatypeDef.validate("na:me", vector)) {
            System.out.println("OK");
            System.out.println(builtInDatatypeDef.convert("na:me"));
        } else {
            System.out.println("ERROR :" + vector);
        }
        builtInDatatypeDef = builtInDatatypeFactory.getBuiltInDatatype("NCName");
        if (builtInDatatypeDef.validate("na:me", vector)) {
            System.out.println("OK");
        } else {
            System.out.println(builtInDatatypeDef.convert("na:me"));
            System.out.println("ERROR :" + vector);
        }
        System.out.println("NCName facet = " + builtInDatatypeDef.getAllFacets()[0].getValuesAsString()[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

