/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.BuiltIn_Decimal;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.gen.impl.BuiltIn_DecimalImplGen;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.DecimalLiteral;
import com.ibm.xml.ecm.schema.impl.EnumerationFacetStrategy;
import com.ibm.xml.ecm.schema.impl.MaxExclusiveFacetStrategy;
import com.ibm.xml.ecm.schema.impl.MaxInclusiveFacetStrategy;
import com.ibm.xml.ecm.schema.impl.MinExclusiveFacetStrategy;
import com.ibm.xml.ecm.schema.impl.MinInclusiveFacetStrategy;
import com.ibm.xml.ecm.schema.impl.PatternStringFacetStrategy;
import com.ibm.xml.ecm.schema.impl.PrecisionFacetStrategy;
import com.ibm.xml.ecm.schema.impl.ScaleFacetStrategy;
import com.ibm.xml.ecm.schema.impl.WhiteSpaceFacetStrategy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Hashtable;

public class BuiltIn_DecimalImpl
extends BuiltIn_DecimalImplGen
implements BuiltIn_Decimal {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public String convert(Object object) {
        return object.toString();
    }

    public Object convert(String string) throws DatatypeFormatException {
        return new DecimalLiteral(string);
    }

    protected Hashtable getAllFacetStrategies() {
        if (this.hashForStrategies == null) {
            this.hashForStrategies = new Hashtable();
            this.hashForStrategies.put(new Integer(1), new MaxInclusiveFacetStrategy(this));
            this.hashForStrategies.put(new Integer(2), new MinInclusiveFacetStrategy(this));
            this.hashForStrategies.put(new Integer(3), new MaxExclusiveFacetStrategy(this));
            this.hashForStrategies.put(new Integer(4), new MinExclusiveFacetStrategy(this));
            this.hashForStrategies.put(new Integer(6), new EnumerationFacetStrategy(this));
            this.hashForStrategies.put(new Integer(5), new PatternStringFacetStrategy());
            this.hashForStrategies.put(new Integer(9), new ScaleFacetStrategy());
            this.hashForStrategies.put(new Integer(8), new PrecisionFacetStrategy());
            this.hashForStrategies.put(new Integer(12), new WhiteSpaceFacetStrategy());
        }
        return this.hashForStrategies;
    }

    protected int[] getAllowedFacets() {
        return this.allowedFacets == null ? (this.allowedFacets = new int[]{5, 9, 8, 6, 1, 2, 3, 4, 12}) : this.allowedFacets;
    }

    protected String getBuiltInDatatypeNCName() {
        return "decimal";
    }

    private int mainIndex(DecimalLiteral decimalLiteral) throws IllegalArgumentException {
        BigDecimal bigDecimal = (BigDecimal)decimalLiteral.getValue();
        int n = bigDecimal.compareTo(new BigDecimal(BigInteger.ZERO));
        if (n == 0) {
            new IllegalArgumentException();
        } else if (n < 0) {
            bigDecimal.negate();
        }
        BigDecimal bigDecimal2 = new BigDecimal(BigInteger.ONE);
        if (bigDecimal.compareTo(bigDecimal2) >= 0) {
            bigDecimal = bigDecimal.movePointLeft(1);
            int n2 = 0;
            while (bigDecimal.compareTo(bigDecimal2) >= 0) {
                ++n2;
                bigDecimal = bigDecimal.movePointLeft(1);
            }
            return n2;
        }
        int n3 = 0;
        while (bigDecimal.compareTo(bigDecimal2) < 0) {
            ++n3;
            bigDecimal = bigDecimal.movePointRight(1);
        }
        return -n3;
    }

    Object next(Object object, Type type) throws SchemaException {
        int n;
        int n2;
        String[] stringArray;
        if (!(object instanceof DecimalLiteral)) {
            return null;
        }
        CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
        int n3 = checkerManagerImpl.getMaxCost();
        checkerManagerImpl.setMaxCost(-1);
        Facet facet = null;
        Facet facet2 = null;
        try {
            facet = type.getFacet(9);
            facet2 = type.getFacet(8);
            Object var8_7 = null;
            checkerManagerImpl.setMaxCost(n3);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            checkerManagerImpl.setMaxCost(n3);
            throw throwable;
        }
        if (facet == null || (stringArray = facet.getValuesAsString()) == null || stringArray.length == 0) {
            n2 = -1;
        } else {
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                n2 = -1;
            }
        }
        if (facet2 == null || (stringArray = facet2.getValuesAsString()) == null || stringArray.length == 0) {
            n = -1;
        } else {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        DecimalLiteral decimalLiteral = null;
        DecimalLiteral decimalLiteral2 = null;
        if (n2 >= 0) {
            decimalLiteral = this.nextInValueScaleWithFractionDigit((DecimalLiteral)object, n2);
        }
        if (n >= 0) {
            decimalLiteral2 = this.nextInValueSpaceWithTotalDigit((DecimalLiteral)object, n);
        }
        if (decimalLiteral == null && decimalLiteral2 == null) {
            return null;
        }
        if (decimalLiteral != null) {
            DecimalLiteral decimalLiteral3 = decimalLiteral = this.validateAgainstFacets(decimalLiteral, type) ? decimalLiteral : null;
        }
        if (decimalLiteral2 != null) {
            DecimalLiteral decimalLiteral4 = decimalLiteral2 = this.validateAgainstFacets(decimalLiteral2, type) ? decimalLiteral2 : null;
        }
        if (decimalLiteral != null && decimalLiteral2 != null) {
            return decimalLiteral.compareTo(decimalLiteral2) <= 0 ? decimalLiteral : decimalLiteral2;
        }
        return decimalLiteral == null ? decimalLiteral2 : decimalLiteral;
    }

    private DecimalLiteral nextInValueScaleWithFractionDigit(DecimalLiteral decimalLiteral, int n) throws SchemaException {
        BigDecimal bigDecimal = (BigDecimal)decimalLiteral.getValue();
        BigDecimal bigDecimal2 = bigDecimal.add(new BigDecimal(BigInteger.ONE).movePointLeft(n));
        return new DecimalLiteral(bigDecimal2.toString());
    }

    private DecimalLiteral nextInValueSpaceWithTotalDigit(DecimalLiteral decimalLiteral, int n) throws SchemaException {
        int n2;
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = (BigDecimal)decimalLiteral.getValue();
        BigDecimal bigDecimal3 = bigDecimal2.compareTo(bigDecimal = new BigDecimal(BigInteger.ZERO)) == 0 ? new BigDecimal(BigInteger.ONE, n) : ((n2 = this.mainIndex(decimalLiteral)) >= 0 ? bigDecimal2.add(new BigDecimal(BigInteger.ONE, n2 + 1 - n)) : bigDecimal2.add(new BigDecimal(BigInteger.ONE, n)));
        return new DecimalLiteral(bigDecimal3.toString());
    }

    Object previous(Object object, Type type) throws SchemaException {
        int n;
        int n2;
        String[] stringArray;
        if (!(object instanceof DecimalLiteral)) {
            return null;
        }
        CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
        int n3 = checkerManagerImpl.getMaxCost();
        checkerManagerImpl.setMaxCost(-1);
        Facet facet = null;
        Facet facet2 = null;
        try {
            facet = type.getFacet(9);
            facet2 = type.getFacet(8);
            Object var8_7 = null;
            checkerManagerImpl.setMaxCost(n3);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            checkerManagerImpl.setMaxCost(n3);
            throw throwable;
        }
        if (facet == null || (stringArray = facet.getValuesAsString()) == null || stringArray.length == 0) {
            n2 = -1;
        } else {
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                n2 = -1;
            }
        }
        if (facet2 == null || (stringArray = facet2.getValuesAsString()) == null || stringArray.length == 0) {
            n = -1;
        } else {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        DecimalLiteral decimalLiteral = null;
        DecimalLiteral decimalLiteral2 = null;
        if (n2 >= 0) {
            decimalLiteral = this.previousInValueScaleWithFractionDigit((DecimalLiteral)object, n2);
        }
        if (n >= 0) {
            decimalLiteral2 = this.previousInValueSpaceWithTotalDigit((DecimalLiteral)object, n);
        }
        if (decimalLiteral == null && decimalLiteral2 == null) {
            return null;
        }
        if (decimalLiteral != null) {
            DecimalLiteral decimalLiteral3 = decimalLiteral = this.validateAgainstFacets(decimalLiteral, type) ? decimalLiteral : null;
        }
        if (decimalLiteral2 != null) {
            DecimalLiteral decimalLiteral4 = decimalLiteral2 = this.validateAgainstFacets(decimalLiteral2, type) ? decimalLiteral2 : null;
        }
        if (decimalLiteral != null && decimalLiteral2 != null) {
            return decimalLiteral.compareTo(decimalLiteral2) <= 0 ? decimalLiteral2 : decimalLiteral;
        }
        return decimalLiteral == null ? decimalLiteral2 : decimalLiteral;
    }

    private DecimalLiteral previousInValueScaleWithFractionDigit(DecimalLiteral decimalLiteral, int n) throws SchemaException {
        BigDecimal bigDecimal = (BigDecimal)decimalLiteral.getValue();
        BigDecimal bigDecimal2 = bigDecimal.add(new BigDecimal(BigInteger.ONE).movePointLeft(n).negate());
        return new DecimalLiteral(bigDecimal2.toString());
    }

    private DecimalLiteral previousInValueSpaceWithTotalDigit(DecimalLiteral decimalLiteral, int n) throws SchemaException {
        int n2;
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = (BigDecimal)decimalLiteral.getValue();
        BigDecimal bigDecimal3 = bigDecimal2.compareTo(bigDecimal = new BigDecimal(BigInteger.ZERO)) == 0 ? new BigDecimal(BigInteger.ONE, n).negate() : ((n2 = this.mainIndex(decimalLiteral)) >= 0 ? bigDecimal2.add(new BigDecimal(BigInteger.ONE, n2 + 1 - n).negate()) : bigDecimal2.add(new BigDecimal(BigInteger.ONE, n).negate()));
        return new DecimalLiteral(bigDecimal3.toString());
    }
}

