/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import java.util.Enumeration;
import java.util.Hashtable;

public final class CheckType {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String ID;
    public static CheckType NCNAME_CHECKER = new CheckType("NCName Checker");
    public static CheckType DUPLICATION_CHECKER = new CheckType("Duplication Checker");
    public static CheckType SIMPLETYPE_CHECKER = new CheckType("Datatype Checker");
    public static CheckType TYPE_DERIVED_FROM_ID_CHECKER = new CheckType("Type is Derived from ID Checker");
    public static CheckType ALREADYDEFINECOMPONENT_CHECKER = new CheckType("Already defined component Checker");
    public static CheckType SIMPLETYPE_BASETYPE_CHECKER = new CheckType("Simple type basetype Checker");
    public static CheckType FACET_CHECKER = new CheckType("Facet Checker");
    public static CheckType SIMPLETYPE_FACET_CHECKER = new CheckType("Simple type facet checker");
    public static CheckType SIMPLETYPEDERIVATION_CHECKER = new CheckType("Simple type derivation checker");
    public static CheckType FACETSREQUIRED_CHECKER = new CheckType("Facets required checker");
    public static CheckType ATTRIBUTES_INCOMPATIBLE_CHECKER = new CheckType("Attributes incompatible Checker");
    private static Hashtable registryOfCheckTypes = new Hashtable();
    public static CheckType MULTIPLE_ATTRIBUTES_DERIVED_FROM_ID_CHECKER;

    public CheckType(String string) {
        this.ID = string;
    }

    public static CheckType[] getAllCheckTypes() {
        CheckType[] checkTypeArray = null;
        if (registryOfCheckTypes.size() > 0) {
            checkTypeArray = new CheckType[registryOfCheckTypes.size()];
            Enumeration enumeration = registryOfCheckTypes.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                checkTypeArray[n] = (CheckType)enumeration.nextElement();
                ++n;
            }
        }
        return checkTypeArray;
    }

    public static CheckType getCheckType(Object object) {
        return (CheckType)registryOfCheckTypes.get(object);
    }

    public String getID() {
        return this.ID;
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public static void register(CheckType checkType) throws IDAlreadyUsedException {
        if (registryOfCheckTypes.containsValue(checkType.getID())) {
            throw new IDAlreadyUsedException(checkType);
        }
        registryOfCheckTypes.put(checkType.getID(), checkType);
    }

    public String toString() {
        return this.ID;
    }

    public static void unRegister(CheckType checkType) {
        registryOfCheckTypes.remove(checkType.getID());
    }

    static {
        CheckType.register(NCNAME_CHECKER);
        CheckType.register(DUPLICATION_CHECKER);
        CheckType.register(SIMPLETYPE_CHECKER);
        CheckType.register(ALREADYDEFINECOMPONENT_CHECKER);
        CheckType.register(SIMPLETYPE_BASETYPE_CHECKER);
        CheckType.register(FACET_CHECKER);
        CheckType.register(SIMPLETYPE_FACET_CHECKER);
        CheckType.register(SIMPLETYPEDERIVATION_CHECKER);
        CheckType.register(FACETSREQUIRED_CHECKER);
        MULTIPLE_ATTRIBUTES_DERIVED_FROM_ID_CHECKER = new CheckType("Multiple Attributes derived from ID Checker");
    }

    public static class IDAlreadyUsedException
    extends RuntimeException {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private CheckType chType;

        public IDAlreadyUsedException(CheckType checkType) {
            this.chType = checkType;
        }

        public CheckType getCheckType() {
            return this.chType;
        }
    }
}

