/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Checker;
import java.util.TreeSet;
import java.util.Vector;

public class CheckerManagerImpl {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Integer NO_WARNING_ENCODING = new Integer(0);
    public static final Integer NO_WARNING_URI_OMITS_SCHEME = new Integer(1);
    private Vector disableCheckType = new Vector();
    private Vector disableSubjectClass = new Vector();
    private TreeSet noWarnings = new TreeSet();
    private int maxCost = 10;
    private static CheckerManagerImpl theController;
    private boolean disableInterativeMode = false;
    private boolean activateOnlyCheckersNeverActivateInInterativeMode = false;
    private boolean unrestrictedWarningDetectionForDescAxis = false;

    private CheckerManagerImpl() {
    }

    public void activateOnlyCheckersNeverActivateInInterativeMode(boolean bl) {
        this.activateOnlyCheckersNeverActivateInInterativeMode = bl;
    }

    public boolean check(Checker checker, boolean bl) {
        if (bl && (this.disableInterativeMode || checker.isNeverActivateInInterativeMode())) {
            return true;
        }
        if (this.isActivate(checker)) {
            return checker.check(bl);
        }
        checker.checkNotPerformed(checker.getSubject());
        return true;
    }

    public void enableCheckType(CheckType checkType, boolean bl) {
        if (this.disableCheckType != null) {
            if (bl) {
                this.disableCheckType.removeElement(checkType);
            } else if (!this.disableCheckType.contains(checkType)) {
                this.disableCheckType.addElement(checkType);
            }
        }
    }

    public void enableInteractiveMode(boolean bl) {
        this.disableInterativeMode = !bl;
    }

    public void enableSubjectClass(Class clazz, boolean bl) {
        if (bl) {
            this.disableSubjectClass.removeElement(clazz);
        } else if (!this.disableSubjectClass.contains(clazz)) {
            this.disableSubjectClass.addElement(clazz);
        }
    }

    public static CheckerManagerImpl getInstance() {
        if (theController == null) {
            theController = new CheckerManagerImpl();
        }
        return theController;
    }

    public int getMaxCost() {
        return this.maxCost;
    }

    public boolean isActivate(Checker checker) {
        if (this.activateOnlyCheckersNeverActivateInInterativeMode && !checker.isNeverActivateInInterativeMode()) {
            return false;
        }
        if (this.maxCost < checker.getCost()) {
            return false;
        }
        if (this.disableCheckType.contains(checker.getCheckType())) {
            return false;
        }
        int n = 0;
        while (n < this.disableSubjectClass.size()) {
            if (((Class)this.disableSubjectClass.elementAt(n)).isAssignableFrom(checker.getSubjectClass())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isCheckTypeEnable(CheckType checkType) {
        return !this.disableCheckType.contains(checkType);
    }

    public boolean isInteractiveModeEnabled() {
        return !this.disableInterativeMode;
    }

    public boolean isSubjectClassEnabled(Class clazz) {
        return !this.disableSubjectClass.contains(clazz);
    }

    public boolean noWarning(Integer n) {
        return this.noWarnings.contains(n);
    }

    public void reset() {
        if (theController != null) {
            this.disableCheckType = new Vector();
            this.disableSubjectClass = new Vector();
            this.noWarnings = new TreeSet();
        }
    }

    public void setMaxCost(int n) {
        this.maxCost = n;
    }

    public void setNoWarning(Integer n, boolean bl) {
        if (bl) {
            this.noWarnings.add(n);
        } else {
            this.noWarnings.remove(n);
        }
    }

    public void setUnrestrictedWarningDetectionForDescendantAxis(boolean bl) {
        this.unrestrictedWarningDetectionForDescAxis = bl;
    }

    public boolean unrestrictedWarningDetectionForDescendantAxis() {
        return this.unrestrictedWarningDetectionForDescAxis;
    }

    private class Pair {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private Class v1;
        private Class v2;

        public Class getClass1() {
            return this.v1;
        }

        public Class getClass2() {
            return this.v2;
        }

        private Pair(Class clazz, Class clazz2) {
            this.v1 = clazz;
            this.v2 = clazz2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)object;
            return this.v1.equals(pair.v1) && this.v2.equals(pair.v2);
        }

        public int hashCode() {
            return this.v1.hashCode() + this.v2.hashCode();
        }

        public boolean isInstance(Object object, Object object2) {
            return this.v1.isInstance(object) && this.v2.isInstance(object2);
        }

        public boolean isAssignableFrom(Class clazz, Class clazz2) {
            return this.v1.isAssignableFrom(clazz) && this.v2.isAssignableFrom(clazz2);
        }
    }
}

