/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.CircularDefinitionException;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.ModelGroupRef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Debug;
import java.util.Stack;

public class CircularDefinitionInAGroup_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static CheckType ID = new CheckType("Cyclic definition in Group Checker");
    public SchemaException[] exceptions;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$Group;

    public CircularDefinitionInAGroup_Checker() {
    }

    public CircularDefinitionInAGroup_Checker(Group group) {
        super(group);
    }

    public boolean check(boolean bl) {
        CircularDefinitionException circularDefinitionException;
        Group group = (Group)this.subject;
        this.exceptions = null;
        if (group != null && (circularDefinitionException = CircularDefinitionInAGroup_Checker.checkCircularDefinitionException(group)) != null) {
            this.exceptions = new SchemaException[]{circularDefinitionException};
        }
        return this.exceptions == null;
    }

    public static CircularDefinitionException checkCircularDefinitionException(Group group) {
        if (group == null) {
            return null;
        }
        TopComponent topComponent = group.getTopComponentAncestor();
        if (topComponent == null || topComponent.getComponentType() != 5) {
            return CircularDefinitionInAGroup_Checker.checkCircularDefinitionException(new Stack(), group.listParticle());
        }
        Stack<TopComponent> stack = new Stack<TopComponent>();
        stack.push(topComponent);
        return CircularDefinitionInAGroup_Checker.checkCircularDefinitionException(stack, group.listParticle());
    }

    private static CircularDefinitionException checkCircularDefinitionException(Stack stack, Particle[] particleArray) {
        CircularDefinitionException circularDefinitionException = null;
        if (particleArray != null) {
            int n = 0;
            while (n < particleArray.length) {
                block11: {
                    try {
                        if (particleArray[n].isModelGroupRef()) {
                            ModelGroupRef modelGroupRef = particleArray[n].asModelGroupRef();
                            ModelGroupDef modelGroupDef = (ModelGroupDef)modelGroupRef.resolve(false);
                            if (stack.contains(modelGroupDef)) {
                                stack.push(modelGroupDef);
                                circularDefinitionException = new CircularDefinitionException((SchemaObject)stack.get(0), stack);
                            } else {
                                stack.push(modelGroupDef);
                                Group group = modelGroupDef.getGroup();
                                if (group != null) {
                                    circularDefinitionException = CircularDefinitionInAGroup_Checker.checkCircularDefinitionException(stack, group.listParticle());
                                }
                                stack.pop();
                            }
                        } else if (particleArray[n].isGroup()) {
                            circularDefinitionException = CircularDefinitionInAGroup_Checker.checkCircularDefinitionException(stack, particleArray[n].asGroup().listParticle());
                        }
                        if (circularDefinitionException != null) {
                            return circularDefinitionException;
                        }
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        if (!Debug.DEBUG) break block11;
                        referenceResolutionException.printStackTrace(System.err);
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 4;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$Group == null ? (class$com$ibm$xml$ecm$schema$Group = CircularDefinitionInAGroup_Checker.class$("com.ibm.xml.ecm.schema.Group")) : class$com$ibm$xml$ecm$schema$Group;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

