/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.AttributeGroupDef;
import com.ibm.xml.ecm.schema.AttributeGroupRef;
import com.ibm.xml.ecm.schema.AttributesSpec;
import com.ibm.xml.ecm.schema.CircularDefinitionException;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Debug;
import java.util.Stack;

public class CircularDefinitionInAnAttributesSpec_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static CheckType ID = new CheckType("Cyclic definition in AttributesSpec Checker");
    public SchemaException[] exceptions;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$AttributesSpec;

    public CircularDefinitionInAnAttributesSpec_Checker() {
    }

    public CircularDefinitionInAnAttributesSpec_Checker(AttributesSpec attributesSpec) {
        super(attributesSpec);
    }

    public boolean check(boolean bl) {
        CircularDefinitionException circularDefinitionException;
        AttributesSpec attributesSpec = (AttributesSpec)this.subject;
        this.exceptions = null;
        if (attributesSpec != null && (circularDefinitionException = CircularDefinitionInAnAttributesSpec_Checker.checkCircularDefinitionException(attributesSpec)) != null) {
            this.exceptions = new SchemaException[]{circularDefinitionException};
        }
        return this.exceptions == null;
    }

    public static CircularDefinitionException checkCircularDefinitionException(AttributesSpec attributesSpec) {
        if (attributesSpec == null) {
            return null;
        }
        TopComponent topComponent = attributesSpec.getTopComponentAncestor();
        if (topComponent == null || topComponent.getComponentType() != 4) {
            return CircularDefinitionInAnAttributesSpec_Checker.checkCircularDefinitionException(new Stack(), attributesSpec.listAttrGroupRef());
        }
        Stack<TopComponent> stack = new Stack<TopComponent>();
        stack.push(topComponent);
        return CircularDefinitionInAnAttributesSpec_Checker.checkCircularDefinitionException(stack, attributesSpec.listAttrGroupRef());
    }

    private static CircularDefinitionException checkCircularDefinitionException(Stack stack, AttributeGroupRef[] attributeGroupRefArray) {
        CircularDefinitionException circularDefinitionException = null;
        if (attributeGroupRefArray != null) {
            int n = 0;
            while (n < attributeGroupRefArray.length) {
                block8: {
                    try {
                        AttributeGroupDef attributeGroupDef = (AttributeGroupDef)attributeGroupRefArray[n].resolve(false);
                        if (stack.contains(attributeGroupDef)) {
                            stack.push(attributeGroupDef);
                            circularDefinitionException = new CircularDefinitionException((SchemaObject)stack.get(0), stack);
                        } else {
                            stack.push(attributeGroupDef);
                            AttributesSpec attributesSpec = attributeGroupDef.getAttributesSpec();
                            if (attributesSpec != null) {
                                circularDefinitionException = CircularDefinitionInAnAttributesSpec_Checker.checkCircularDefinitionException(stack, attributesSpec.listAttrGroupRef());
                            }
                            stack.pop();
                        }
                        if (circularDefinitionException != null) {
                            return circularDefinitionException;
                        }
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        if (!Debug.DEBUG) break block8;
                        referenceResolutionException.printStackTrace(System.err);
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 4;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$AttributesSpec == null ? (class$com$ibm$xml$ecm$schema$AttributesSpec = CircularDefinitionInAnAttributesSpec_Checker.class$("com.ibm.xml.ecm.schema.AttributesSpec")) : class$com$ibm$xml$ecm$schema$AttributesSpec;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

