/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.mof.mof13.extn.impl.MOFAttributeSetting;
import com.ibm.sketch.parser.SchemaTags;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitor;
import com.ibm.xmi.xmi11temp.IBMXMIDocument;
import com.ibm.xml.ecm.schema.Annotation;
import com.ibm.xml.ecm.schema.AttributeDecl;
import com.ibm.xml.ecm.schema.AttributeGroupRef;
import com.ibm.xml.ecm.schema.AttributeRef;
import com.ibm.xml.ecm.schema.AttributeWildcard;
import com.ibm.xml.ecm.schema.BasetypeRequiredException;
import com.ibm.xml.ecm.schema.BlockElement;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ComplexTypeRef;
import com.ibm.xml.ecm.schema.ComplexTypeSpec;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.DatatypeSpec;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.FinalElement;
import com.ibm.xml.ecm.schema.InvalidValueForBlockInTypeException;
import com.ibm.xml.ecm.schema.InvalidValueForFinalException;
import com.ibm.xml.ecm.schema.LocalAttributeDecl;
import com.ibm.xml.ecm.schema.NotImplementedYetException;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.State;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.gen.impl.ComplexTypeDefImplGen;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.impl.Checker;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.IdConstraintHelper;
import com.ibm.xml.ecm.schema.impl.ReferenceImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import com.ibm.xml.ecm.schema.impl.TypeRedefinition_Checker;
import java.util.Arrays;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComplexTypeDefImpl
extends ComplexTypeDefImplGen
implements ComplexTypeDef {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean isAllFinal = false;
    private boolean isAllBlock = false;

    public void accept(SchemaObjectVisitor schemaObjectVisitor) {
        schemaObjectVisitor.visitComplexTypeDef(this);
    }

    public void add(AttributeGroupRef attributeGroupRef) {
        this.getSpec().add(attributeGroupRef);
    }

    public void add(AttributeRef attributeRef) {
        this.getSpec().add(attributeRef);
    }

    public void add(LocalAttributeDecl localAttributeDecl) {
        this.getSpec().add(localAttributeDecl);
    }

    public void addBlock(int n) {
        if (this.fblock != null) {
            int n2 = 0;
            while (n2 < this.fblock.length) {
                if (this.fblock[n2].getValue() == n) {
                    return;
                }
                ++n2;
            }
        }
        BlockElement blockElement = (BlockElement)((Object)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.BlockElement_MOFClass));
        blockElement.setValue(n);
        this.addBlock(blockElement);
    }

    public void addBlock(String string) {
        int n = SchemaTags.getBlockSubstitutionForComplexType(string);
        if (n >= 0) {
            this.addBlock(n);
        } else {
            this.getInvalidStateHandler().action(this, new SchemaException[]{new InvalidValueForBlockInTypeException(string)});
        }
    }

    public void addFinal(int n) {
        if (this.ffinal != null) {
            int n2 = 0;
            while (n2 < this.ffinal.length) {
                if (this.ffinal[n2].getValue() == n) {
                    return;
                }
                ++n2;
            }
        }
        FinalElement finalElement = (FinalElement)((Object)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.FinalElement_MOFClass));
        finalElement.setValue(n);
        this.addFinal(finalElement);
    }

    public void addFinal(String string) {
        int n = SchemaTags.getFinal(string);
        if (n >= 0) {
            this.addFinal(n);
        } else {
            this.getInvalidStateHandler().action(this, new SchemaException[]{new InvalidValueForFinalException(string)});
        }
    }

    public void allBlock() {
        this.addBlock(10);
        this.addBlock(1);
        this.addBlock(0);
        this.isAllBlock = true;
    }

    public void allFinal() {
        this.addFinal(1);
        this.addFinal(0);
        this.isAllFinal = true;
    }

    public boolean allowAttributes() throws SchemaException {
        return this.getSpec().allowAttributes();
    }

    public boolean allowContentModel(ContentModel contentModel) throws SchemaException {
        return this.getSpec().allowContentModel(contentModel);
    }

    public int[] allowedFacets() throws SchemaException {
        return this.getSpec().allowedFacets();
    }

    public void applied(MOFAttributeSetting mOFAttributeSetting) {
        super.applied(mOFAttributeSetting);
        this.primApplied(mOFAttributeSetting);
    }

    public void applied(MOFAttributeSetting mOFAttributeSetting, int n, MOFAttributeSetting mOFAttributeSetting2) {
        super.applied(mOFAttributeSetting, n, mOFAttributeSetting2);
        this.primApplied(mOFAttributeSetting);
    }

    public Type asType() {
        return this;
    }

    public TypeRef asTypeRef() {
        return null;
    }

    public void canceled(MOFAttributeSetting mOFAttributeSetting) {
        super.canceled(mOFAttributeSetting);
        this.primCanceled(mOFAttributeSetting);
    }

    public void canceled(MOFAttributeSetting mOFAttributeSetting, int n) {
        super.canceled(mOFAttributeSetting, n);
        this.primCanceled(mOFAttributeSetting);
    }

    public Annotation getAnnotation() {
        return this.getSpec().getAnnotation();
    }

    public LocalAttributeDecl getAttributeDecl(String string) {
        return this.getSpec().getAttributeDecl(string);
    }

    public AttributeRef getAttributeRef(URI uRI, String string) {
        return this.getSpec().getAttributeRef(uRI, string);
    }

    public TypeInfo getBasetype() {
        return this.getSpec().getBasetype();
    }

    public int[] getBlockList() {
        int[] nArray = null;
        if (this.fblock != null && this.fblock.length > 0) {
            nArray = new int[this.fblock.length];
            int n = 0;
            while (n < this.fblock.length) {
                nArray[n] = this.fblock[n].getValue();
                ++n;
            }
        } else if (this.getSchema() != null) {
            return this.getSchema().getBlockList();
        }
        return nArray;
    }

    public Checker[] getCheckers() {
        Checker[] checkerArray = super.getCheckers();
        Vector<Checker> vector = new Vector<Checker>();
        if (checkerArray != null) {
            vector.addAll(Arrays.asList(checkerArray));
        }
        vector.add(new TypeRedefinition_Checker(this));
        if (vector.size() > 0) {
            Object[] objectArray = new Checker[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public ComplexTypeSpec getComplexTypeSpec() {
        return this.getSpec();
    }

    public int getComponentType() {
        return 2;
    }

    public DatatypeSpec getDatatypeSpecToRestrict() {
        return this.getSpec().getDatatypeSpecToRestrict();
    }

    public int getDerivationType() {
        return this.getSpec().getDerivationType();
    }

    public AttributeDecl[] getEffectiveAttributes() throws SchemaException {
        return this.getSpec().getEffectiveAttributes();
    }

    public AttributeWildcard getEffectiveAttributeWildcard() throws SchemaException {
        return this.getSpec().getEffectiveAttributeWildcard();
    }

    public ContentType getEffectiveContentType() throws SchemaException {
        return this.getSpec().getEffectiveContentType();
    }

    public AttributeWildcard getExplicitAttributeWildcard() {
        return this.getSpec().getExplicitAttributeWildcard();
    }

    public int[] getExplicitBlockList() {
        int[] nArray = null;
        if (this.fblock != null) {
            nArray = new int[this.fblock.length];
            int n = 0;
            while (n < this.fblock.length) {
                nArray[n] = this.fblock[n].getValue();
                ++n;
            }
        }
        return nArray;
    }

    public ContentModel getExplicitContentModel() {
        return this.getSpec().getExplicitContentModel();
    }

    public int getExplicitContentType() {
        return this.getSpec().getExplicitContentType();
    }

    public int[] getExplicitFinalList() {
        int[] nArray = null;
        if (this.ffinal != null) {
            nArray = new int[this.ffinal.length];
            int n = 0;
            while (n < this.ffinal.length) {
                nArray[n] = this.ffinal[n].getValue();
                ++n;
            }
        }
        return nArray;
    }

    public Facet getFacet(int n) throws SchemaException {
        return this.getSpec().getFacet(n);
    }

    public Facet getFacetDefinedHere(int n) {
        return this.getSpec().getFacetDefinedHere(n);
    }

    public int[] getFinalList() {
        int[] nArray = null;
        if (this.ffinal != null && this.ffinal.length > 0) {
            nArray = new int[this.ffinal.length];
            int n = 0;
            while (n < this.ffinal.length) {
                nArray[n] = this.ffinal[n].getValue();
                ++n;
            }
        } else if (this.getSchema() != null) {
            return this.getSchema().getFinalList();
        }
        return nArray;
    }

    public Reference[] getReferencesToRedefinedComponent() {
        TypeInfo typeInfo = this.getBasetype();
        if (typeInfo != null && typeInfo.isAReference() && ((ReferenceImpl)((Object)typeInfo.asTypeRef())).isAReferenceToARedefinedTopComponent()) {
            return new Reference[]{typeInfo.asTypeRef()};
        }
        return null;
    }

    public SchemaObject[] getSchemaObjectChildrenForVSD() {
        return ((ComplexTypeSpecImpl)this.getSpec()).getSchemaObjectChildrenForVSD();
    }

    private ComplexTypeSpec getSpec() {
        if (this.fcomplexTypeSpec == null) {
            ComplexTypeSpec complexTypeSpec = (ComplexTypeSpec)((Object)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.ComplexTypeSpec_MOFClass));
            this.setComplexTypeSpec(complexTypeSpec);
        }
        return this.fcomplexTypeSpec;
    }

    public State getState(boolean bl) {
        return super.getState(bl);
    }

    public boolean isAllFinal() {
        return this.isAllFinal;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isAReference() {
        return false;
    }

    public boolean isComplexType() {
        return this.getSpec().isComplexType();
    }

    public boolean isDerivedFrom(Type type) throws ReferenceResolutionException {
        return this.getSpec().isDerivedFrom(type);
    }

    public boolean isDerivedFrom(TypeRef typeRef) throws ReferenceResolutionException {
        return this.getSpec().isDerivedFrom(typeRef);
    }

    public boolean isDerivedFromGivenSomeDerivationMethods(Type type, int[] nArray) throws ReferenceResolutionException {
        Type type2;
        nArray = nArray == null ? new int[]{} : nArray;
        Arrays.sort(nArray);
        if (Arrays.binarySearch(nArray, this.getDerivationType()) >= 0) {
            return false;
        }
        if (this.equals(type)) {
            return true;
        }
        TypeInfo typeInfo = this.getSpec().getBasetype();
        if (typeInfo == null || (type2 = typeInfo.resolveToType()).isUR_Type()) {
            return type == null || type.isUR_Type();
        }
        int[] nArray2 = ComplexTypeSpecImpl.getFinalList(type2);
        Arrays.sort(nArray2);
        if (Arrays.binarySearch(nArray2, this.getDerivationType()) >= 0) {
            return false;
        }
        if (this.equals(type)) {
            return true;
        }
        return this.getSpec().isDerivedFromGivenSomeDerivationMethods(type, nArray);
    }

    public boolean isDerivedFromGivenSomeDerivationMethods(TypeRef typeRef, int[] nArray) throws ReferenceResolutionException {
        Type type;
        nArray = nArray == null ? new int[]{} : nArray;
        Arrays.sort(nArray);
        if (Arrays.binarySearch(nArray, this.getDerivationType()) >= 0) {
            return false;
        }
        try {
            if (this.equals(typeRef.resolve(false))) {
                return true;
            }
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            // empty catch block
        }
        TypeInfo typeInfo = this.getSpec().getBasetype();
        if (typeInfo == null || (type = typeInfo.resolveToType()).isUR_Type()) {
            return typeRef == null || ((Type)((Object)typeRef.resolve(false))).isUR_Type();
        }
        int[] nArray2 = ComplexTypeSpecImpl.getFinalList(type);
        Arrays.sort(nArray2);
        if (Arrays.binarySearch(nArray2, this.getDerivationType()) >= 0) {
            return false;
        }
        if (typeRef != null && this.equals(typeRef.resolve(false))) {
            return true;
        }
        return this.getSpec().isDerivedFromGivenSomeDerivationMethods(typeRef, nArray);
    }

    public boolean isDirectlyDerivedFrom(Type type, int n) throws ReferenceResolutionException {
        return this.getSpec().isDirectlyDerivedFrom(type, n);
    }

    public boolean isDirectlyDerivedFrom(TypeRef typeRef, int n) throws ReferenceResolutionException {
        return this.getSpec().isDirectlyDerivedFrom(typeRef, n);
    }

    public boolean isSimpleType() {
        return this.getSpec().isSimpleType();
    }

    public boolean isUR_Type() {
        return false;
    }

    public boolean isValidExtensionOf(Type type) throws ReferenceResolutionException {
        throw new NotImplementedYetException();
    }

    public boolean isValidRestrictionOf(Type type) throws ReferenceResolutionException {
        throw new NotImplementedYetException();
    }

    public AttributeGroupRef[] listExplicitAttributeGroupRef() {
        return this.getSpec().listExplicitAttributeGroupRef();
    }

    public AttributeRef[] listExplicitAttributeRef() {
        return this.getSpec().listExplicitAttributeRef();
    }

    public LocalAttributeDecl[] listExplicitLocalAttributeDecl() {
        return this.getSpec().listExplicitLocalAttributeDecl();
    }

    public Facet[] listFacet() {
        return this.getSpec().listFacet();
    }

    public TypeInfo[] listUsedtype() {
        return this.getSpec().listUsedtype();
    }

    public Reference makeReference(int n, Schema schema, String string, Vector vector) {
        ComplexTypeRef complexTypeRef = null;
        FactoryImpl factoryImpl = (FactoryImpl)FactoryImpl.instance();
        IBMXMIDocument iBMXMIDocument = factoryImpl.getCurrentDocument();
        if (schema != null) {
            factoryImpl.setCurrentDocument((IBMXMIDocument)schema.getXMIDocument());
        } else {
            factoryImpl.setCurrentDocument(SchemaObjectImpl.getDefaultXMIDocument());
        }
        URI uRI = ((SchemaImpl)this.getSchema()).getTargetNamespace();
        if (uRI == null && schema != this.getSchema()) {
            complexTypeRef = null;
        } else {
            complexTypeRef = factoryImpl.createComplexTypeRef(this.getNCName(), ((SchemaImpl)this.getSchema()).getTargetNamespaceOrDefaultTargetNamespace(), string, vector);
            this.addReference(complexTypeRef);
        }
        factoryImpl.setCurrentDocument(iBMXMIDocument);
        return complexTypeRef;
    }

    private void primApplied(MOFAttributeSetting mOFAttributeSetting) {
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.ComplexTypeDef_complexTypeSpec) {
            IdConstraintHelper.addedToItsParent((SchemaObjectImpl)mOFAttributeSetting.getObject());
            return;
        }
    }

    private void primCanceled(MOFAttributeSetting mOFAttributeSetting) {
    }

    public void remove(AttributeGroupRef attributeGroupRef) {
        this.getSpec().remove(attributeGroupRef);
    }

    public void remove(AttributeRef attributeRef) {
        this.getSpec().remove(attributeRef);
    }

    public void remove(LocalAttributeDecl localAttributeDecl) {
        this.getSpec().remove(localAttributeDecl);
    }

    public void removeBlock(int n) {
        if (this.fblock != null) {
            int n2 = 0;
            while (n2 < this.fblock.length) {
                if (this.fblock[n2].getValue() == n) {
                    this.removeBlock(this.fblock[n2]);
                    this.isAllBlock = false;
                }
                ++n2;
            }
        }
    }

    public void removeFacet(Facet facet) {
        this.getSpec().removeFacet(facet);
    }

    public void removeFinal(int n) {
        if (this.ffinal != null) {
            int n2 = 0;
            while (n2 < this.ffinal.length) {
                if (this.ffinal[n2].getValue() == n) {
                    this.removeFinal(this.ffinal[n2]);
                    this.isAllFinal = false;
                }
                ++n2;
            }
        }
    }

    public void removeUsedtype(TypeInfo typeInfo) throws BasetypeRequiredException {
        this.getSpec().removeUsedtype(typeInfo);
    }

    public boolean replaceUsedtype(TypeInfo typeInfo, TypeRef typeRef) {
        return this.getSpec().replaceUsedtype(typeInfo, typeRef);
    }

    public Type resolveToType() throws ReferenceResolutionException {
        return this.getSpec().resolveToType();
    }

    public void setAnnotation(Annotation annotation) {
        this.getSpec().setAnnotation(annotation);
    }

    public void setAttributeWildcard(AttributeWildcard attributeWildcard) {
        this.getSpec().setAttributeWildcard(attributeWildcard);
    }

    public void setBasetype(TypeRef typeRef) {
        this.getSpec().setBasetype(typeRef);
    }

    public void setComplexTypeSpec(ComplexTypeSpec complexTypeSpec) {
        if (this.fcomplexTypeSpec != null) {
            IdConstraintHelper.removedFromItsParent((SchemaObjectImpl)((Object)this.fcomplexTypeSpec));
        }
        super.setComplexTypeSpec(complexTypeSpec);
    }

    public void setContentModel(ContentModel contentModel) {
        this.getSpec().setContentModel(contentModel);
    }

    public void setDatatypeSpecToRestrict(DatatypeSpec datatypeSpec) {
        this.getSpec().setDatatypeSpecToRestrict(datatypeSpec);
    }

    public void setDerivationType(int n) {
        this.getSpec().setDerivationType(n);
    }

    public void setExplicitContentModel(ContentModel contentModel) {
        this.getSpec().setExplicitContentModel(contentModel);
    }

    public void setExplicitContentType(int n) {
        this.getSpec().setExplicitContentType(n);
    }

    public void setFacet(int n, String[] stringArray) {
        this.getSpec().setFacet(n, stringArray);
    }

    public void setNCName(String string) {
        super.setNCName(string);
    }

    public Node toXMLRepresentation(Document document) {
        int n;
        Element element = (Element)this.getSpec().toXMLRepresentation(document);
        this.addNamespaceDeclaration(element);
        if (this.fNCName != null) {
            element.setAttribute("name", this.fNCName);
        }
        if (this.getID() != null) {
            element.setAttribute("id", this.getID());
        }
        if (this.getValue(FactoryImplGen.ComplexTypeDef_abstract) != null) {
            element.setAttribute("abstract", this.fabstract ? "true" : "false");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.getExplicitFinalList();
        if (nArray != null && nArray.length > 0) {
            if (this.isAllFinal) {
                element.setAttribute("final", "#all");
            } else {
                n = 0;
                while (n < nArray.length) {
                    if (n != 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(ComplexTypeSpecImpl.derivationType(nArray[n]));
                    ++n;
                }
            }
            element.setAttribute("final", stringBuffer.toString());
        }
        if ((nArray = this.getExplicitBlockList()) != null && nArray.length > 0) {
            if (this.isAllBlock) {
                element.setAttribute("block", "#all");
            } else {
                n = 0;
                while (n < nArray.length) {
                    if (n != 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(ComplexTypeSpecImpl.derivationType(nArray[n]));
                    ++n;
                }
            }
            element.setAttribute("block", stringBuffer.toString());
        }
        return element;
    }
}

