/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.ComparatorForEquality;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.CyclicTypeHierarchyException;
import com.ibm.xml.ecm.schema.DatatypeDef;
import com.ibm.xml.ecm.schema.DerivationMethodException;
import com.ibm.xml.ecm.schema.FinalDerivationMethodException;
import com.ibm.xml.ecm.schema.NotSupportedDerivationMethodException;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleTypeBaseForRestrictionException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.ReferenceImpl;
import com.ibm.xml.ecm.schema.impl.TopComponentImpl;
import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;

public class ComplexTypeDerivationMethod_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static CheckType COMPLEXTYPEDERIVATIONMETHOD_CHECKER;
    private SchemaException[] exceptions;
    private ContentType basetypeContentType;
    public static CheckType ID;
    private static TypeInfoEqual equal;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl;

    public ComplexTypeDerivationMethod_Checker() {
    }

    public ComplexTypeDerivationMethod_Checker(ComplexTypeSpecImpl complexTypeSpecImpl) {
        super(complexTypeSpecImpl);
    }

    public boolean check(boolean bl) {
        Vector<DerivationMethodException> vector;
        block14: {
            vector = new Vector<DerivationMethodException>();
            this.exceptions = null;
            try {
                Type type;
                ComplexTypeSpecImpl complexTypeSpecImpl = (ComplexTypeSpecImpl)this.subject;
                Type type2 = complexTypeSpecImpl.getNamedType() == null ? complexTypeSpecImpl : complexTypeSpecImpl.getNamedType();
                CyclicTypeHierarchyException cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(type2);
                if (cyclicTypeHierarchyException != null) {
                    this.exceptions = new SchemaException[]{cyclicTypeHierarchyException};
                    return false;
                }
                TypeInfo typeInfo = complexTypeSpecImpl.getBasetype();
                int n = complexTypeSpecImpl.getDerivationType();
                if (typeInfo != null && !(type = typeInfo.resolveToType()).isUR_Type()) {
                    int[] nArray;
                    if (!type.isAnonymous() && (nArray = type.isSimpleType() ? ((DatatypeDef)type).getFinalList() : ((ComplexTypeDef)type).getFinalList()) != null && this.contains(nArray, n)) {
                        vector.add(new FinalDerivationMethodException(type2, n, typeInfo));
                    }
                    switch (n) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            if (type.isSimpleType()) {
                                vector.add(new SimpleTypeBaseForRestrictionException((ComplexType)type2, typeInfo));
                                break;
                            }
                            break block14;
                        }
                        case 1000: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            vector.add(new NotSupportedDerivationMethodException(type2, n, typeInfo));
                            break;
                        }
                    }
                    break block14;
                }
                if (n != -1 && n != 0) {
                    vector.add(new FinalDerivationMethodException(type2, n, typeInfo));
                }
            }
            catch (SchemaException schemaException) {
                if (!Debug.DEBUG) break block14;
                schemaException.printStackTrace(System.err);
            }
        }
        if (vector.size() > 0) {
            this.exceptions = new SchemaException[vector.size()];
            vector.copyInto(this.exceptions);
            return false;
        }
        return true;
    }

    public static CyclicTypeHierarchyException checkCyclicTypeHierarchy(Type type) {
        Stack<Type> stack = new Stack<Type>();
        stack.push(type);
        return ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(stack, type);
    }

    private static CyclicTypeHierarchyException checkCyclicTypeHierarchy(Stack stack, Type type) {
        TypeInfo[] typeInfoArray = type.listUsedtype();
        if (typeInfoArray != null) {
            int n = 0;
            while (n < typeInfoArray.length) {
                block8: {
                    try {
                        CyclicTypeHierarchyException cyclicTypeHierarchyException;
                        if (ComplexTypeDerivationMethod_Checker.contains(stack, typeInfoArray[n])) {
                            type = typeInfoArray[n].isAReference() ? (Type)((Object)typeInfoArray[n].asTypeRef().resolve(false)) : type.asType();
                            stack.push(type);
                            cyclicTypeHierarchyException = new CyclicTypeHierarchyException((Type)stack.get(0), stack);
                        } else {
                            if (typeInfoArray[n] == null) {
                                return new CyclicTypeHierarchyException((Type)stack.get(0), stack);
                            }
                            type = typeInfoArray[n].isAReference() ? (Type)((Object)typeInfoArray[n].asTypeRef().resolve(false)) : typeInfoArray[n].asType();
                            stack.push(type);
                            cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(stack, type);
                            stack.pop();
                        }
                        if (cyclicTypeHierarchyException != null) {
                            return cyclicTypeHierarchyException;
                        }
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        if (!Debug.DEBUG) break block8;
                        referenceResolutionException.printStackTrace(System.err);
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private boolean contains(int[] nArray, int n) {
        Arrays.sort(nArray);
        return Arrays.binarySearch(nArray, n) >= 0;
    }

    private static boolean contains(Vector vector, TypeInfo typeInfo) {
        int n = 0;
        while (n < vector.size()) {
            if (equal.equals(vector.get(n), typeInfo)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ContentType getBasetypeEffectiveContentType() {
        return this.basetypeContentType;
    }

    public CheckType getCheckType() {
        return COMPLEXTYPEDERIVATIONMETHOD_CHECKER;
    }

    public int getCost() {
        return 4;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl == null ? (class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl = ComplexTypeDerivationMethod_Checker.class$("com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl")) : class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl;
    }

    public void setBasetypeEffectiveContentType(ContentType contentType) {
        this.basetypeContentType = contentType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ID = COMPLEXTYPEDERIVATIONMETHOD_CHECKER = new CheckType("ComplexType Derivation Method Checker");
        CheckType.register(COMPLEXTYPEDERIVATIONMETHOD_CHECKER);
        equal = new TypeInfoEqual();
    }

    private static class TypeInfoEqual
    implements ComparatorForEquality {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private TypeInfoEqual() {
        }

        public boolean equals(Object object, Object object2) {
            String string;
            URI uRI;
            TopComponentImpl topComponentImpl;
            ReferenceImpl referenceImpl;
            String string2;
            URI uRI2;
            if (object == null || object2 == null) {
                return false;
            }
            TypeInfo typeInfo = (TypeInfo)object;
            TypeInfo typeInfo2 = (TypeInfo)object2;
            if (typeInfo.asType() != null) {
                uRI2 = typeInfo.asType().getTargetNamespace();
                string2 = typeInfo.asType().isAnonymous() ? null : ((TopComponentImpl)((Object)typeInfo.asType())).getEffectiveNCName();
            } else {
                uRI2 = typeInfo.asTypeRef().getTargetNamespace();
                referenceImpl = (ReferenceImpl)((Object)typeInfo.asTypeRef());
                if (referenceImpl.isAReferenceToARedefinedTopComponent()) {
                    try {
                        topComponentImpl = (TopComponentImpl)referenceImpl.resolve(false);
                        string2 = topComponentImpl.getEffectiveNCName();
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        if (Debug.DEBUG) {
                            referenceResolutionException.printStackTrace(System.err);
                        }
                        string2 = referenceImpl.getNCName();
                    }
                } else {
                    string2 = referenceImpl.getNCName();
                }
            }
            if (typeInfo2.asType() != null) {
                uRI = typeInfo2.asType().getTargetNamespace();
                string = typeInfo2.asType().isAnonymous() ? null : ((TopComponentImpl)((Object)typeInfo2.asType())).getEffectiveNCName();
            } else {
                uRI = typeInfo2.asTypeRef().getTargetNamespace();
                referenceImpl = (ReferenceImpl)((Object)typeInfo2.asTypeRef());
                if (referenceImpl.isAReferenceToARedefinedTopComponent()) {
                    try {
                        topComponentImpl = (TopComponentImpl)referenceImpl.resolve(false);
                        string = topComponentImpl.getEffectiveNCName();
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        if (Debug.DEBUG) {
                            referenceResolutionException.printStackTrace(System.err);
                        }
                        string = referenceImpl.getNCName();
                    }
                } else {
                    string = referenceImpl.getNCName();
                }
            }
            if (string2 == null) {
                return false;
            }
            if (!string2.equals(string)) {
                return false;
            }
            if (uRI2 == null) {
                return uRI == null;
            }
            return uRI2.equals(uRI);
        }
    }
}

