/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.viewandvisitor.ReferenceVisitor;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitorImpl;
import com.ibm.xml.ecm.schema.Annotation;
import com.ibm.xml.ecm.schema.AttributeDecl;
import com.ibm.xml.ecm.schema.AttributeGroupDef;
import com.ibm.xml.ecm.schema.AttributeGroupRef;
import com.ibm.xml.ecm.schema.AttributeRef;
import com.ibm.xml.ecm.schema.AttributeWildcard;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ComplexTypeRef;
import com.ibm.xml.ecm.schema.ComplexTypeSpec;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.DatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.DatatypeSpec;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.GlobalAttributeDecl;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.ImportStatement;
import com.ibm.xml.ecm.schema.Info;
import com.ibm.xml.ecm.schema.LocalAttributeDecl;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.ModelGroupRef;
import com.ibm.xml.ecm.schema.NamespaceDeclaration;
import com.ibm.xml.ecm.schema.NotationDecl;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ParticleWildcard;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaComponent;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.appinfo;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.impl.AttributeRefImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.LocalAttributeDeclImpl;
import com.ibm.xml.ecm.schema.impl.RestrictableHelper;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComponentNormalizer {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DECMNS_AS_STRING = "http://w3.research.ibm.com/SKETCH/ecm";
    public static final URI DECMNS = (URI)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.URI_MOFClass));
    public static final String DEFAULT_PREFIX_DECM = "ec";
    private static boolean stopAtBuiltInComponents = false;
    private static boolean addInfoAboutSchemaObjectOrigin;

    public static boolean addInfoAboutSchemaObjectOrigin() {
        return addInfoAboutSchemaObjectOrigin;
    }

    static void addPathElement(appinfo appinfo2, SchemaObject schemaObject, Document document) {
        Object object;
        String string;
        String string2;
        SchemaObject schemaObject2;
        if (!ComponentNormalizer.addInfoAboutSchemaObjectOrigin()) {
            return;
        }
        String string3 = null;
        if (schemaObject instanceof TopComponent) {
            schemaObject2 = (TopComponent)schemaObject;
            string2 = schemaObject2.getSchemaComponentTypeAsString();
            string = schemaObject2.getFullName();
        } else if (schemaObject instanceof Schema) {
            schemaObject2 = (Schema)schemaObject;
            string2 = "schema";
            object = schemaObject2.getTargetNamespace();
            string = object == null ? "" : object.toString();
        } else if (schemaObject instanceof SchemaComponent) {
            string2 = ((SchemaComponent)schemaObject).getSchemaComponentTypeAsString();
            string = schemaObject.toString();
        } else {
            string2 = "schemaObject";
            string = schemaObject.toString();
        }
        schemaObject2 = schemaObject.getSchema();
        if (schemaObject2 != null && schemaObject2 instanceof SchemaImpl && (object = ((SchemaImpl)schemaObject2).getSaveAsLocation()) != null) {
            string3 = object.toString();
        }
        string3 = string3 == null ? "" : string3;
        string2 = string2 == null ? "" : string2;
        string = string == null ? "" : string;
        object = document.createElementNS(DECMNS_AS_STRING, "ec:step");
        appinfo2.addNode((Node)object);
        Element element = document.createElementNS(DECMNS_AS_STRING, "ec:type");
        element.appendChild(document.createTextNode(string2));
        object.appendChild(element);
        Element element2 = document.createElementNS(DECMNS_AS_STRING, "ec:name");
        element2.appendChild(document.createTextNode(string));
        object.appendChild(element2);
        Element element3 = document.createElementNS(DECMNS_AS_STRING, "ec:location");
        element3.appendChild(document.createTextNode(string3));
        object.appendChild(element3);
    }

    public static appinfo createDECMAppInfo(Factory factory) {
        appinfo appinfo2 = factory.createAppinfo();
        appinfo2.setSource(DECMNS);
        appinfo2.addNamespaceDeclaration(DEFAULT_PREFIX_DECM, DECMNS);
        return appinfo2;
    }

    public static Group expandAllModelGroups(Group group, boolean bl) {
        Group group2 = bl ? (Group)group.clone() : group;
        group2.accept(new ExpandModelGroupVisitor());
        return group2;
    }

    public static Group expandAndNormalize(Group group, boolean bl) throws SchemaException {
        Group group2 = bl ? (Group)group.clone() : group;
        ComponentNormalizer.expandAllModelGroups(group2, false);
        ComponentNormalizer.removePointLessGroup(group2, false);
        return group2;
    }

    static appinfo getDECMAppInfo(Annotation annotation) {
        Info[] infoArray = annotation.listInfo();
        if (infoArray != null) {
            int n = 0;
            while (n < infoArray.length) {
                if (infoArray[n].getSchemaComponentType() == 124 && DECMNS.equals(infoArray[n].getSource())) {
                    return (appinfo)infoArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static AttributeGroupDef normalize(AttributeGroupDef attributeGroupDef, Schema schema, String string) throws SchemaException {
        AttributeDecl[] attributeDeclArray;
        Factory factory = FactoryImpl.instance();
        AttributeGroupDef attributeGroupDef2 = factory.createAttributeGroupDef();
        if (string != null) {
            attributeGroupDef2.setNCName(string);
        } else if (attributeGroupDef.getNCName() != null) {
            attributeGroupDef2.setNCName(attributeGroupDef.getNCName());
        }
        Schema schema2 = ComponentNormalizer.updateDestinationSchema(attributeGroupDef, schema, factory);
        if (schema2 != null) {
            schema2.addTopComponent(attributeGroupDef2);
        }
        if ((attributeDeclArray = attributeGroupDef.getAllEffectiveAttributeDecls(false)) != null) {
            int n = 0;
            while (n < attributeDeclArray.length) {
                attributeGroupDef2.addAttributeDecl(LocalAttributeDeclImpl.createLocalAttributeDecl(attributeDeclArray[n]));
                ++n;
            }
        }
        return attributeGroupDef2;
    }

    private static void normalize(ComplexType complexType, ComplexType complexType2) throws SchemaException {
        Factory factory = FactoryImpl.instance();
        AttributeDecl[] attributeDeclArray = complexType.getEffectiveAttributes();
        AttributeWildcard attributeWildcard = complexType.getEffectiveAttributeWildcard();
        ContentType contentType = complexType.getEffectiveContentType();
        if (contentType != null) {
            Facet[] facetArray;
            if (contentType.isContentModel()) {
                facetArray = (Facet[])contentType.asContentModel().clone();
                Particle particle = facetArray.getParticle();
                if (particle != null && particle.isGroup()) {
                    ComponentNormalizer.expandAndNormalize(particle.asGroup(), false);
                }
                complexType2.setExplicitContentModel((ContentModel)facetArray);
            } else if (contentType.isSimpleType()) {
                complexType2.setDerivationType(1);
                if (contentType.asSimpleType().getBasetype() != null) {
                    complexType2.setBasetype((TypeRef)contentType.asSimpleType().getBasetype());
                }
                if ((facetArray = contentType.asSimpleType().getAllFacets()) != null) {
                    int n = 0;
                    while (n < facetArray.length) {
                        complexType2.setFacet(facetArray[n].getFacetType(), facetArray[n].getValuesAsString());
                        Facet facet = complexType2.getFacetDefinedHere(facetArray[n].getFacetType());
                        if (facet != null) {
                            facet.setFixed(facetArray[n].isFixed());
                            if (facetArray[n].getAnnotation() != null) {
                                facet.setAnnotation(facetArray[n].getAnnotation());
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        if (attributeDeclArray != null) {
            int n = 0;
            while (n < attributeDeclArray.length) {
                if (attributeDeclArray[n] instanceof AttributeRefImpl.GlobalAttributeDeclWrapper) {
                    complexType2.add((AttributeRef)((AttributeRefImpl.GlobalAttributeDeclWrapper)attributeDeclArray[n]).getAttributeRef().clone());
                } else {
                    complexType2.add((LocalAttributeDecl)LocalAttributeDeclImpl.createLocalAttributeDecl(attributeDeclArray[n]).clone());
                }
                ++n;
            }
        }
        if (attributeWildcard != null) {
            complexType2.setAttributeWildcard((AttributeWildcard)attributeWildcard.clone());
        }
    }

    public static ComplexTypeDef normalize(ComplexTypeDef complexTypeDef, Schema schema, String string) throws SchemaException {
        Schema schema2;
        int[] nArray;
        Factory factory = FactoryImpl.instance();
        ComplexTypeDef complexTypeDef2 = factory.createComplexTypeDef();
        if (string != null) {
            complexTypeDef2.setNCName(string);
        } else if (complexTypeDef.getNCName() != null) {
            complexTypeDef2.setNCName(complexTypeDef.getNCName());
        }
        complexTypeDef2.setAbstract(complexTypeDef.isAbstract());
        int[] nArray2 = complexTypeDef.getBlockList();
        if (nArray2 != null) {
            int n = 0;
            while (n < nArray2.length) {
                complexTypeDef2.addBlock(nArray2[n]);
                ++n;
            }
        }
        if ((nArray = complexTypeDef.getFinalList()) != null) {
            int n = 0;
            while (n < nArray.length) {
                complexTypeDef2.addFinal(nArray[n]);
                ++n;
            }
        }
        if ((schema2 = ComponentNormalizer.updateDestinationSchema(complexTypeDef, schema, factory)) != null) {
            schema2.addTopComponent(complexTypeDef2);
        }
        ComponentNormalizer.normalize(complexTypeDef, complexTypeDef2);
        return complexTypeDef2;
    }

    public static ComplexTypeSpec normalize(ComplexTypeSpec complexTypeSpec) throws SchemaException {
        Factory factory = FactoryImpl.instance();
        ComplexTypeSpec complexTypeSpec2 = factory.createComplexTypeSpec();
        ComponentNormalizer.normalize(complexTypeSpec, complexTypeSpec2);
        return complexTypeSpec2;
    }

    public static DatatypeDef normalize(DatatypeDef datatypeDef, Schema schema, String string) throws SchemaException {
        Schema schema2;
        Factory factory = FactoryImpl.instance();
        DatatypeDef datatypeDef2 = factory.createDatatypeDef();
        if (string != null) {
            datatypeDef2.setNCName(string);
        } else if (datatypeDef.getNCName() != null) {
            datatypeDef2.setNCName(datatypeDef.getNCName());
        }
        datatypeDef2.setAbstract(datatypeDef.isAbstract());
        int[] nArray = datatypeDef.getFinalList();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                datatypeDef2.addFinal(nArray[n]);
                ++n;
            }
        }
        if ((schema2 = ComponentNormalizer.updateDestinationSchema(datatypeDef, schema, factory)) != null) {
            schema2.addTopComponent(datatypeDef2);
        }
        DatatypeSpec datatypeSpec = DatatypeSpecImpl.getNormalizedFlattenedType(datatypeDef);
        datatypeDef2.setDatatypeSpec(datatypeSpec);
        return datatypeDef2;
    }

    public static DatatypeSpec normalize(DatatypeSpec datatypeSpec) throws SchemaException {
        return DatatypeSpecImpl.getNormalizedFlattenedType(datatypeSpec);
    }

    public static GlobalAttributeDecl normalize(GlobalAttributeDecl globalAttributeDecl, Schema schema, String string) throws SchemaException {
        SimpleType simpleType;
        Factory factory = FactoryImpl.instance();
        GlobalAttributeDecl globalAttributeDecl2 = factory.createGlobalAttributeDecl();
        if (string != null) {
            globalAttributeDecl2.setNCName(string);
        } else if (globalAttributeDecl.getNCName() != null) {
            globalAttributeDecl2.setNCName(globalAttributeDecl.getNCName());
        }
        Schema schema2 = ComponentNormalizer.updateDestinationSchema(globalAttributeDecl, schema, factory);
        if (schema2 != null) {
            schema2.addTopComponent(globalAttributeDecl2);
        }
        if ((simpleType = globalAttributeDecl.getType()) != null && simpleType.isAnonymous()) {
            if (simpleType instanceof DatatypeSpec) {
                simpleType = ComponentNormalizer.normalize((DatatypeSpec)simpleType);
            }
        } else if (simpleType != null && simpleType instanceof DatatypeDef) {
            simpleType = ComponentNormalizer.normalize(((DatatypeDef)simpleType).getDatatypeSpec());
        }
        if (simpleType != null) {
            globalAttributeDecl2.setType(simpleType);
        }
        return globalAttributeDecl2;
    }

    public static GlobalElementDecl normalize(GlobalElementDecl globalElementDecl, Schema schema, String string) throws SchemaException {
        Type type;
        Schema schema2;
        ElementRef elementRef;
        int[] nArray;
        Factory factory = FactoryImpl.instance();
        GlobalElementDecl globalElementDecl2 = factory.createGlobalElementDecl();
        if (string != null) {
            globalElementDecl2.setNCName(string);
        } else if (globalElementDecl.getNCName() != null) {
            globalElementDecl2.setNCName(globalElementDecl.getNCName());
        }
        globalElementDecl2.setAbstract(globalElementDecl.isAbstract());
        int[] nArray2 = globalElementDecl.getBlockList();
        if (nArray2 != null) {
            int n = 0;
            while (n < nArray2.length) {
                globalElementDecl2.addBlock(nArray2[n]);
                ++n;
            }
        }
        if ((nArray = globalElementDecl.getFinalList()) != null) {
            int n = 0;
            while (n < nArray.length) {
                globalElementDecl2.addFinal(nArray[n]);
                ++n;
            }
        }
        if ((elementRef = globalElementDecl.getSubstitutionAffiliation()) != null) {
            globalElementDecl2.setSubstitutionAffiliation((ElementRef)elementRef.clone());
        }
        if ((schema2 = ComponentNormalizer.updateDestinationSchema(globalElementDecl, schema, factory)) != null) {
            schema2.addTopComponent(globalElementDecl2);
        }
        if ((type = globalElementDecl.getEffectiveType()) != null && type.isAnonymous()) {
            if (type instanceof ComplexTypeSpec) {
                type = ComponentNormalizer.normalize((ComplexTypeSpec)type);
            } else if (type instanceof DatatypeSpec) {
                type = ComponentNormalizer.normalize((DatatypeSpec)type);
            }
        } else if (type != null) {
            if (type instanceof DatatypeDef) {
                type = ComponentNormalizer.normalize(((DatatypeDef)type).getDatatypeSpec());
            } else if (type instanceof ComplexTypeDef) {
                type = ComponentNormalizer.normalize(((ComplexTypeDef)type).getComplexTypeSpec());
            }
        }
        if (type != null) {
            globalElementDecl2.setExplicitType(type);
        }
        return globalElementDecl2;
    }

    public static ModelGroupDef normalize(ModelGroupDef modelGroupDef, Schema schema, String string) throws SchemaException {
        Group group;
        Factory factory = FactoryImpl.instance();
        ModelGroupDef modelGroupDef2 = factory.createModelGroupDef();
        if (string != null) {
            modelGroupDef2.setNCName(string);
        } else if (modelGroupDef.getNCName() != null) {
            modelGroupDef2.setNCName(modelGroupDef.getNCName());
        }
        Schema schema2 = ComponentNormalizer.updateDestinationSchema(modelGroupDef, schema, factory);
        if (schema2 != null) {
            schema2.addTopComponent(modelGroupDef2);
        }
        if ((group = modelGroupDef.getGroup()) != null) {
            modelGroupDef2.setGroup(ComponentNormalizer.expandAndNormalize(group, true));
        }
        return modelGroupDef2;
    }

    public static NotationDecl normalize(NotationDecl notationDecl, Schema schema, String string) throws SchemaException {
        Schema schema2;
        String string2;
        Factory factory = FactoryImpl.instance();
        NotationDecl notationDecl2 = factory.createNotationDecl();
        if (string != null) {
            notationDecl2.setNCName(string);
        } else if (notationDecl.getNCName() != null) {
            notationDecl2.setNCName(notationDecl.getNCName());
        }
        URI uRI = notationDecl.getSystem();
        if (uRI != null) {
            notationDecl2.setSystem((URI)uRI.clone());
        }
        if ((string2 = notationDecl.getPublic()) != null) {
            notationDecl2.setPublic(new String(string2));
        }
        if ((schema2 = ComponentNormalizer.updateDestinationSchema(notationDecl, schema, factory)) != null) {
            schema2.addTopComponent(notationDecl2);
        }
        return notationDecl2;
    }

    public static TopComponent normalize(TopComponent topComponent, Schema schema, String string) throws SchemaException {
        if (topComponent instanceof AttributeGroupDef) {
            return ComponentNormalizer.normalize((AttributeGroupDef)topComponent, schema, string);
        }
        if (topComponent instanceof GlobalAttributeDecl) {
            return ComponentNormalizer.normalize((GlobalAttributeDecl)topComponent, schema, string);
        }
        if (topComponent instanceof GlobalElementDecl) {
            return ComponentNormalizer.normalize((GlobalElementDecl)topComponent, schema, string);
        }
        if (topComponent instanceof ModelGroupDef) {
            return ComponentNormalizer.normalize((ModelGroupDef)topComponent, schema, string);
        }
        if (topComponent instanceof ComplexTypeDef) {
            return ComponentNormalizer.normalize((ComplexTypeDef)topComponent, schema, string);
        }
        if (topComponent instanceof DatatypeDef) {
            return ComponentNormalizer.normalize((DatatypeDef)topComponent, schema, string);
        }
        if (topComponent instanceof NotationDecl) {
            return ComponentNormalizer.normalize((NotationDecl)topComponent, schema, string);
        }
        return topComponent;
    }

    private static boolean removePointLessGroup(Group group) throws SchemaException {
        int n;
        if (group.getMaxOccurs().trim().equals("0") && group.listParticle() != null && group.listParticle().length > 0) {
            while (group.listParticle() != null && group.listParticle().length > 0) {
                group.removeParticle(group.listParticle()[0]);
            }
            return true;
        }
        Particle[] particleArray = group.listParticle();
        boolean bl = false;
        Vector<Particle> vector = new Vector<Particle>();
        if (particleArray != null) {
            int n2 = 0;
            while (n2 < particleArray.length) {
                if (particleArray[n2].getMaxOccurs().trim().equals("0")) {
                    vector.add(particleArray[n2]);
                } else if (particleArray[n2].isGroup() && particleArray[n2].asGroup().isEmpty() && (particleArray[n2].asGroup().getCompositor() != 1 || particleArray[n2].asGroup().getMinOccursAsInt() == 0)) {
                    vector.add(particleArray[n2]);
                }
                ++n2;
            }
            n = 0;
            while (n < vector.size()) {
                group.removeParticle((Particle)vector.get(n));
                ++n;
            }
        }
        if ((particleArray = group.listParticle()) != null) {
            Particle[] particleArray2 = new Particle[particleArray.length];
            System.arraycopy(particleArray, 0, particleArray2, 0, particleArray.length);
            particleArray = particleArray2;
            n = 0;
            while (n < particleArray.length) {
                if (particleArray[n].isGroup()) {
                    if (particleArray[n].getMaxOccurs().trim().equals("1") && particleArray[n].getMinOccurs().trim().equals("1") && (group.getCompositor() == particleArray[n].asGroup().getCompositor() || RestrictableHelper.hasOnlyOneMember(particleArray[n].asGroup().listParticle()))) {
                        Particle[] particleArray3 = particleArray[n].asGroup().listParticle();
                        NamespaceDeclaration[] namespaceDeclarationArray = particleArray[n].listNamespaceDecl();
                        bl = true;
                        if (particleArray3 != null) {
                            particleArray2 = new Particle[particleArray3.length];
                            System.arraycopy(particleArray3, 0, particleArray2, 0, particleArray3.length);
                            particleArray3 = particleArray2;
                            int n3 = 0;
                            while (n3 < particleArray3.length) {
                                if (namespaceDeclarationArray != null) {
                                    int n4 = 0;
                                    while (n4 < namespaceDeclarationArray.length) {
                                        NamespaceDeclaration namespaceDeclaration = FactoryImpl.instance().createNamespaceDeclaration();
                                        if (namespaceDeclarationArray[n4].getPrefix() != null) {
                                            namespaceDeclaration.setPrefix(namespaceDeclarationArray[n4].getPrefix());
                                        }
                                        if (namespaceDeclarationArray[n4].getTargetNamespace() != null) {
                                            namespaceDeclaration.setTargetNamespace(namespaceDeclarationArray[n4].getTargetNamespace());
                                        }
                                        particleArray3[n3].addNamespaceDecl(namespaceDeclaration);
                                        ++n4;
                                    }
                                }
                                particleArray[n].asGroup().removeParticle(particleArray3[n3]);
                                if (n3 == 0) {
                                    group.replaceParticle(particleArray[n], particleArray3[n3]);
                                } else if (n + 1 < particleArray.length) {
                                    group.insertBefore(particleArray[n + 1], particleArray3[n3]);
                                } else {
                                    group.addParticle(particleArray3[n3]);
                                }
                                ++n3;
                            }
                        }
                    } else {
                        ComponentNormalizer.removePointLessGroup(particleArray[n].asGroup());
                    }
                }
                ++n;
            }
        }
        while (bl) {
            bl = ComponentNormalizer.removePointLessGroup(group);
        }
        return false;
    }

    public static Group removePointLessGroup(Group group, boolean bl) throws SchemaException {
        Group group2 = bl ? (Group)group.clone() : group;
        ComponentNormalizer.removePointLessGroup(group2);
        return group2;
    }

    public static void setAddInfoAboutSchemaObjectOrigin(boolean bl) {
        addInfoAboutSchemaObjectOrigin = bl;
    }

    public static void setStopAtBuiltInComponents(boolean bl) {
        stopAtBuiltInComponents = bl;
    }

    public static boolean stopAtBuiltInComponents() {
        return stopAtBuiltInComponents;
    }

    private static Schema updateDestinationSchema(TopComponent topComponent, Schema schema, Factory factory) throws SchemaException {
        Schema schema2 = schema;
        if (topComponent.getSchema() != null) {
            if (schema != null) {
                if (schema.getTargetNamespace() == null && topComponent.getSchema().getTargetNamespace() != null || schema.getTargetNamespace() != null && !schema.getTargetNamespace().equals(topComponent.getSchema().getTargetNamespace())) {
                    throw new IllegalArgumentException(schema + " must have the same namespace as" + topComponent);
                }
                schema2 = schema;
            } else {
                schema2 = topComponent.getSchema();
                if (schema2 != null) {
                    schema2 = ((SchemaImpl)schema2).softClone();
                }
            }
            ImportStatement[] importStatementArray = topComponent.getSchema().listImportStatement();
            if (importStatementArray != null) {
                int n = 0;
                while (n < importStatementArray.length) {
                    ImportStatement importStatement = factory.createImportStatement();
                    importStatement.setLocation(importStatementArray[n].getLocation());
                    importStatement.setExplicitTargetNamespace(importStatementArray[n].getExplicitTargetNamespace());
                    schema2.addImportStatement(importStatement);
                    ++n;
                }
            }
        }
        return schema2;
    }

    static {
        DECMNS.setValue(DECMNS_AS_STRING);
        addInfoAboutSchemaObjectOrigin = false;
    }

    static class GroupAnnotatingVisitor
    extends SchemaObjectVisitorImpl {
        private TopComponent source;

        GroupAnnotatingVisitor(TopComponent topComponent) {
            this.source = topComponent;
        }

        public void visitGroup(Group group) {
            Particle[] particleArray = group.listParticle();
            if (particleArray != null) {
                int n = 0;
                while (n < particleArray.length) {
                    particleArray[n].accept(this);
                    ++n;
                }
            }
        }

        public void visitLocalElementDecl(LocalElementDecl localElementDecl) {
            this.annotate(localElementDecl);
        }

        public void visitElementRef(ElementRef elementRef) {
            this.annotate(elementRef);
        }

        public void visitParticleWildcard(ParticleWildcard particleWildcard) {
            this.annotate(particleWildcard);
        }

        public void annotate(SchemaComponent schemaComponent) {
            appinfo appinfo2;
            Annotation annotation = schemaComponent.getAnnotation();
            if (annotation == null) {
                annotation = FactoryImpl.instance().createAnnotation();
                annotation.addInfo(ComponentNormalizer.createDECMAppInfo(FactoryImpl.instance()));
                schemaComponent.setAnnotation(annotation);
            }
            if ((appinfo2 = ComponentNormalizer.getDECMAppInfo(annotation)) == null) {
                appinfo2 = ComponentNormalizer.createDECMAppInfo(FactoryImpl.instance());
                annotation.addInfo(appinfo2);
            }
            ComponentNormalizer.addPathElement(appinfo2, this.source, new DocumentImpl());
        }
    }

    private static class ExpandModelGroupVisitor
    extends ReferenceVisitor {
        private ExpandModelGroupVisitor() {
        }

        public void visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
        }

        public void visitAttributeRef(AttributeRef attributeRef) {
        }

        public void visitComplexTypeRef(ComplexTypeRef complexTypeRef) {
        }

        public void visitDatatypeRef(DatatypeRef datatypeRef) {
        }

        public void visitElementRef(ElementRef elementRef) {
        }

        public void visitModelGroupRef(ModelGroupRef modelGroupRef) {
            try {
                ModelGroupDef modelGroupDef = (ModelGroupDef)modelGroupRef.resolve(false);
                Group group = (Group)modelGroupDef.getGroup().clone();
                group.setMaxOccurs(modelGroupRef.getMaxOccurs());
                group.setMinOccurs(modelGroupRef.getMinOccurs());
                SchemaObject schemaObject = modelGroupRef.getParent();
                if (schemaObject instanceof Group) {
                    Group group2 = (Group)schemaObject;
                    group2.replaceParticle(modelGroupRef, group);
                } else if (schemaObject instanceof ContentModel) {
                    ((ContentModel)schemaObject).setParticle(group);
                }
                group.accept(new ExpandModelGroupVisitor());
                if (ComponentNormalizer.addInfoAboutSchemaObjectOrigin()) {
                    group.accept(new GroupAnnotatingVisitor(modelGroupDef));
                }
            }
            catch (SchemaException schemaException) {
                // empty catch block
            }
        }

        public void visitTypeRef(TypeRef typeRef) {
        }
    }
}

