/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.ContentTypeCategoryIncompatibleWithBasetypeException;
import com.ibm.xml.ecm.schema.ContentTypeIncompatibleWithBasetypeContentTypeException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.Restrictable;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Checker;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.ComplexTypeDerivationMethod_Checker;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import java.util.Arrays;
import java.util.Vector;

public class ContentTypeCompatibleWithBasetype_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static CheckType ID = new CheckType("ComplexType Compatible with basetype's contentType Checker");
    private ContentType basetypeContentType;
    private ContentType candidateContentType;
    private SchemaException[] exceptions;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl;

    public ContentTypeCompatibleWithBasetype_Checker() {
    }

    public ContentTypeCompatibleWithBasetype_Checker(ComplexTypeSpecImpl complexTypeSpecImpl) {
        super(complexTypeSpecImpl);
    }

    public boolean check(boolean bl) {
        ComplexTypeSpecImpl complexTypeSpecImpl = (ComplexTypeSpecImpl)this.subject;
        int n = complexTypeSpecImpl.getDerivationType();
        Vector vector = new Vector();
        this.exceptions = null;
        try {
            if (ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(complexTypeSpecImpl.getNamedType() == null ? complexTypeSpecImpl : complexTypeSpecImpl.getNamedType()) != null) {
                return true;
            }
            TypeInfo typeInfo = complexTypeSpecImpl.getBasetype();
            if (typeInfo == null) {
                return true;
            }
            this.basetypeContentType = complexTypeSpecImpl.getBasetypeEffectiveContentType();
            if (this.basetypeContentType == null) {
                return true;
            }
            this.candidateContentType = complexTypeSpecImpl.getEffectiveContentTypeWithoutErrorChecking();
            if (this.candidateContentType == null) {
                return true;
            }
            if (n == 1) {
                return this.checkExtensionDerivation(complexTypeSpecImpl);
            }
            if (n == 0) {
                if (BuiltInDatatypeFactory.getInstance().getAnyType().equals(typeInfo.resolveToType())) {
                    return true;
                }
                return this.checkRestrictionDerivation(complexTypeSpecImpl);
            }
            return true;
        }
        catch (SchemaException schemaException) {
            if (Debug.DEBUG) {
                schemaException.printStackTrace(System.err);
            }
            return true;
        }
    }

    private boolean checkExtensionDerivation(ComplexTypeSpecImpl complexTypeSpecImpl) {
        Facet[] facetArray = complexTypeSpecImpl.listFacet();
        ComplexType complexType = (ComplexType)complexTypeSpecImpl.getNamedType();
        ComplexType complexType2 = complexType = complexType == null ? complexTypeSpecImpl : complexType;
        if (this.basetypeContentType.isSimpleType() && this.candidateContentType.isSimpleType()) {
            if (facetArray != null && facetArray.length != 0) {
                this.exceptions = new SchemaException[]{new ContentTypeCategoryIncompatibleWithBasetypeException(complexType, this.basetypeContentType, this.candidateContentType)};
                return false;
            }
            return true;
        }
        if (this.candidateContentType.isEmptyContentModel() && this.basetypeContentType.isEmptyContentModel()) {
            return true;
        }
        if (this.candidateContentType.isSimpleType()) {
            this.exceptions = new SchemaException[]{new ContentTypeCategoryIncompatibleWithBasetypeException(complexType, this.basetypeContentType, this.candidateContentType)};
            return false;
        }
        if (this.basetypeContentType.isEmptyContentModel()) {
            return true;
        }
        if (this.basetypeContentType.isMixedContentModel() & this.candidateContentType.isMixedContentModel() || this.basetypeContentType.isElementOnlyContentModel() & this.candidateContentType.isElementOnlyContentModel()) {
            return true;
        }
        if (this.basetypeContentType != null && (this.basetypeContentType.asContentModel() == null || this.basetypeContentType.asContentModel() != null && this.basetypeContentType.asContentModel().getParticle() == null)) {
            return true;
        }
        if (this.basetypeContentType != null && this.candidateContentType != null && this.basetypeContentType.asContentModel() != null && this.candidateContentType.asContentModel() != null && this.candidateContentType.isEmptyContentModel() && complexTypeSpecImpl != null) {
            try {
                if (complexTypeSpecImpl.getEffectiveAttributesWithoutErrorChecking() != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.exceptions = new SchemaException[]{new ContentTypeIncompatibleWithBasetypeContentTypeException(complexType, this.basetypeContentType, this.candidateContentType)};
        return false;
    }

    private boolean checkRestrictionDerivation(ComplexTypeSpecImpl complexTypeSpecImpl) {
        try {
            Object object;
            Checker[] checkerArray;
            if (this.basetypeContentType != null && this.basetypeContentType.isMixedContentModel() && (this.basetypeContentType.asContentModel().getParticle() == null || this.basetypeContentType.asContentModel().getParticle().isEmptiable())) {
                if (complexTypeSpecImpl.getDatatypeSpecToRestrict() == null && this.candidateContentType != null && !this.candidateContentType.isContentModel()) {
                    this.exceptions = new SchemaException[]{new SchemaException("A complexType with a simple content whose base type content type is mixed must specify a simple type")};
                    return false;
                }
                if (this.candidateContentType.isSimpleType() && (checkerArray = ((SchemaObjectImpl)((Object)this.candidateContentType.asSimpleType())).getCheckers()) != null) {
                    object = new Vector();
                    CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
                    int n = 0;
                    while (n < checkerArray.length) {
                        SchemaException[] schemaExceptionArray;
                        if (!checkerManagerImpl.check(checkerArray[n], true) && (schemaExceptionArray = checkerArray[n].getExceptions()) != null) {
                            ((Vector)object).addAll(Arrays.asList(schemaExceptionArray));
                        }
                        ++n;
                    }
                    if (((Vector)object).size() > 0) {
                        this.exceptions = ((Vector)object).toArray(new SchemaException[0]);
                        return false;
                    }
                }
            }
            if (this.candidateContentType.isSimpleType()) {
                if (this.basetypeContentType.isSimpleType()) {
                    checkerArray = this.basetypeContentType.asSimpleType();
                    if (this.candidateContentType.asSimpleType().isDerivedFromGivenSomeDerivationMethods((Type)checkerArray, new int[0])) {
                        return true;
                    }
                } else if (this.basetypeContentType.isMixedContentModel() && (this.basetypeContentType.asContentModel().getParticle() == null || this.basetypeContentType.asContentModel().getParticle().isEmptiable())) {
                    return true;
                }
            } else if (this.candidateContentType.isEmptyContentModel()) {
                if (this.basetypeContentType.isEmptyContentModel()) {
                    return true;
                }
                if ((this.basetypeContentType.isMixedContentModel() || this.basetypeContentType.isElementOnlyContentModel()) && (this.basetypeContentType.asContentModel().getParticle() == null || this.basetypeContentType.asContentModel().getParticle().isEmptiable())) {
                    return true;
                }
            } else if (this.basetypeContentType.isMixedContentModel() || this.candidateContentType.isElementOnlyContentModel()) {
                checkerArray = this.basetypeContentType.asContentModel().getParticle();
                object = this.candidateContentType.asContentModel().getParticle();
                if (object == null || object.getMaxEffectiveTotalRange().equals("0")) {
                    if (checkerArray == null || checkerArray.getMaxEffectiveTotalRange().equals("0")) {
                        return true;
                    }
                    if (checkerArray != null && checkerArray.isEmptiable()) {
                        return true;
                    }
                } else if (checkerArray == null || checkerArray.getMaxEffectiveTotalRange().equals("0") ? object.getMaxEffectiveTotalRange().equals("0") : object.isRestrictionOf((Restrictable)checkerArray, null)) {
                    return true;
                }
            }
            if ((checkerArray = complexTypeSpecImpl.getNamedType()) == null) {
                checkerArray = complexTypeSpecImpl;
            }
            this.exceptions = new SchemaException[]{new ContentTypeIncompatibleWithBasetypeContentTypeException((ComplexType)checkerArray, this.basetypeContentType, this.candidateContentType)};
            return false;
        }
        catch (SchemaException schemaException) {
            if (Debug.DEBUG) {
                schemaException.printStackTrace(System.err);
            }
            return this.exceptions == null;
        }
    }

    public ContentType getBasetypeEffectiveContentType() {
        return this.basetypeContentType;
    }

    public ContentType getCandidateContentTyep() {
        return this.candidateContentType;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 5;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl == null ? (class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl = ContentTypeCompatibleWithBasetype_Checker.class$("com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl")) : class$com$ibm$xml$ecm$schema$impl$ComplexTypeSpecImpl;
    }

    public void setBasetypeEffectiveContentType(ContentType contentType) {
        this.basetypeContentType = contentType;
    }

    public void setCandidateContentType(ContentType contentType) {
        this.candidateContentType = contentType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

