/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import com.ibm.xml.ecm.schema.impl.Order;
import com.ibm.xml.ecm.schema.impl.TimeLiteral;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class DateTimeLiteral
extends LiteralValueImpl
implements Order {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Date value;
    protected String valueAsString;
    protected String pattern;
    protected static final String optionalEraRegex = "(?:(?:BC)|(?:AD))?";
    protected static final String yearRegex = "\\d{4,}";
    protected static final String monthRegex = "(?:(?:0[1-9])|(?:1[0-2]))";
    protected static final String dayRegex = "(?:(?:0[1-9])|(?:[1-2][0-9])|(?:3[0-1]))";
    protected static final String hourRegex = "(?:(?:[0-1][0-9])|(?:2[0-3]))";
    protected static final String minRegex = "(?:[0-5][0-9])";
    protected static final String secWithoutMillisRegex = "(?:[0-5][0-9])";
    protected static final String secWithMillisRegex = "(?:[0-5][0-9])\\.\\d+";
    protected static final String optionalTimeZoneRegex = "(?:Z|(?:(?:-|\\+)(?:14:00|(?:0[0-9]|1[0-3]):(?:[0-5][0-9]))))?";
    protected static RegularExpression timeWithMillis = new RegularExpression("(?:24:00:00|(?:(?:[0-1][0-9])|(?:2[0-3])):(?:[0-5][0-9]):(?:[0-5][0-9])\\.\\d+)");
    protected static RegularExpression regexWithMillis = new RegularExpression("(?:(?:BC)|(?:AD))?\\d{4,}-(?:(?:0[1-9])|(?:1[0-2]))-(?:(?:0[1-9])|(?:[1-2][0-9])|(?:3[0-1]))T" + timeWithMillis + "(?:Z|(?:(?:-|\\+)(?:14:00|(?:0[0-9]|1[0-3]):(?:[0-5][0-9]))))?");
    protected static RegularExpression timeWithoutMillis = new RegularExpression("(?:24:00:00|(?:(?:[0-1][0-9])|(?:2[0-3])):(?:[0-5][0-9]):(?:[0-5][0-9]))");
    protected static RegularExpression regexWithoutMillis = new RegularExpression("(?:(?:BC)|(?:AD))?\\d{4,}-(?:(?:0[1-9])|(?:1[0-2]))-(?:(?:0[1-9])|(?:[1-2][0-9])|(?:3[0-1]))T" + timeWithoutMillis + "(?:Z|(?:(?:-|\\+)(?:14:00|(?:0[0-9]|1[0-3]):(?:[0-5][0-9]))))?");
    private static final GregorianCalendar cal = new GregorianCalendar();
    private boolean timeZoneSpecified;
    private TimeZone timeZone;

    private DateTimeLiteral() {
    }

    public DateTimeLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        return null;
    }

    protected void checkForbiddenTrailingZeroForYear(String string) throws DatatypeFormatException {
        String string2 = string.charAt(0) == '-' ? string.substring(1) : string;
        int n = string2.indexOf(45);
        if ((string2 = string2.substring(0, n)).equals("0000")) {
            throw new DatatypeFormatException((SimpleType)BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("dateTime"), this.valueAsString, "0000 is not a valid year.");
        }
        if (string2.length() > 4 && string2.charAt(0) == '0') {
            throw new DatatypeFormatException((SimpleType)BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("dateTime"), this.valueAsString, "Leading zeros are prohibited for year when more than 4 digits are used to represent year.");
        }
    }

    protected void conversion(String string) throws DatatypeFormatException {
        try {
            this.valueAsString = string;
            this.parse(string);
            this.checkForbiddenTrailingZeroForYear(string);
            if (!this.isYearAndMonthConsistentWithDay(string.substring(0, string.indexOf("T")))) {
                throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("dateTime"), this.valueAsString);
            }
        }
        catch (ParseException parseException) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("dateTime"), this.valueAsString);
        }
    }

    protected String dateWithEra(String string) {
        return this.dateWithEra(string, true);
    }

    protected String dateWithEra(String string, boolean bl) {
        if (bl) {
            this.pattern = "G" + this.pattern;
        }
        String string2 = string.length() > 1 && new String(new char[]{string.charAt(0)}).equals("-") ? "BC" + string.substring(1) : "AD" + string;
        return string2;
    }

    public boolean equals(Object object) {
        int[] nArray = new int[1];
        boolean bl = this.isComparable(object, nArray);
        return bl && nArray[0] == 0;
    }

    protected String formatYear(int n) {
        String string = "";
        if (n < 0) {
            n = -n;
            string = "-";
        }
        if (n <= 9) {
            return string + "000" + String.valueOf(n);
        }
        if (n <= 99) {
            return string + "00" + String.valueOf(n);
        }
        if (n <= 999) {
            return string + "0" + String.valueOf(n);
        }
        return string + String.valueOf(n);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return (TimeZone)this.timeZone.clone();
        }
        return null;
    }

    protected int getTimeZoneIndex(String string) {
        int n = string.indexOf("Z");
        if (n == -1 && (n = string.indexOf("+")) == -1 && string.indexOf("T") != -1 && (n = string.lastIndexOf("-")) <= string.indexOf("T")) {
            n = -1;
        }
        return n;
    }

    public Object getValue() {
        return this.value;
    }

    private String gMTOffSet(int n) {
        int n2 = n / 60;
        return (n2 > 9 ? String.valueOf(n2) : "0" + String.valueOf(n2)) + ":" + (n > 9 ? String.valueOf(n) : "0" + String.valueOf(n %= 60));
    }

    protected boolean hasMoreThanXMinus(int n, String string) {
        int n2;
        int n3 = 0;
        while (n3 < n) {
            n2 = string.indexOf("-");
            if (n2 == -1 || n2 == string.length() - 1) {
                return false;
            }
            string = string.substring(n2 + 1);
            ++n3;
        }
        n2 = string.indexOf("-");
        return n2 != -1;
    }

    public boolean inOrder(Object object) {
        int[] nArray = new int[1];
        boolean bl = this.isComparable(object, nArray);
        return bl && nArray[0] <= 0;
    }

    public boolean isComparable(Object object, int[] nArray) {
        if (object != null && object.getClass() != null && object.getClass().getName() != null && this.getClass() != null && this.getClass().getName() != null && this.getClass().getName().equals(object.getClass().getName())) {
            DateTimeLiteral dateTimeLiteral = (DateTimeLiteral)object;
            Date date = dateTimeLiteral.value;
            if (!(this.isTimeZoneSpecified() ^ dateTimeLiteral.isTimeZoneSpecified())) {
                if (nArray != null && nArray.length > 0) {
                    nArray[0] = this.value.equals(date) ? 0 : (this.value.before(date) ? -1 : 1);
                }
                return true;
            }
            if (this.isTimeZoneSpecified()) {
                if (this.value.before(date = this.newDateWithSpecificTimeZone(date, 840)) || this.value.equals(date)) {
                    if (nArray != null && nArray.length > 0) {
                        nArray[0] = -1;
                    }
                    return true;
                }
                date = this.newDateWithSpecificTimeZone(dateTimeLiteral.value, -840);
                if (this.value.after(date) || this.value.equals(date)) {
                    if (nArray != null && nArray.length > 0) {
                        nArray[0] = 1;
                    }
                    return true;
                }
                return false;
            }
            Date date2 = this.newDateWithSpecificTimeZone(this.value, -840);
            if (date2.before(date) || date2.equals(date)) {
                if (nArray != null && nArray.length > 0) {
                    nArray[0] = -1;
                }
                return true;
            }
            date2 = this.newDateWithSpecificTimeZone(this.value, 840);
            if (date2.after(date) || date2.equals(date)) {
                if (nArray != null && nArray.length > 0) {
                    nArray[0] = 1;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isComparable(Object object, boolean[] blArray) {
        int[] nArray = new int[1];
        boolean bl = this.isComparable(object, nArray);
        if (!bl) {
            return false;
        }
        if (nArray[0] <= 0 && blArray != null && blArray.length > 0) {
            blArray[0] = true;
        }
        return true;
    }

    public boolean isEqual(Object object) {
        return this.equals(object);
    }

    public boolean isTimeZoneSpecified() {
        return this.timeZoneSpecified;
    }

    public boolean isTotallyOrdered() {
        return false;
    }

    protected boolean isYearAndMonthConsistentWithDay(String string) {
        try {
            int n;
            int n2;
            boolean bl = string.startsWith("BC");
            boolean bl2 = string.startsWith("AD");
            if (!bl && !bl2) {
                return this.isYearAndMonthConsistentWithDay(this.dateWithEra(string, false));
            }
            string = bl ? "-" + string.substring(2) : string.substring(2);
            string = this.removeTimeZone(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            int n3 = -1;
            boolean bl3 = false;
            if (stringTokenizer.countTokens() == 3) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
                bl3 = true;
            } else if (stringTokenizer.countTokens() == 2) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
            } else {
                return true;
            }
            if (n2 == 1 | n2 == 3 | n2 == 5 | n2 == 7 | n2 == 8 | n2 == 10 | n2 == 12) {
                return n <= 31;
            }
            if (n2 != 2) {
                return n <= 30;
            }
            if (!bl3) {
                return n <= 29;
            }
            if (cal.isLeapYear(n3)) {
                return n <= 29;
            }
            return n <= 28;
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace(System.err);
            }
            return false;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DateTimeLiteral dateTimeLiteral = new DateTimeLiteral("2000-01-15T00:00:00");
        DateTimeLiteral dateTimeLiteral2 = new DateTimeLiteral("2000-02-15T00:00:00");
        int[] nArray = new int[1];
        boolean bl = dateTimeLiteral.isComparable((Object)dateTimeLiteral2, nArray);
        System.out.println(dateTimeLiteral + " is comparable to " + dateTimeLiteral2 + " : " + bl);
        if (bl) {
            System.out.println("result of comparision = " + nArray[0]);
        }
        dateTimeLiteral = new DateTimeLiteral("2000-01-01T12:00:00");
        dateTimeLiteral2 = new DateTimeLiteral("1999-12-31T23:00:00Z");
        bl = dateTimeLiteral.isComparable((Object)dateTimeLiteral2, nArray);
        System.out.println(dateTimeLiteral + " is comparable to " + dateTimeLiteral2 + " : " + bl);
        if (bl) {
            System.out.println("result of comparision = " + nArray[0]);
        }
        dateTimeLiteral = new DateTimeLiteral("2000-01-15T12:00:00");
        dateTimeLiteral2 = new DateTimeLiteral("2000-01-16T12:00:00Z");
        bl = dateTimeLiteral.isComparable((Object)dateTimeLiteral2, nArray);
        System.out.println(dateTimeLiteral + " is comparable to " + dateTimeLiteral2 + " : " + bl);
        if (bl) {
            System.out.println("result of comparision = " + nArray[0]);
        }
        dateTimeLiteral = new DateTimeLiteral("2000-01-16T12:00:00");
        dateTimeLiteral2 = new DateTimeLiteral("2000-01-16T12:00:00Z");
        bl = dateTimeLiteral.isComparable((Object)dateTimeLiteral2, nArray);
        System.out.println(dateTimeLiteral + " is comparable to " + dateTimeLiteral2 + " : " + bl);
        if (bl) {
            System.out.println("result of comparision = " + nArray[0]);
        }
        dateTimeLiteral = new TimeLiteral("12:00:00");
        dateTimeLiteral2 = new TimeLiteral("23:00:00Z");
        bl = dateTimeLiteral.isComparable((Object)dateTimeLiteral2, nArray);
        System.out.println(dateTimeLiteral + " is comparable to " + dateTimeLiteral2 + " : " + bl);
        if (bl) {
            System.out.println("result of comparision = " + nArray[0]);
        }
    }

    private Date newDateWithSpecificTimeZone(Date date, int n) {
        Date date2 = new Date(date.getTime() - (long)(n * 60000));
        return date2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(String string) throws ParseException, DatatypeFormatException {
        Match match = new Match();
        int n = string.indexOf(".");
        if (n != -1) {
            String string2;
            String string3 = string.substring(n);
            if ((n = string3.indexOf("Z")) == -1) {
                n = string3.indexOf("+");
            }
            if (n == -1) {
                n = string3.indexOf("-");
            }
            this.pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSS";
            if (string3.length() > 1) {
                int n2 = 0;
                if (n == -1) {
                    n2 = string3.substring(1).length();
                } else if (n != 1) {
                    n2 = string3.substring(1, n).length();
                }
                int n3 = 0;
                while (n3 < n2) {
                    this.pattern = this.pattern + "S";
                    ++n3;
                }
            }
            if (!regexWithMillis.matches(string2 = this.dateWithEra(string), match) || !match.getCapturedText(0).equals(string2.trim())) throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("dateTime"), string);
            this.XMLSchemaZoneTimeFormat(string2, new SimpleDateFormat(this.pattern));
            return;
        } else {
            this.pattern = "yyyy-MM-dd'T'HH:mm:ss";
            String string4 = this.dateWithEra(string);
            if (!regexWithoutMillis.matches(string4, match) || !match.getCapturedText(0).equals(string4.trim())) throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("dateTime"), string);
            this.XMLSchemaZoneTimeFormat(string4, new SimpleDateFormat(this.pattern));
        }
    }

    protected String removeTimeZone(String string) {
        int n = this.getTimeZoneIndex(string);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    protected String to2charsString(int n) {
        return n > 9 ? String.valueOf(n) : "0" + String.valueOf(n);
    }

    public String toString() {
        return this.valueAsString;
    }

    protected void XMLSchemaZoneTimeFormat(String string, SimpleDateFormat simpleDateFormat) throws ParseException {
        int n = this.getTimeZoneIndex(string);
        if (n != -1) {
            simpleDateFormat = new SimpleDateFormat(simpleDateFormat.toPattern() + "zz");
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            if (new String(new char[]{string.charAt(n)}).equals("Z") && string.length() == n + 1) {
                stringBuffer.append("GMT+00:00");
                this.timeZone = TimeZone.getTimeZone("GMT+00:00");
            } else if (string.length() > n + 1) {
                String string2 = string.substring(n);
                stringBuffer.append("GMT" + string2);
                this.timeZone = TimeZone.getTimeZone("GMT" + string2);
            }
            this.timeZoneSpecified = true;
            this.value = simpleDateFormat.parse(stringBuffer.toString());
        } else {
            this.value = simpleDateFormat.parse(string);
            this.timeZoneSpecified = false;
        }
    }

    protected String zoneOffSet(int n) {
        String string;
        if (n >= 0) {
            string = new String("+");
        } else {
            n = -n;
            string = new String("-");
        }
        int n2 = n / 3600000;
        int n3 = (n -= 3600000 * n2) / 60000;
        return string + this.to2charsString(n2) + ":" + this.to2charsString(n3);
    }
}

