/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.DateTimeLiteral;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class DayLiteral
extends DateTimeLiteral {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DayLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        try {
            return new DayLiteral(new String(this.valueAsString));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            datatypeFormatException.printStackTrace(System.err);
            return null;
        }
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        try {
            String string2 = "---dd";
            RegularExpression regularExpression = new RegularExpression("---(?:(?:0[1-9])|(?:[1-2][0-9])|(?:3[0-1]))(?:Z|(?:(?:-|\\+)(?:14:00|(?:0[0-9]|1[0-3]):(?:[0-5][0-9]))))?");
            Match match = new Match();
            if (!regularExpression.matches(string, match) || !match.getCapturedText(0).equals(string.trim())) {
                throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gDay"), this.valueAsString);
            }
            this.XMLSchemaZoneTimeFormat(string, new SimpleDateFormat(string2));
        }
        catch (ParseException parseException) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gDay"), this.valueAsString);
        }
    }

    protected int getTimeZoneIndex(String string) {
        int n = string.indexOf("Z");
        if (n == -1 && (n = string.indexOf("+")) == -1 && (n = string.lastIndexOf("-")) <= string.indexOf("---") + 2) {
            n = -1;
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("zone offset in mins = " + Calendar.getInstance().get(15) / 60000);
        System.out.println("day light saving in mins = " + Calendar.getInstance().get(16) / 60000);
        System.out.println("1970 is leap year : " + new GregorianCalendar().isLeapYear(1970));
        System.out.println("1971 is leap year : " + new GregorianCalendar().isLeapYear(1971));
        int n = 0;
        while (n < stringArray.length) {
            DayLiteral dayLiteral = new DayLiteral(stringArray[n]);
            System.out.println("current day = " + dayLiteral);
            System.out.println("previous day = " + dayLiteral.previous());
            System.out.println("next day = " + dayLiteral.next());
            ++n;
        }
    }

    public LiteralValueImpl next() {
        try {
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n = gregorianCalendar.get(5);
            if (n < 1 || n > 31) {
                return null;
            }
            int n2 = n + 1;
            if (n2 > 31) {
                return null;
            }
            if (this.isTimeZoneSpecified()) {
                return new DayLiteral("---" + this.to2charsString(n2) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new DayLiteral("---" + this.to2charsString(n2));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }

    public LiteralValueImpl previous() {
        try {
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n = gregorianCalendar.get(5);
            if (n < 1 || n > 31) {
                return null;
            }
            int n2 = n - 1;
            if (n2 < 1) {
                return null;
            }
            if (this.isTimeZoneSpecified()) {
                return new DayLiteral("---" + this.to2charsString(n2) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new DayLiteral("---" + this.to2charsString(n2));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }
}

