/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.NumericLiteral;
import java.math.BigDecimal;

public class DecimalLiteral
extends NumericLiteral {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int scale;
    private int totalDigit;
    protected String stringValue;

    public DecimalLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        try {
            return new DecimalLiteral(new String(this.stringValue));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            datatypeFormatException.printStackTrace(System.err);
            return null;
        }
    }

    public int compareTo(Object object) {
        if (object instanceof DecimalLiteral) {
            DecimalLiteral decimalLiteral = (DecimalLiteral)object;
            return ((Comparable)this.getValue()).compareTo(decimalLiteral.getValue());
        }
        return super.compareTo(object);
    }

    protected void conversion(String string) throws DatatypeFormatException {
        if (string == null) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("decimal"), null);
        }
        int n = string.indexOf(".");
        this.stringValue = string;
        try {
            String string2 = string.substring(0, 1);
            if (string2.equals("+")) {
                string = string.substring(1);
            }
            if (string != null) {
                string = string.trim();
            }
            string = this.removeTrailingZeros(string);
            this.value = new BigDecimal(string);
            this.scale = ((BigDecimal)this.value).scale();
            this.totalDigit = ((BigDecimal)this.value).unscaledValue().toString().length();
            if (this.scale > this.totalDigit) {
                this.totalDigit = this.scale;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("decimal"), this.stringValue);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("decimal"), this.stringValue);
        }
    }

    public String removeTrailingZeros(String string) {
        int n = string.indexOf(".");
        if (n == -1) {
            return string;
        }
        if (string.length() == n + 1) {
            return string.substring(0, n);
        }
        String string2 = string.substring(n + 1);
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        int n3 = cArray.length - 1;
        while (n3 >= 0) {
            if (cArray[n3] != '0') break;
            ++n2;
            --n3;
        }
        char[] cArray2 = new char[cArray.length - n2];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length - n2);
        return string.substring(0, n) + "." + new String(cArray2);
    }

    public int getScale() {
        return this.scale;
    }

    public int getTotalDigit() {
        return this.totalDigit;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.stringValue;
    }
}

