/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.viewandvisitor.SchemaObjectView;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitor;
import com.ibm.xml.ecm.schema.AnonymousTypeNotAcceptedAsBasetypeException;
import com.ibm.xml.ecm.schema.BasetypeRequiredException;
import com.ibm.xml.ecm.schema.CyclicTypeHierarchyException;
import com.ibm.xml.ecm.schema.DatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.DatatypeSpec;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.FinalDerivationMethodException;
import com.ibm.xml.ecm.schema.FixedBasetypeFacetException;
import com.ibm.xml.ecm.schema.IncompatibleFacetException;
import com.ibm.xml.ecm.schema.MultipleInheritanceForbiddenException;
import com.ibm.xml.ecm.schema.PrimitiveDatatype;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.TopComponentNotFoundException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.gen.impl.FacetImplGen;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.ComplexTypeDerivationMethod_Checker;
import com.ibm.xml.ecm.schema.impl.DatatypeDefImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.DerivationMethod;
import com.ibm.xml.ecm.schema.impl.FacetImpl;
import com.ibm.xml.ecm.schema.impl.FacetStrategy;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.PrimitiveDatatypeImpl;
import com.ibm.xml.ecm.schema.impl.TypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.UR_Type;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DerivationByRestriction
extends DerivationMethod {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DerivationByRestriction(DatatypeSpecImpl datatypeSpecImpl) {
        super(datatypeSpecImpl);
    }

    public void accept(SchemaObjectVisitor schemaObjectVisitor) {
        schemaObjectVisitor.visitDerivationByRestriction(this);
    }

    public Node accept(SchemaObjectVisitor schemaObjectVisitor, SchemaObjectView schemaObjectView) {
        return schemaObjectVisitor.visitDerivationByRestriction(this, schemaObjectView);
    }

    public void addUsedtype(DatatypeRef datatypeRef) throws MultipleInheritanceForbiddenException {
        if (this.type.listUsedtype() != null) {
            throw new MultipleInheritanceForbiddenException(this.type);
        }
        this.type.addUsedtypeRef(datatypeRef);
        this.updateAllFacets(datatypeRef, null);
    }

    public void addUsedtype(DatatypeSpec datatypeSpec) throws MultipleInheritanceForbiddenException {
        if (this.type.listUsedtype() != null) {
            throw new MultipleInheritanceForbiddenException(this.type);
        }
        this.type.addUsedtypeSpec(datatypeSpec);
        this.updateAllFacets(datatypeSpec, null);
    }

    public int[] allowedFacets() throws ReferenceResolutionException {
        CyclicTypeHierarchyException cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(this.type.getNamedType() == null ? this.type : this.type.getNamedType());
        if (cyclicTypeHierarchyException != null) {
            throw cyclicTypeHierarchyException;
        }
        if (this.type.listUsedtype() == null) {
            return null;
        }
        SimpleType simpleType = (SimpleType)this.getBasetype().resolveToType();
        return simpleType.allowedFacets();
    }

    public boolean check(Facet facet, Vector vector) {
        if (this.type.listUsedtype() == null) {
            return true;
        }
        if (ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(this.type.getNamedType() == null ? this.type : this.type.getNamedType()) != null) {
            return true;
        }
        return this.updateAllFacets(this.getBasetype(), facet, vector);
    }

    public boolean checkDerivation(int n, Vector vector) {
        try {
            int[] nArray;
            SimpleType simpleType;
            boolean bl = super.checkDerivation(n, vector);
            if (!bl) {
                return false;
            }
            if (this.type.listUsedtype() != null && (simpleType = (SimpleType)this.type.listUsedtype()[0].resolveToType()) instanceof DatatypeDef && (nArray = ((DatatypeDef)simpleType).getFinalList()) != null && this.contains(nArray, n)) {
                vector.add(new FinalDerivationMethodException(this.type, n, this.type.listUsedtype()[0]));
                return false;
            }
            return true;
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            if (Debug.DEBUG) {
                referenceResolutionException.printStackTrace(System.err);
            }
            return true;
        }
    }

    public Facet[] getAllFacetsWithoutErrorChecking() throws SchemaException {
        Facet[] facetArray;
        CyclicTypeHierarchyException cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(this.type.getNamedType() == null ? this.type : this.type.getNamedType());
        if (cyclicTypeHierarchyException != null) {
            throw cyclicTypeHierarchyException;
        }
        TypeInfo typeInfo = this.getBasetype();
        if (typeInfo != null) {
            Facet[] facetArray2;
            Vector vector = new Vector(1);
            if (!this.checkDerivation(this.type.getDerivationType(), vector)) {
                throw (SchemaException)vector.elementAt(0);
            }
            Facet[] facetArray3 = this.getBasetypeFacetsWithoutErrorChecking();
            Hashtable<Integer, Facet> hashtable = new Hashtable<Integer, Facet>();
            if (facetArray3 != null) {
                int n = 0;
                while (n < facetArray3.length) {
                    hashtable.put(new Integer(facetArray3[n].getFacetType()), facetArray3[n]);
                    ++n;
                }
            }
            if ((facetArray2 = this.type.getFacets()) != null) {
                int n = 0;
                while (n < facetArray2.length) {
                    hashtable.put(new Integer(facetArray2[n].getFacetType()), facetArray2[n]);
                    ++n;
                }
            }
            Enumeration enumeration = hashtable.elements();
            facetArray = new Facet[hashtable.size()];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                facetArray[n] = (Facet)enumeration.nextElement();
                ++n;
            }
        } else {
            facetArray = this.type.getFacets();
        }
        return facetArray;
    }

    private TypeInfo getBasetype() {
        TypeInfo[] typeInfoArray = this.type.listUsedtype();
        if (typeInfoArray != null) {
            return typeInfoArray[0];
        }
        return null;
    }

    private Facet[] getBasetypeFacetsWithoutErrorChecking() throws SchemaException {
        TypeInfo typeInfo = this.getBasetype();
        if (typeInfo == null) {
            return null;
        }
        Facet[] facetArray = null;
        SimpleType simpleType = (SimpleType)typeInfo.resolveToType();
        facetArray = simpleType instanceof PrimitiveDatatypeImpl ? ((PrimitiveDatatypeImpl)simpleType).getAllFacets() : (simpleType.isAnonymous() ? ((DatatypeSpecImpl)simpleType).getAllFacetsWithoutErrorChecking() : ((DatatypeSpecImpl)((DatatypeDef)simpleType).getDatatypeSpec()).getAllFacetsWithoutErrorChecking());
        return facetArray;
    }

    public FacetStrategy getFacetStrategy(int n) {
        CyclicTypeHierarchyException cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(this.type.getNamedType() == null ? this.type : this.type.getNamedType());
        if (cyclicTypeHierarchyException != null) {
            return null;
        }
        try {
            TypeInfo typeInfo = this.getBasetype();
            if (typeInfo == null) {
                return null;
            }
            if (typeInfo.isAReference()) {
                return ((DatatypeDefImpl)typeInfo.asTypeRef().resolve(false)).getFacetStrategy(n);
            }
            return ((DatatypeSpecImpl)typeInfo.asType()).getFacetStrategy(n);
        }
        catch (SchemaException schemaException) {
            if (Debug.DEBUG) {
                schemaException.printStackTrace();
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Implementation Error : " + classCastException);
        }
    }

    public int getVariety() throws ReferenceResolutionException {
        CyclicTypeHierarchyException cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(this.type.getNamedType() == null ? this.type : this.type.getNamedType());
        if (cyclicTypeHierarchyException != null) {
            throw cyclicTypeHierarchyException;
        }
        TypeInfo typeInfo = this.getBasetype();
        if (typeInfo != null) {
            return ((SimpleType)typeInfo.resolveToType()).getVariety();
        }
        return 0;
    }

    public boolean isDerivedFrom(Type type) throws ReferenceResolutionException {
        TypeInfo[] typeInfoArray;
        CyclicTypeHierarchyException cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(this.type.getNamedType() == null ? this.type : this.type.getNamedType());
        if (cyclicTypeHierarchyException != null) {
            throw cyclicTypeHierarchyException;
        }
        if (this.isDirectlyDerivedFrom(type, this.type.getDerivationType())) {
            return true;
        }
        if (type instanceof SimpleType && ((SimpleType)type).getVariety() == 2) {
            typeInfoArray = DatatypeSpecImpl.getUnionMembers((SimpleType)type);
            if (typeInfoArray == null) {
                return false;
            }
            int n = 0;
            while (n < typeInfoArray.length) {
                Type type2 = this.type.isAnonymous() ? (this.type instanceof TypeSpecImpl ? this.type.getNamedType() : null) : this.type;
                if (typeInfoArray[n].resolveToType().equals(type2) || this.isDerivedFrom(typeInfoArray[n].resolveToType())) {
                    return true;
                }
                ++n;
            }
        }
        if ((typeInfoArray = this.type.getBasetype()) == null) {
            return false;
        }
        return typeInfoArray.resolveToType().isDerivedFrom(type);
    }

    public boolean isDerivedFrom(TypeRef typeRef) throws ReferenceResolutionException {
        CyclicTypeHierarchyException cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(this.type.getNamedType() == null ? this.type : this.type.getNamedType());
        if (cyclicTypeHierarchyException != null) {
            throw cyclicTypeHierarchyException;
        }
        if (this.isDirectlyDerivedFrom(typeRef, this.type.getDerivationType())) {
            return true;
        }
        Type type = null;
        try {
            if (typeRef != null) {
                type = (Type)((Object)typeRef.resolve(false));
            }
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            // empty catch block
        }
        if (type != null && type instanceof SimpleType && ((SimpleType)type).getVariety() == 2) {
            return this.isDerivedFrom(type);
        }
        TypeInfo typeInfo = this.type.getBasetype();
        if (typeInfo == null) {
            return false;
        }
        return typeInfo.resolveToType().isDerivedFrom(typeRef);
    }

    public boolean isDirectlyDerivedFrom(Type type, int n) throws ReferenceResolutionException {
        TypeInfo typeInfo = this.type.getBasetype();
        if (typeInfo == null) {
            if (type == null || type.equals(BuiltInDatatypeFactory.get("anySimpleType"))) {
                return this.type.getDerivationType() == n;
            }
            return false;
        }
        if (type == null) {
            return false;
        }
        if (typeInfo.isAReference()) {
            if (type.isAnonymous()) {
                return false;
            }
            TypeRef typeRef = typeInfo.asTypeRef();
            if (!(type instanceof DatatypeDef)) {
                return false;
            }
            DatatypeDef datatypeDef = (DatatypeDef)type;
            if (datatypeDef.getNCName() == null) {
                return false;
            }
            if (typeRef.getTopComponentType() == datatypeDef.getComponentType() && datatypeDef.getNCName().equals(typeRef.getNCName())) {
                if (typeRef.getTargetNamespace() == null) {
                    return datatypeDef.getTargetNamespace() == null && this.type.getDerivationType() == n;
                }
                return typeRef.getTargetNamespace().equals(datatypeDef.getTargetNamespace()) && this.type.getDerivationType() == n;
            }
            return false;
        }
        Type type2 = typeInfo.asType();
        return type2.equals(type) && this.type.getDerivationType() == n;
    }

    public boolean isDirectlyDerivedFrom(TypeRef typeRef, int n) throws ReferenceResolutionException {
        TypeInfo typeInfo = this.type.getBasetype();
        if (typeInfo == null) {
            if (typeRef == null || ((Type)((Object)typeRef.resolve(false))).equals(BuiltInDatatypeFactory.get("anySimpleType"))) {
                return this.type.getDerivationType() == n;
            }
            return false;
        }
        if (typeInfo.isAReference()) {
            return this.type.getDerivationType() == n && typeInfo.asTypeRef().equals(typeRef);
        }
        return false;
    }

    private boolean isRestrictionProhibited(SimpleType simpleType) throws SchemaException {
        int[] nArray;
        if (simpleType.isAnonymous()) {
            return false;
        }
        if (simpleType instanceof DatatypeDef && (nArray = ((DatatypeDef)simpleType).getFinalList()) != null) {
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] == 0) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isValidRestrictionOf(Type type) throws SchemaException {
        Facet[] facetArray;
        TypeInfo typeInfo = this.getBasetype();
        Factory factory = FactoryImpl.instance();
        if (type == null || type.equals(factory.getBuiltInDatatype("anySimpleType")) || type.equals(new UR_Type())) {
            return true;
        }
        if (type.isComplexType()) {
            return false;
        }
        if (typeInfo == null) {
            return false;
        }
        SimpleType simpleType = (SimpleType)type;
        int n = this.type.getVariety();
        if (simpleType.getVariety() != n) {
            return false;
        }
        if (this.isRestrictionProhibited(simpleType)) {
            return false;
        }
        if (n == 0) {
            facetArray = simpleType.getPrimitiveDatatype();
            PrimitiveDatatype primitiveDatatype = this.type.getPrimitiveDatatype();
            if (facetArray != null && facetArray.equals(FactoryImpl.instance().getBuiltInDatatype("anySimpleType"))) {
                return true;
            }
            if (facetArray == null && primitiveDatatype != null || facetArray != null && !facetArray.equals(primitiveDatatype)) {
                return false;
            }
        }
        if ((facetArray = this.type.getAllFacetsWithoutErrorChecking()) != null) {
            int n2 = 0;
            while (n2 < facetArray.length) {
                Facet facet = simpleType.getFacet(facetArray[n2].getFacetType());
                if (facet != null && !facetArray[n2].inOrder(facet)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void removeUsedtype(DatatypeRef datatypeRef) throws BasetypeRequiredException {
        throw new BasetypeRequiredException(this.type);
    }

    public void removeUsedtype(DatatypeSpec datatypeSpec) throws BasetypeRequiredException {
        throw new BasetypeRequiredException(this.type);
    }

    public boolean replaceUsedtype(TypeInfo typeInfo, DatatypeRef datatypeRef) {
        TypeInfo[] typeInfoArray = this.type.listUsedtype();
        if (typeInfoArray == null) {
            return false;
        }
        if (typeInfoArray[0] != typeInfo) {
            return false;
        }
        if (typeInfo.isAReference()) {
            this.type.removeUsedtypeRef(typeInfo.asTypeRef());
        } else {
            this.type.removeUsedtypeSpec((DatatypeSpec)typeInfo.asType());
        }
        try {
            this.type.addUsedtype(datatypeRef);
        }
        catch (MultipleInheritanceForbiddenException multipleInheritanceForbiddenException) {
            throw new RuntimeException("Implementation error : " + multipleInheritanceForbiddenException);
        }
        return true;
    }

    public boolean replaceUsedtype(TypeInfo typeInfo, DatatypeSpec datatypeSpec) {
        TypeInfo[] typeInfoArray = this.type.listUsedtype();
        if (typeInfoArray == null) {
            return false;
        }
        if (typeInfoArray[0] != typeInfo) {
            return false;
        }
        if (typeInfo.isAReference()) {
            this.type.removeUsedtypeRef(typeInfo.asTypeRef());
        } else {
            this.type.removeUsedtypeSpec((DatatypeSpec)typeInfo.asType());
        }
        try {
            this.type.addUsedtype(datatypeSpec);
        }
        catch (MultipleInheritanceForbiddenException multipleInheritanceForbiddenException) {
            throw new RuntimeException("Implementation error : " + multipleInheritanceForbiddenException);
        }
        catch (AnonymousTypeNotAcceptedAsBasetypeException anonymousTypeNotAcceptedAsBasetypeException) {
            throw new RuntimeException("Implementation error : " + anonymousTypeNotAcceptedAsBasetypeException);
        }
        return true;
    }

    public Node toXMLRepresentation(Document document) {
        Facet[] facetArray;
        Element element = document.createElement(this.type.getTagNameWithPrefix("restriction"));
        TypeInfo typeInfo = this.type.getBasetype();
        if (typeInfo != null) {
            if (typeInfo.isAReference()) {
                element.setAttribute("base", typeInfo.asTypeRef().getQName());
            } else {
                element.appendChild(((SchemaObject)((Object)typeInfo)).toXMLRepresentation(document));
            }
        }
        if ((facetArray = this.type.getFacets()) != null) {
            int n = 0;
            while (n < facetArray.length) {
                element.appendChild(facetArray[n].toXMLRepresentation(document));
                ++n;
            }
        }
        return element;
    }

    public boolean updateAllFacets(TypeInfo[] typeInfoArray, Vector vector) {
        return this.updateAllFacets(typeInfoArray[0], vector);
    }

    public boolean updateAllFacets(TypeInfo typeInfo, Facet facet, Vector vector) {
        boolean bl;
        block31: {
            bl = true;
            try {
                Object object;
                Object object2;
                int n;
                if (vector != null && !this.checkDerivation(this.type.getDerivationType(), vector)) {
                    return false;
                }
                Facet[] facetArray = this.getBasetypeFacetsWithoutErrorChecking();
                this.allFacets.clear();
                if (facetArray != null) {
                    n = 0;
                    while (n < facetArray.length) {
                        object2 = ((FacetImpl)facetArray[n]).getFacetStrategy();
                        if (object2 == null) {
                            object = typeInfo.resolveToType();
                            if (object instanceof DatatypeSpecImpl) {
                                object2 = ((DatatypeSpecImpl)object).getFacetStrategy(facetArray[n].getFacetType());
                            } else if (object instanceof DatatypeDefImpl) {
                                object2 = ((DatatypeDefImpl)object).getFacetStrategy(facetArray[n].getFacetType());
                            }
                            if (object2 != null) {
                                ((FacetImpl)facetArray[n]).setFacetStrategy((FacetStrategy)object2);
                            }
                        }
                        this.allFacets.put(new Integer(facetArray[n].getFacetType()), facetArray[n]);
                        ++n;
                    }
                }
                object2 = null;
                object = null;
                Type type = this.type.getNamedType();
                type = type != null ? type : this.type;
                Facet[] facetArray2 = this.type.getFacets();
                if (facetArray2 == null) break block31;
                n = 0;
                while (n < facetArray2.length) {
                    block34: {
                        Integer n2;
                        block33: {
                            Object object3;
                            block32: {
                                object = (FacetImpl)facetArray2[n];
                                n2 = new Integer(((FacetImplGen)object).getFacetType());
                                if (vector == null) break block33;
                                if (facet != null && object != facet) break block34;
                                FacetStrategy facetStrategy = ((FacetImpl)object).getFacetStrategy();
                                if (facetStrategy == null && (facetStrategy = this.getFacetStrategy(((FacetImplGen)object).getFacetType())) != null) {
                                    ((FacetImpl)object).setFacetStrategy(facetStrategy);
                                }
                                if (((FacetImplGen)object).getFacetType() == 6 || ((FacetImplGen)object).getFacetType() == 5) {
                                    object3 = null;
                                    if (((FacetImpl)object).getValuesAsString() == null || (object3 = ((FacetImpl)object).getValuesAsString()) == null || ((String[])object3).length > 1) {
                                        // empty if block
                                    }
                                }
                                if (!this.type.allows((Facet)object)) {
                                    vector.addElement(new IncompatibleFacetException(type, (Facet)object, null, false));
                                    bl = false;
                                } else {
                                    SchemaException[] schemaExceptionArray;
                                    if (facetArray != null) {
                                        int n3 = 0;
                                        while (n3 < facetArray.length) {
                                            Facet facet2 = facetArray[n3];
                                            if (this.type.allows(facet2) && (schemaExceptionArray = ((FacetImpl)object).compatibleWithOtherFacet(type, facet2, false)) != null) {
                                                vector.addAll(Arrays.asList(schemaExceptionArray));
                                                bl = false;
                                            }
                                            ++n3;
                                        }
                                    }
                                    int n4 = 0;
                                    while (n4 < n) {
                                        SchemaException[] schemaExceptionArray2;
                                        schemaExceptionArray = facetArray2[n4];
                                        if (this.type.allows((Facet)schemaExceptionArray) && (schemaExceptionArray2 = ((FacetImpl)object).compatibleWithOtherFacet(type, (Facet)schemaExceptionArray, true)) != null) {
                                            vector.addAll(Arrays.asList(schemaExceptionArray2));
                                            bl = false;
                                        }
                                        ++n4;
                                    }
                                }
                                object3 = null;
                                try {
                                    object3 = ((FacetImpl)object).getValueAsObject();
                                }
                                catch (SchemaException schemaException) {
                                    if (!Debug.DEBUG) break block32;
                                    schemaException.printStackTrace();
                                }
                            }
                            if (object3 != null && (object2 = (Facet)this.allFacets.get(n2)) != null) {
                                if (!object2.isFixed() && !((FacetImpl)object).inOrder((Facet)object2)) {
                                    vector.addElement(new IncompatibleFacetException(type, (Facet)object, (Facet)object2, true));
                                    bl = false;
                                } else if (object2.isFixed() && !((FacetImpl)object).isEqual((Facet)object2)) {
                                    vector.addElement(new FixedBasetypeFacetException(type, (Facet)object, (Facet)object2));
                                    bl = false;
                                }
                            }
                        }
                        this.allFacets.put(n2, object);
                    }
                    ++n;
                }
            }
            catch (TopComponentNotFoundException topComponentNotFoundException) {
                if (Debug.DEBUG) {
                    topComponentNotFoundException.printStackTrace(System.err);
                }
                return true;
            }
            catch (SchemaException schemaException) {
                if (Debug.DEBUG) {
                    schemaException.printStackTrace(System.err);
                }
                return true;
            }
        }
        return bl;
    }

    public boolean updateAllFacets(TypeInfo typeInfo, Vector vector) {
        return this.updateAllFacets(typeInfo, null, vector);
    }
}

