/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.viewandvisitor.SchemaObjectView;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitor;
import com.ibm.xml.ecm.schema.CyclicTypeHierarchyException;
import com.ibm.xml.ecm.schema.DatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.DatatypeSpec;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.FinalDerivationMethodException;
import com.ibm.xml.ecm.schema.MultipleInheritanceForbiddenException;
import com.ibm.xml.ecm.schema.NotImplementedYetException;
import com.ibm.xml.ecm.schema.PropertyMissingException;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.TypeSpec;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.ComplexTypeDerivationMethod_Checker;
import com.ibm.xml.ecm.schema.impl.DatatypeDefImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.DerivationMethod;
import com.ibm.xml.ecm.schema.impl.EnumerationFacetStrategy;
import com.ibm.xml.ecm.schema.impl.FacetStrategy;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.PatternStringFacetStrategy;
import com.ibm.xml.ecm.schema.impl.WhiteSpaceFacetStrategy;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DerivationByUnion
extends DerivationMethod {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable facetStrategiesForUnion = null;

    public DerivationByUnion(DatatypeSpecImpl datatypeSpecImpl) {
        super(datatypeSpecImpl);
    }

    public void accept(SchemaObjectVisitor schemaObjectVisitor) {
        schemaObjectVisitor.visitDerivationByUnion(this);
    }

    public Node accept(SchemaObjectVisitor schemaObjectVisitor, SchemaObjectView schemaObjectView) {
        return schemaObjectVisitor.visitDerivationByUnion(this, schemaObjectView);
    }

    public void addUsedtype(DatatypeRef datatypeRef) throws MultipleInheritanceForbiddenException {
        this.type.addUsedtypeRef(datatypeRef);
    }

    public void addUsedtype(DatatypeSpec datatypeSpec) {
        this.type.addUsedtypeSpec(datatypeSpec);
    }

    public int[] allowedFacets() throws ReferenceResolutionException {
        return new int[]{5, 6, 12};
    }

    public boolean check(Facet facet, Vector vector) {
        return true;
    }

    public boolean checkDerivation(int n, Vector vector) {
        try {
            boolean bl = super.checkDerivation(n, vector);
            if (!bl) {
                return false;
            }
            TypeInfo[] typeInfoArray = this.type.listUsedtype();
            if (typeInfoArray != null) {
                int n2 = 0;
                while (n2 < typeInfoArray.length) {
                    int[] nArray = null;
                    Type type = typeInfoArray[n2].resolveToType();
                    if (!type.isAnonymous()) {
                        nArray = ((DatatypeDef)type).getFinalList();
                    }
                    if (nArray != null && this.contains(nArray, n)) {
                        vector.add(new FinalDerivationMethodException(this.type, n, typeInfoArray[n2]));
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            if (Debug.DEBUG) {
                referenceResolutionException.printStackTrace(System.err);
            }
            return true;
        }
    }

    public Object convert(String string) throws DatatypeFormatException, ReferenceResolutionException, PropertyMissingException {
        CyclicTypeHierarchyException cyclicTypeHierarchyException = ComplexTypeDerivationMethod_Checker.checkCyclicTypeHierarchy(this.type.getNamedType() == null ? this.type : this.type.getNamedType());
        if (cyclicTypeHierarchyException != null) {
            throw cyclicTypeHierarchyException;
        }
        TypeInfo[] typeInfoArray = this.type.listUsedtype();
        if (typeInfoArray != null && typeInfoArray.length > 0) {
            int n = 0;
            while (n < typeInfoArray.length) {
                try {
                    Type type = typeInfoArray[n].resolveToType();
                    if (type.isAnonymous()) {
                        return ((DatatypeSpecImpl)type).convert(string);
                    }
                    return ((DatatypeDefImpl)type).convert(string);
                }
                catch (DatatypeFormatException datatypeFormatException) {
                    if (Debug.DEBUG) {
                        datatypeFormatException.printStackTrace(System.err);
                    }
                    ++n;
                }
            }
            SimpleType simpleType = (SimpleType)this.type.getNamedType();
            if (simpleType != null) {
                throw new DatatypeFormatException(simpleType, string);
            }
            throw new DatatypeFormatException(this.type, string);
        }
        throw new PropertyMissingException(PropertyMissingException.BASETYPE, this.type);
    }

    public Facet[] getAllFacets() throws SchemaException {
        return super.getAllFacets();
    }

    public Facet[] getAllFacetsWithoutErrorChecking() {
        return this.type.getFacets();
    }

    public Facet getFacet(int n) throws SchemaException {
        return super.getFacet(n);
    }

    public FacetStrategy getFacetStrategy(int n) {
        if (this.facetStrategiesForUnion == null) {
            this.facetStrategiesForUnion = new Hashtable();
            this.facetStrategiesForUnion.put(new Integer(5), new PatternStringFacetStrategy());
            this.facetStrategiesForUnion.put(new Integer(6), new EnumerationFacetStrategy(this.type));
            this.facetStrategiesForUnion.put(new Integer(12), new WhiteSpaceFacetStrategy());
        }
        return (FacetStrategy)this.facetStrategiesForUnion.get(new Integer(n));
    }

    public int getVariety() {
        return 2;
    }

    public boolean isDerivedFrom(Type type) throws ReferenceResolutionException {
        if (type == null) {
            return true;
        }
        if (type.isUR_Type() || type.equals(BuiltInDatatypeFactory.get("anySimpleType"))) {
            return true;
        }
        return this.isDirectlyDerivedFrom(type, this.type.getDerivationType());
    }

    public boolean isDerivedFrom(TypeRef typeRef) throws ReferenceResolutionException {
        if (typeRef == null) {
            return true;
        }
        if (((Type)((Object)typeRef.resolve(false))).isUR_Type() || ((Type)((Object)typeRef.resolve(false))).equals(BuiltInDatatypeFactory.get("anySimpleType"))) {
            return true;
        }
        return this.isDirectlyDerivedFrom(typeRef, this.type.getDerivationType());
    }

    public boolean isDirectlyDerivedFrom(Type type, int n) throws ReferenceResolutionException {
        if (type == null || type.equals(FactoryImpl.instance().getBuiltInDatatype("anySimpleType"))) {
            return 4 == n;
        }
        return false;
    }

    public boolean isDirectlyDerivedFrom(TypeRef typeRef, int n) throws ReferenceResolutionException {
        if (typeRef == null || typeRef.resolve(false).equals(FactoryImpl.instance().getBuiltInDatatype("anySimpleType"))) {
            return 4 == n;
        }
        return false;
    }

    public boolean isValidRestrictionOf(Type type) throws SchemaException {
        return (this.equals(type) || this.isDerivedFrom(type)) && this.type.getState().isValid();
    }

    public void removeFacet(Facet facet) {
        super.removeFacet(facet);
    }

    public void removeUsedtype(DatatypeRef datatypeRef) {
        this.type.removeUsedtypeRef(datatypeRef);
    }

    public void removeUsedtype(DatatypeSpec datatypeSpec) {
        this.type.removeUsedtypeSpec(datatypeSpec);
    }

    public boolean replaceUsedtype(TypeInfo typeInfo, DatatypeRef datatypeRef) {
        throw new NotImplementedYetException();
    }

    public boolean replaceUsedtype(TypeInfo typeInfo, DatatypeSpec datatypeSpec) {
        throw new NotImplementedYetException();
    }

    public void setFacet(int n, String[] stringArray) {
        super.setFacet(n, stringArray);
    }

    public Node toXMLRepresentation(Document document) {
        int n;
        TypeSpec[] typeSpecArray;
        Element element = document.createElement(this.type.getTagNameWithPrefix("union"));
        TypeRef[] typeRefArray = this.type.listUsedtypeRef();
        if (typeRefArray != null) {
            typeSpecArray = new StringBuffer();
            n = 0;
            while (n < typeRefArray.length) {
                typeSpecArray.append(typeRefArray[n].getQName() + " ");
                ++n;
            }
            element.setAttribute("memberTypes", typeSpecArray.toString());
        }
        if ((typeSpecArray = this.type.listUsedtypeSpec()) != null) {
            n = 0;
            while (n < typeSpecArray.length) {
                element.appendChild(typeSpecArray[n].toXMLRepresentation(document));
                ++n;
            }
        }
        return element;
    }

    public boolean updateAllFacets(TypeInfo[] typeInfoArray, Vector vector) {
        return this.updateAllFacets(vector);
    }

    public boolean updateAllFacets(TypeInfo typeInfo, Vector vector) {
        return this.updateAllFacets(vector);
    }

    private boolean updateAllFacets(Vector vector) {
        return true;
    }
}

