/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.FloatingNumberOverflowWarning;
import com.ibm.xml.ecm.schema.FloatingNumberUnderflowWarning;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FloatLiteral;
import com.ibm.xml.ecm.schema.impl.NumericLiteral;

public class DoubleLiteral
extends NumericLiteral
implements Cloneable {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String specialValue;
    private String valueAsString;
    private Exception warning;

    private DoubleLiteral() {
    }

    public DoubleLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        DoubleLiteral doubleLiteral = new DoubleLiteral();
        doubleLiteral.value = new Double(this.value.doubleValue());
        return doubleLiteral;
    }

    public int compareTo(Object object) {
        if (object instanceof DoubleLiteral) {
            DoubleLiteral doubleLiteral = (DoubleLiteral)object;
            int n = super.compareTo(object);
            if (n == 0 && this.specialValue != null) {
                if (this.specialValue.trim().equals("0")) {
                    return doubleLiteral.specialValue.trim().equals("0") ? 0 : 1;
                }
                if (this.specialValue.trim().equals("-0")) {
                    return doubleLiteral.specialValue.trim().equals("-0") ? 0 : -1;
                }
                return n;
            }
            return n;
        }
        return super.compareTo(object);
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        try {
            if (string.trim().equals("INF")) {
                this.specialValue = "INF";
                this.value = new Double(Double.POSITIVE_INFINITY);
            } else if (string.trim().equals("-INF")) {
                this.specialValue = "-INF";
                this.value = new Double(Double.NEGATIVE_INFINITY);
            } else if (string.trim().equals("NaN")) {
                this.specialValue = "NaN";
                this.value = new Double(Double.NaN);
            } else if (string.trim().equals("0")) {
                this.specialValue = "0";
                this.value = Double.valueOf("0");
            } else if (string.trim().equals("-0")) {
                this.specialValue = "-0";
                this.value = Double.valueOf("-0");
            } else {
                this.value = Double.valueOf(string.trim());
                double d = this.value.doubleValue();
                boolean bl = false;
                if (d < 0.0) {
                    d = -d;
                    bl = true;
                }
                if (d > Double.MAX_VALUE) {
                    this.warning = new FloatingNumberOverflowWarning(string.trim(), true);
                    if (!bl) {
                        this.specialValue = "INF";
                        this.value = new Double(Double.POSITIVE_INFINITY);
                    } else {
                        this.specialValue = "-INF";
                        this.value = new Double(Double.NEGATIVE_INFINITY);
                    }
                } else if (d == 0.0 && !FloatLiteral.isZero(string.trim())) {
                    this.warning = new FloatingNumberUnderflowWarning(string.trim(), true);
                    if (string.trim().length() > 0) {
                        bl = string.trim().substring(0, 1).equals("-");
                    }
                    if (!bl) {
                        this.specialValue = "0";
                        this.value = Double.valueOf("0");
                    } else {
                        this.specialValue = "-0";
                        this.value = Double.valueOf("-0");
                    }
                } else if (d == 0.0) {
                    if (string.trim().length() > 0) {
                        bl = string.trim().substring(0, 1).equals("-");
                    }
                    if (bl) {
                        this.specialValue = "-0";
                        this.value = Double.valueOf("-0");
                    } else {
                        this.specialValue = "0";
                        this.value = Double.valueOf("0");
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace(System.err);
            }
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("double"), string);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Exception getWarning() {
        return this.warning;
    }

    public String toString() {
        return this.valueAsString;
    }

    public boolean isTotallyOrdered() {
        return false;
    }

    public boolean isComparable(Object object, boolean[] blArray) {
        if (object instanceof DoubleLiteral) {
            DoubleLiteral doubleLiteral = (DoubleLiteral)object;
            boolean bl = ((Double)this.getValue()).isNaN();
            boolean bl2 = ((Double)doubleLiteral.getValue()).isNaN();
            if (bl || bl2) {
                if (bl && bl2) {
                    if (blArray == null) {
                        return true;
                    }
                    blArray[0] = true;
                    return true;
                }
                return false;
            }
            if (blArray == null) {
                return true;
            }
            blArray[0] = this.inOrder(object);
            return true;
        }
        return false;
    }
}

