/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import com.ibm.xml.ecm.schema.impl.Order;
import java.math.BigDecimal;
import org.apache.xerces.impl.dv.xs.DurationDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class DurationLiteral
extends LiteralValueImpl
implements Order {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String valueAsString;
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private BigDecimal numberOfYears = ZERO;
    private BigDecimal numberOfMonths = ZERO;
    private BigDecimal numberOfDays = ZERO;
    private BigDecimal numberOfHours = ZERO;
    private BigDecimal numberOfMins = ZERO;
    private BigDecimal numberOfSecs = ZERO;
    private BigDecimal durationInSecs = null;
    private int[] duration;
    private static DurationHelper helper = new DurationHelper();
    private boolean isPositive = true;
    private static BuiltInDatatypeDef timeDurationType;
    private static final BigDecimal yearInSec;
    private static final BigDecimal monthInSec;
    private static final BigDecimal dayInSec;
    private static final BigDecimal hourInSec;
    private static final BigDecimal minInSec;
    private static RegularExpression regex;
    private static boolean initializedBuiltins;
    protected static final int CY = 0;
    protected static final int D = 2;
    private static final int[][] DATETIMES;
    protected static final short EQUAL = 0;
    protected static final short GREATER_THAN = 1;
    protected static final int h = 3;
    protected static final int hh = 0;
    protected static final short INDETERMINATE = 2;
    protected static final short LESS_THAN = -1;
    protected static final int m = 4;
    protected static final int M = 1;
    protected static final int mm = 1;
    protected static final int ms = 6;
    protected static final int s = 5;
    protected static final int TOTAL_SIZE = 8;
    protected static final int utc = 7;

    public DurationLiteral(String string) throws DatatypeFormatException {
        if (!initializedBuiltins) {
            timeDurationType = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("duration");
            initializedBuiltins = true;
        }
        if (regex == null) {
            String string2 = "(\\d*(?:\\.\\d+)?)";
            String string3 = "(?:" + string2 + "Y)?(?:" + string2 + "M)?(?:" + string2 + "D)?";
            String string4 = "(?:(T)(?:" + string2 + "H)?(?:" + string2 + "M)?(?:" + string2 + "S)?)?";
            regex = new RegularExpression("(\\+|-)?P" + string3 + string4);
        }
        this.conversion(string);
    }

    private int[] addDuration(int[] nArray, int n, int[] nArray2) {
        this.resetDateObj(nArray2);
        int n2 = DATETIMES[n][1] + nArray[1];
        nArray2[1] = this.modulo(n2, 1, 13);
        int n3 = this.fQuotient(n2, 1, 13);
        nArray2[0] = DATETIMES[n][0] + nArray[0] + n3;
        n2 = DATETIMES[n][5] + nArray[5];
        nArray2[5] = n2 % 60;
        n3 = n2 / 60;
        n2 = DATETIMES[n][3] + nArray[3] + n3;
        nArray2[3] = n2 % 24;
        n3 = n2 / 24;
        nArray2[2] = DATETIMES[n][2] + nArray[2] + n3;
        while (true) {
            n2 = this.maxDayInMonthFor(nArray2[0], nArray2[1]);
            if (nArray2[2] < 1) {
                nArray2[2] = nArray2[2] + this.maxDayInMonthFor(nArray2[0], nArray2[1] - 1);
                n3 = -1;
            } else {
                if (nArray2[2] <= n2) break;
                nArray2[2] = nArray2[2] - n2;
                n3 = 1;
            }
            n2 = nArray2[1] + n3;
            nArray2[1] = this.modulo(n2, 1, 13);
            nArray2[0] = nArray2[0] + this.fQuotient(n2, 1, 13);
        }
        nArray2[7] = 90;
        return nArray2;
    }

    public Object clone() {
        try {
            return new DurationLiteral(new String(this.valueAsString));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace(System.err);
            }
            return null;
        }
    }

    private short compareResults(short s, short s2, boolean bl) {
        if (s2 == 2) {
            return 2;
        }
        if (s != s2 && bl) {
            return 2;
        }
        if (s != s2 && !bl) {
            if (s != 0 && s2 != 0) {
                return 2;
            }
            return s != 0 ? s : s2;
        }
        return s;
    }

    protected void conversion(String string) throws DatatypeFormatException {
        try {
            MyMatch myMatch = new MyMatch();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            if (regex.matches(string, (Match)myMatch) && ((Match)myMatch).getCapturedText(0).equals(string.trim())) {
                String string2 = ((Match)myMatch).getCapturedText(1);
                if (string2 != null) {
                    this.isPositive = string2.equals("+");
                }
                if ((string2 = ((Match)myMatch).getCapturedText(2)) != null) {
                    if (bl3) {
                        throw new DatatypeFormatException(timeDurationType, string);
                    }
                    bl3 = string2.indexOf(".") != -1;
                    ++n;
                    this.numberOfYears = new BigDecimal(string2);
                }
                if ((string2 = ((Match)myMatch).getCapturedText(3)) != null) {
                    if (bl3) {
                        throw new DatatypeFormatException(timeDurationType, string);
                    }
                    bl3 = string2.indexOf(".") != -1;
                    ++n;
                    this.numberOfMonths = new BigDecimal(string2);
                }
                if ((string2 = ((Match)myMatch).getCapturedText(4)) != null) {
                    if (bl3) {
                        throw new DatatypeFormatException(timeDurationType, string);
                    }
                    bl3 = string2.indexOf(".") != -1;
                    ++n;
                    this.numberOfDays = new BigDecimal(string2);
                }
                if ((string2 = ((Match)myMatch).getCapturedText(5)) != null) {
                    bl = true;
                }
                if ((string2 = ((Match)myMatch).getCapturedText(6)) != null) {
                    if (bl3) {
                        throw new DatatypeFormatException(timeDurationType, string);
                    }
                    bl3 = string2.indexOf(".") != -1;
                    ++n;
                    bl2 = true;
                    this.numberOfHours = new BigDecimal(string2);
                }
                if ((string2 = ((Match)myMatch).getCapturedText(7)) != null) {
                    if (bl3) {
                        throw new DatatypeFormatException(timeDurationType, string);
                    }
                    bl3 = string2.indexOf(".") != -1;
                    ++n;
                    bl2 = true;
                    this.numberOfMins = new BigDecimal(string2);
                }
                if ((string2 = ((Match)myMatch).getCapturedText(8)) != null) {
                    if (bl3) {
                        throw new DatatypeFormatException(timeDurationType, string);
                    }
                    bl3 = string2.indexOf(".") != -1;
                    ++n;
                    bl2 = true;
                    this.numberOfSecs = new BigDecimal(string2);
                }
                if (n <= 0 || bl && !bl2) {
                    throw new DatatypeFormatException(timeDurationType, string);
                }
            } else {
                throw new DatatypeFormatException(timeDurationType, string);
            }
            this.valueAsString = string;
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace(System.err);
            }
            throw new DatatypeFormatException(timeDurationType, string);
        }
    }

    public boolean equals(Object object) {
        return this.isEqual(object);
    }

    protected int fQuotient(int n, int n2) {
        return (int)Math.floor((float)n / (float)n2);
    }

    protected int fQuotient(int n, int n2, int n3) {
        return this.fQuotient(n - n2, n3 - n2);
    }

    public BigDecimal getDurationInSecs() {
        if (this.durationInSecs == null) {
            this.durationInSecs = this.numberOfYears.multiply(yearInSec).add(this.numberOfMonths.multiply(monthInSec)).add(this.numberOfDays.multiply(dayInSec)).add(this.numberOfHours.multiply(hourInSec)).add(this.numberOfMins.multiply(minInSec)).add(this.numberOfSecs);
            if (!this.isPositive()) {
                this.durationInSecs = this.durationInSecs.negate();
            }
        }
        return this.durationInSecs;
    }

    public BigDecimal getNumberOfDays() {
        return this.numberOfDays;
    }

    public BigDecimal getNumberOfHours() {
        return this.numberOfHours;
    }

    public BigDecimal getNumberOfMins() {
        return this.numberOfMins;
    }

    public BigDecimal getNumberOfMonths() {
        return this.numberOfMonths;
    }

    public BigDecimal getNumberOfSecs() {
        return this.numberOfSecs;
    }

    public BigDecimal getNumberOfYears() {
        return this.numberOfYears;
    }

    public Object getValue() {
        return null;
    }

    public boolean inOrder(Object object) {
        int[] nArray = new int[1];
        boolean bl = this.isComparable(object, nArray);
        return bl && nArray[0] <= 0;
    }

    public boolean isComparable(Object object, int[] nArray) {
        if (object == null) {
            return false;
        }
        if (this.duration == null) {
            try {
                this.duration = helper.parse(this.valueAsString);
            }
            catch (Exception exception) {
                return false;
            }
        }
        int[] nArray2 = null;
        try {
            DurationLiteral durationLiteral = (DurationLiteral)object;
            if (durationLiteral.duration == null) {
                nArray2 = helper.parse(durationLiteral.valueAsString);
            }
        }
        catch (Exception exception) {
            return false;
        }
        short s = helper.compareDates(this.duration, nArray2, true);
        if (s == 2) {
            return false;
        }
        switch (s) {
            case 0: {
                nArray[0] = 0;
                break;
            }
            case -1: {
                nArray[0] = -1;
                break;
            }
            case 1: {
                nArray[0] = 1;
            }
        }
        return true;
    }

    public boolean isComparable(Object object, boolean[] blArray) {
        int[] nArray = new int[1];
        boolean bl = this.isComparable(object, nArray);
        if (!bl) {
            return false;
        }
        if (nArray[0] <= 0 && blArray != null && blArray.length > 0) {
            blArray[0] = true;
        }
        return true;
    }

    public boolean isEqual(Object object) {
        if (!(object instanceof DurationLiteral)) {
            return false;
        }
        int[] nArray = new int[1];
        boolean bl = this.isComparable(object, nArray);
        return bl && nArray[0] == 0;
    }

    public static boolean isInitializedBuiltins() {
        return initializedBuiltins;
    }

    private boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public boolean isTotallyOrdered() {
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        DurationLiteral durationLiteral = new DurationLiteral("-PT24H");
        System.out.println(" value = " + durationLiteral);
        System.out.println(" isPositive ? " + durationLiteral.isPositive());
        System.out.println(" Y = " + durationLiteral.getNumberOfYears());
        System.out.println(" M = " + durationLiteral.getNumberOfMonths());
        System.out.println(" D = " + durationLiteral.getNumberOfDays());
        System.out.println(" H = " + durationLiteral.getNumberOfHours());
        System.out.println(" M = " + durationLiteral.getNumberOfMins());
        System.out.println(" S = " + durationLiteral.getNumberOfSecs());
        durationLiteral = new DurationLiteral("P0Y");
        System.out.println(" value = " + durationLiteral);
        System.out.println(" isPositive ? " + durationLiteral.isPositive());
        System.out.println(" Y = " + durationLiteral.getNumberOfYears());
        System.out.println(" M = " + durationLiteral.getNumberOfMonths());
        System.out.println(" D = " + durationLiteral.getNumberOfDays());
        System.out.println(" H = " + durationLiteral.getNumberOfHours());
        System.out.println(" M = " + durationLiteral.getNumberOfMins());
        System.out.println(" S = " + durationLiteral.getNumberOfSecs());
    }

    protected int maxDayInMonthFor(int n, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            if (this.isLeapYear(n)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    protected int mod(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    protected int modulo(int n, int n2, int n3) {
        int n4 = n - n2;
        int n5 = n3 - n2;
        return this.mod(n4, n5, this.fQuotient(n4, n5)) + n2;
    }

    protected void resetDateObj(int[] nArray) {
        int n = 0;
        while (n < 8) {
            nArray[n] = 0;
            ++n;
        }
    }

    public static void setInitializedBuiltins(boolean bl) {
        initializedBuiltins = bl;
    }

    public String toString() {
        return this.valueAsString;
    }

    static {
        yearInSec = BigDecimal.valueOf(32140800L);
        monthInSec = BigDecimal.valueOf(2678400L);
        dayInSec = BigDecimal.valueOf(86400L);
        hourInSec = BigDecimal.valueOf(3600L);
        minInSec = BigDecimal.valueOf(60L);
        initializedBuiltins = false;
        DATETIMES = new int[][]{{1696, 9, 1, 0, 0, 0, 0, 90}, {1697, 2, 1, 0, 0, 0, 0, 90}, {1903, 3, 1, 0, 0, 0, 0, 90}, {1903, 7, 1, 0, 0, 0, 0, 90}};
    }

    protected static class DurationHelper
    extends DurationDV {
        protected DurationHelper() {
        }

        public int[] parse(String string) throws SchemaDateTimeException {
            return super.parse(string);
        }

        public short compareDates(int[] nArray, int[] nArray2, boolean bl) {
            return super.compareDates(nArray, nArray2, bl);
        }
    }

    protected class MyMatch
    extends Match {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected MyMatch() {
        }

        public String getCapturedText(int n) {
            if (this.getBeginning(n) != -1) {
                return super.getCapturedText(n);
            }
            return null;
        }
    }
}

