/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.ElementDefaultException;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.SimpleType_Checker;
import com.ibm.xml.ecm.schema.impl.WhiteSpaceFacetStrategy;

public class ElementDecl_ElementDefaultValid_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static CheckType ELEMENTDECL_ELEMENTDEFAULTVALID_CHECKER = new CheckType("Element default valid  Checker");
    private SimpleType_Checker typeChecker;
    private SchemaException[] exceptions;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$ElementDecl;

    public ElementDecl_ElementDefaultValid_Checker() {
    }

    public ElementDecl_ElementDefaultValid_Checker(ElementDecl elementDecl) {
        super(elementDecl);
    }

    public boolean check(boolean bl) {
        this.exceptions = null;
        ElementDecl elementDecl = (ElementDecl)this.subject;
        try {
            String string = elementDecl.getValue();
            int n = elementDecl.getValueConstraint();
            switch (n) {
                case 1: {
                    n = -3;
                    break;
                }
                case 2: {
                    n = -2;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            if (string == null) {
                return true;
            }
            Type type = elementDecl.getEffectiveType();
            if (type == null || type.isUR_Type()) {
                return true;
            }
            CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
            if (type.isComplexType()) {
                ContentModel contentModel;
                Particle particle;
                ContentType contentType;
                ComplexType complexType = (ComplexType)type;
                if (complexType instanceof ComplexTypeDef) {
                    complexType = ((ComplexTypeDef)complexType).getComplexTypeSpec();
                }
                if ((contentType = complexType.getEffectiveContentType()).isSimpleType()) {
                    string = WhiteSpaceFacetStrategy.normalize(string, contentType.asSimpleType());
                    SimpleType_Checker simpleType_Checker = this.getTypeChecker(contentType.asSimpleType(), string);
                    if (!checkerManagerImpl.check(simpleType_Checker, bl)) {
                        if (this.exceptions == null || this.exceptions.length == 0) {
                            this.exceptions = new SchemaException[]{new ElementDefaultException(elementDecl, simpleType_Checker.getExceptions())};
                        } else {
                            if (this.exceptions[0] instanceof DatatypeFormatException) {
                                ((DatatypeFormatException)this.exceptions[0]).setContext(n);
                            }
                            this.exceptions = new SchemaException[]{this.exceptions[0], new ElementDefaultException(elementDecl, simpleType_Checker.getExceptions())};
                        }
                        return false;
                    }
                    return true;
                }
                if (contentType.isMixedContentModel() && ((particle = (contentModel = contentType.asContentModel()).getParticle()) == null || particle.isEmptiable())) {
                    return this.exceptions == null;
                }
                if (this.exceptions == null || this.exceptions.length == 0) {
                    this.exceptions = new SchemaException[]{new ElementDefaultException(elementDecl, null)};
                } else {
                    if (this.exceptions[0] instanceof DatatypeFormatException) {
                        ((DatatypeFormatException)this.exceptions[0]).setContext(n);
                    }
                    this.exceptions = new SchemaException[]{this.exceptions[0], new ElementDefaultException(elementDecl, null)};
                }
                return false;
            }
            SimpleType simpleType = (SimpleType)type;
            SimpleType_Checker simpleType_Checker = this.getTypeChecker(simpleType, string = WhiteSpaceFacetStrategy.normalize(string, simpleType));
            if (!checkerManagerImpl.check(simpleType_Checker, bl)) {
                this.exceptions = this.exceptions == null ? new SchemaException[]{new ElementDefaultException(elementDecl, simpleType_Checker.getExceptions())} : new SchemaException[]{this.exceptions[0], new ElementDefaultException(elementDecl, simpleType_Checker.getExceptions())};
                return false;
            }
            return this.exceptions == null;
        }
        catch (SchemaException schemaException) {
            if (Debug.DEBUG) {
                schemaException.printStackTrace(System.err);
            }
            return this.exceptions == null;
        }
    }

    public CheckType getCheckType() {
        return ELEMENTDECL_ELEMENTDEFAULTVALID_CHECKER;
    }

    public int getCost() {
        if (this.typeChecker == null) {
            return 3;
        }
        return this.typeChecker.getCost();
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$ElementDecl == null ? (class$com$ibm$xml$ecm$schema$ElementDecl = ElementDecl_ElementDefaultValid_Checker.class$("com.ibm.xml.ecm.schema.ElementDecl")) : class$com$ibm$xml$ecm$schema$ElementDecl;
    }

    private SimpleType_Checker getTypeChecker(SimpleType simpleType, String string) {
        if (this.typeChecker == null) {
            this.typeChecker = new SimpleType_Checker(simpleType, this.subject, string);
            return this.typeChecker;
        }
        this.typeChecker.setSimpleType(simpleType);
        this.typeChecker.setStringToValidate(string);
        return this.typeChecker;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ELEMENTDECL_ELEMENTDEFAULTVALID_CHECKER);
    }
}

