/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.ComparatorForEquality;
import com.ibm.sketch.util.DuplicationFinder;
import com.ibm.sketch.util.ElementDeclComparator;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ElementConsistencyException;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaComponent;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.CircularDefinitionInAGroup_Checker;
import com.ibm.xml.ecm.schema.impl.Debug;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class ElementDeclarationConsistent_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SchemaException[] exceptions;
    private ComplexType complextype;
    public static CheckType ID = new CheckType("Element Declaration Consistent Checker");
    private Particle newParticle;
    private boolean performCompleteCheck = true;
    private boolean dontCheck = false;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$Group;

    public ElementDeclarationConsistent_Checker() {
    }

    public ElementDeclarationConsistent_Checker(Group group) {
        super(group);
    }

    public ElementDeclarationConsistent_Checker(Group group, ComplexType complexType) {
        super(group);
        this.complextype = complexType;
    }

    public boolean check(boolean bl) {
        Group group = (Group)this.subject;
        this.exceptions = null;
        if (CircularDefinitionInAGroup_Checker.checkCircularDefinitionException(group) != null) {
            return true;
        }
        Object[][] objectArray = this.getDuplicatedElementDeclarations();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                Object[][] objectArray2;
                int n2;
                Vector<Type> vector = new Vector<Type>(objectArray[n].length);
                Object[] objectArray3 = new ElementDecl[objectArray[n].length];
                System.arraycopy(objectArray[n], 0, objectArray3, 0, objectArray[n].length);
                Vector<Object> vector2 = new Vector<Object>();
                int n3 = 0;
                while (n3 < objectArray3.length) {
                    n2 = 1;
                    int n4 = 0;
                    while (n4 < vector2.size()) {
                        if (objectArray3[n3] == vector2.get(n4)) {
                            n2 = 0;
                            break;
                        }
                        ++n4;
                    }
                    if (n2 != 0) {
                        vector2.add(objectArray3[n3]);
                    }
                    ++n3;
                }
                objectArray3 = new ElementDecl[vector2.size()];
                vector2.copyInto(objectArray3);
                if (objectArray3.length > 1) {
                    n2 = 0;
                    while (n2 < objectArray3.length) {
                        block14: {
                            try {
                                Type type = objectArray3[n2].getEffectiveType();
                                if (type != null && type.isAnonymous() && !type.isUR_Type()) {
                                    this.exceptions = new SchemaException[]{new ElementConsistencyException(group, (ElementDecl[])objectArray3, this.complextype)};
                                    return false;
                                }
                                if (type != null) {
                                    vector.add(type);
                                }
                            }
                            catch (ReferenceResolutionException referenceResolutionException) {
                                if (!Debug.DEBUG) break block14;
                                referenceResolutionException.printStackTrace(System.err);
                            }
                        }
                        ++n2;
                    }
                }
                if (vector.size() > 1 && ((objectArray2 = DuplicationFinder.getDuplications(vector.toArray(), new NamedTypeComparator())) == null || objectArray2.length == 0 || objectArray2[0].length != vector.size())) {
                    this.exceptions = new SchemaException[]{new ElementConsistencyException(group, (ElementDecl[])objectArray3, this.complextype)};
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 9;
    }

    private Object[][] getDuplicatedElementDeclarations() {
        Object[][] objectArray = null;
        ElementDecl elementDecl = this.getNewElementDecl();
        Group group = (Group)this.subject;
        if (elementDecl != null) {
            Vector vector = ElementDeclarationConsistent_Checker.getElementDeclContainedDirectlyOrIndirectlyOrImplicitly(group.listParticle());
            if (vector.size() == 0) {
                return null;
            }
            Object[] objectArray2 = DuplicationFinder.getObjectsEqualTo(vector.toArray(), elementDecl, new ElementDeclComparator());
            if (objectArray2 != null && objectArray2.length > 1) {
                objectArray = new Object[][]{objectArray2};
            }
        } else {
            if (this.dontCheck) {
                return null;
            }
            Vector vector = ElementDeclarationConsistent_Checker.getElementDeclContainedDirectlyOrIndirectlyOrImplicitly(group.listParticle());
            if (vector == null || vector.size() == 0) {
                return null;
            }
            objectArray = DuplicationFinder.getDuplications(vector.toArray(), new ElementDeclComparator());
        }
        return objectArray;
    }

    protected static Vector getElementDeclContainedDirectlyAndIndirectly(Particle[] particleArray) {
        Vector<ElementDecl> vector = new Vector<ElementDecl>();
        if (particleArray == null) {
            return vector;
        }
        int n = 0;
        while (n < particleArray.length) {
            block10: {
                try {
                    switch (particleArray[n].getParticleType()) {
                        case 2: {
                            vector.add(particleArray[n].asElementDecl());
                            break;
                        }
                        case 1: {
                            ElementRef elementRef = particleArray[n].asElementRef();
                            vector.add((GlobalElementDecl)elementRef.resolve(false));
                            break;
                        }
                        case 3: {
                            ModelGroupDef modelGroupDef = (ModelGroupDef)particleArray[n].asModelGroupRef().resolve(false);
                            Group group = modelGroupDef.getGroup();
                            if (group == null) break;
                            vector.addAll(ElementDeclarationConsistent_Checker.getElementDeclContainedDirectlyAndIndirectly(group.listParticle()));
                            break;
                        }
                        case 0: {
                            Group group = particleArray[n].asGroup();
                            vector.addAll(ElementDeclarationConsistent_Checker.getElementDeclContainedDirectlyAndIndirectly(group.listParticle()));
                            break;
                        }
                    }
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    if (!Debug.DEBUG) break block10;
                    referenceResolutionException.printStackTrace(System.err);
                }
            }
            ++n;
        }
        return vector;
    }

    protected static Vector getElementDeclContainedDirectlyOrIndirectlyOrImplicitly(Particle[] particleArray) {
        Vector<ElementDecl> vector = new Vector<ElementDecl>();
        if (particleArray == null) {
            return vector;
        }
        int n = 0;
        while (n < particleArray.length) {
            block10: {
                try {
                    switch (particleArray[n].getParticleType()) {
                        case 1: 
                        case 2: {
                            ElementDecl elementDecl = null;
                            if (particleArray[n].isElementDecl()) {
                                elementDecl = particleArray[n].asElementDecl();
                                vector.add(elementDecl);
                                break;
                            }
                            SchemaComponent schemaComponent = particleArray[n].asElementRef();
                            elementDecl = (ElementDecl)((Object)schemaComponent.resolve(false));
                            ElementDecl[] elementDeclArray = ((GlobalElementDecl)elementDecl).getSubstitutionGroupMembers();
                            if (elementDeclArray == null) break;
                            vector.addAll(Arrays.asList(elementDeclArray));
                            break;
                        }
                        case 3: {
                            SchemaComponent schemaComponent = (ModelGroupDef)particleArray[n].asModelGroupRef().resolve(false);
                            ElementDecl[] elementDeclArray = schemaComponent.getGroup();
                            if (elementDeclArray == null) break;
                            vector.addAll(ElementDeclarationConsistent_Checker.getElementDeclContainedDirectlyAndIndirectly(elementDeclArray.listParticle()));
                            break;
                        }
                        case 0: {
                            ElementDecl[] elementDeclArray = particleArray[n].asGroup();
                            vector.addAll(ElementDeclarationConsistent_Checker.getElementDeclContainedDirectlyAndIndirectly(elementDeclArray.listParticle()));
                            break;
                        }
                    }
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    if (!Debug.DEBUG) break block10;
                    referenceResolutionException.printStackTrace(System.err);
                }
            }
            ++n;
        }
        return vector;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    private ElementDecl getNewElementDecl() {
        this.performCompleteCheck = true;
        this.dontCheck = false;
        if (this.newParticle == null) {
            return null;
        }
        if (this.newParticle.isElementDecl()) {
            this.performCompleteCheck = false;
            return this.newParticle.asElementDecl();
        }
        if (this.newParticle.isElementRef()) {
            this.performCompleteCheck = true;
            return null;
        }
        if (this.newParticle.isWildcard()) {
            this.dontCheck = true;
            return null;
        }
        this.performCompleteCheck = true;
        return null;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$Group == null ? (class$com$ibm$xml$ecm$schema$Group = ElementDeclarationConsistent_Checker.class$("com.ibm.xml.ecm.schema.Group")) : class$com$ibm$xml$ecm$schema$Group;
    }

    public void setNewParticle(Particle particle) {
        this.newParticle = particle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }

    private class NamedTypeComparator
    implements Comparator,
    ComparatorForEquality {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private NamedTypeComparator() {
        }

        public String toString(Type type) {
            if (type.isAnonymous()) {
                throw new IllegalArgumentException(type + " must be a named type");
            }
            if (type == null && type.isUR_Type()) {
                return "type:false:";
            }
            return "type:true:" + type.isComplexType() + ":" + type.getTargetNamespace() + ":" + type.getNCName();
        }

        public int compare(Object object, Object object2) {
            return this.toString((Type)object).compareTo(this.toString((Type)object2));
        }

        public boolean equals(Object object, Object object2) {
            return this.compare(object, object2) == 0;
        }
    }
}

