/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.PropertyMissingException;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.impl.DatatypeDefImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.EnumerationFacetStrategy;
import com.ibm.xml.ecm.schema.impl.FacetImpl;
import com.ibm.xml.ecm.schema.impl.WhiteSpaceFacetStrategy;
import java.util.StringTokenizer;
import java.util.Vector;

public class EnumerationListFacetStrategy
extends EnumerationFacetStrategy {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    EnumerationListFacetStrategy(DatatypeDefImpl datatypeDefImpl) {
        super(datatypeDefImpl);
    }

    EnumerationListFacetStrategy(DatatypeSpecImpl datatypeSpecImpl) {
        super(datatypeSpecImpl);
    }

    Object convertToAppropriatedObject(String[] stringArray) throws DatatypeFormatException {
        Vector<MyVector> vector = new Vector<MyVector>(stringArray.length);
        try {
            int n = 0;
            while (n < stringArray.length) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n]);
                MyVector myVector = new MyVector(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreTokens()) {
                    Object object = this.datatypeSpec != null ? this.datatypeSpec.convert(WhiteSpaceFacetStrategy.normalize(stringTokenizer.nextToken(), this.datatypeSpec)) : this.datatypeDef.convert(WhiteSpaceFacetStrategy.normalize(stringTokenizer.nextToken(), this.datatypeDef));
                    myVector.addElement(object);
                }
                if (!vector.contains(myVector)) {
                    vector.addElement(myVector);
                }
                ++n;
            }
            return vector;
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            if (Debug.DEBUG) {
                referenceResolutionException.printStackTrace(System.err);
            }
            return new Vector(0);
        }
        catch (PropertyMissingException propertyMissingException) {
            if (Debug.DEBUG) {
                propertyMissingException.printStackTrace(System.err);
            }
            return new Vector(0);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            datatypeFormatException.setContext(6);
            throw datatypeFormatException;
        }
    }

    private Vector getValue(Facet facet) throws DatatypeFormatException, ClassCastException, InvalidStateException {
        Vector vector = null;
        if (facet instanceof FacetImpl) {
            vector = (Vector)((FacetImpl)facet).getValueAsObject();
        }
        if (vector == null) {
            vector = (Vector)this.convertToAppropriatedObject(facet.getValuesAsString());
        }
        return vector;
    }

    boolean validate(Facet facet, String string) {
        try {
            Vector vector = this.getValue(facet);
            Vector vector2 = (Vector)this.convertToAppropriatedObject(new String[]{string});
            if (vector2.size() == 0) {
                return false;
            }
            return vector.contains(vector2 = (Vector)vector2.get(0));
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace(System.err);
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace(System.err);
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace(System.err);
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace(System.err);
            }
            return false;
        }
    }

    class MyVector
    extends Vector {
        public MyVector(int n, int n2) {
            super(n, n2);
        }

        public MyVector(int n) {
            super(n);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof MyVector)) {
                return false;
            }
            MyVector myVector = (MyVector)object;
            if (this.size() != myVector.size()) {
                return false;
            }
            int n = 0;
            while (n < this.size()) {
                if (!this.elementAt(n).equals(myVector.elementAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

