/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.graph.DefaultGraphVisitor;
import com.ibm.sketch.graph.DepthFirstTraversal;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.Vertex;
import com.ibm.xml.ecm.schema.CircularSubstitutionGroupException;
import com.ibm.xml.ecm.schema.ComplexTypeDef;
import com.ibm.xml.ecm.schema.DerivationMethodIncompatibleWithExamplarBlockException;
import com.ibm.xml.ecm.schema.DerivationMethodIncompatibleWithExamplarFinalException;
import com.ibm.xml.ecm.schema.DerivationMethodIncompatibleWithTypeExamplarBlockException;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.EquivalenceClassForbiddenException;
import com.ibm.xml.ecm.schema.EquivalenceClass_TypeIncompatibleException;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.GlobalElementDeclImpl;
import com.ibm.xml.ecm.schema.impl.SubstitutionGroupAffiliationVertex;
import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;

public class EquivalenceClass_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static Vector path = new Vector();
    public static CheckType EQUIVALENCECLASS_CHECKER = new CheckType("Equivalence Class  Checker");
    private SchemaException[] exceptions;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$ElementDecl;

    public EquivalenceClass_Checker() {
    }

    public EquivalenceClass_Checker(GlobalElementDecl globalElementDecl) {
        super(globalElementDecl);
    }

    public EquivalenceClass_Checker(LocalElementDecl localElementDecl) {
        super(localElementDecl);
    }

    public boolean check(boolean bl) {
        block10: {
            try {
                this.exceptions = null;
                ElementDecl elementDecl = (ElementDecl)this.subject;
                ElementRef elementRef = elementDecl.getSubstitutionAffiliation();
                if (elementRef == null) {
                    return true;
                }
                GlobalElementDecl globalElementDecl = (GlobalElementDecl)elementRef.resolve(false);
                int[] nArray = globalElementDecl.getFinalList();
                int[] nArray2 = globalElementDecl.getBlockList();
                if (this.contains(nArray2, 10)) {
                    this.exceptions = new SchemaException[]{new EquivalenceClassForbiddenException(elementDecl, globalElementDecl)};
                    return false;
                }
                Type type = elementDecl.getExplicitType();
                Type type2 = globalElementDecl.getEffectiveType();
                if (type != null) {
                    if (!type.isDerivedFromGivenSomeDerivationMethods(type2, nArray)) {
                        this.exceptions = type.equals(type2) || type.isDerivedFrom(type2) ? new SchemaException[]{new DerivationMethodIncompatibleWithExamplarFinalException(elementDecl, globalElementDecl)} : new SchemaException[]{new EquivalenceClass_TypeIncompatibleException(elementDecl, globalElementDecl)};
                        return false;
                    }
                    if (elementDecl instanceof GlobalElementDecl) {
                        DerivationMethodConsistentVisitor derivationMethodConsistentVisitor = new DerivationMethodConsistentVisitor();
                        new DepthFirstTraversal().traverse(new SubstitutionGroupAffiliationVertex((GlobalElementDecl)elementDecl), (GraphVisitor)derivationMethodConsistentVisitor);
                        this.exceptions = derivationMethodConsistentVisitor.getExceptions();
                        if (this.exceptions != null) {
                            return false;
                        }
                    }
                }
                path.clear();
                if (GlobalElementDeclImpl.circularSubstitutionGroup(elementDecl, path)) {
                    this.exceptions = new SchemaException[]{new CircularSubstitutionGroupException(new Vector(path))};
                    return false;
                }
            }
            catch (CircularSubstitutionGroupException circularSubstitutionGroupException) {
                this.exceptions = new SchemaException[]{circularSubstitutionGroupException};
                return false;
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                if (!Debug.DEBUG) break block10;
                referenceResolutionException.printStackTrace(System.err);
            }
        }
        return true;
    }

    private boolean contains(int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        Arrays.sort(nArray);
        return Arrays.binarySearch(nArray, n) >= 0;
    }

    public CheckType getCheckType() {
        return EQUIVALENCECLASS_CHECKER;
    }

    public int getCost() {
        return 3;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$ElementDecl == null ? (class$com$ibm$xml$ecm$schema$ElementDecl = EquivalenceClass_Checker.class$("com.ibm.xml.ecm.schema.ElementDecl")) : class$com$ibm$xml$ecm$schema$ElementDecl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(EQUIVALENCECLASS_CHECKER);
    }

    private class DerivationMethodConsistentVisitor
    extends DefaultGraphVisitor {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private Stack substitutionChain = new Stack();
        private GlobalElementDecl root;
        private int rootTypeDerivationMethod = -100;
        private boolean noRootType = false;
        private Vector exs = new Vector();

        private DerivationMethodConsistentVisitor() {
        }

        public void visitVertex(Vertex vertex) {
            block12: {
                Object object;
                if (this.exs.size() > 0 || this.noRootType) {
                    return;
                }
                GlobalElementDecl globalElementDecl = (GlobalElementDecl)vertex.getObject();
                this.substitutionChain.push(globalElementDecl);
                if (this.root == null) {
                    this.root = globalElementDecl;
                    try {
                        object = globalElementDecl.getEffectiveType();
                        if (object != null && !object.isUR_Type()) {
                            this.rootTypeDerivationMethod = object.getDerivationType();
                        } else {
                            this.noRootType = true;
                        }
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        this.noRootType = true;
                    }
                }
                object = globalElementDecl.getSubstitutionAffiliation();
                try {
                    if (object == null) break block12;
                    GlobalElementDecl globalElementDecl2 = (GlobalElementDecl)object.resolve(false);
                    try {
                        Type type;
                        EquivalenceClass_TypeIncompatibleException equivalenceClass_TypeIncompatibleException;
                        this.substitutionChain.push(globalElementDecl2);
                        int[] nArray = globalElementDecl2.getBlockList();
                        if (EquivalenceClass_Checker.this.contains(nArray, this.rootTypeDerivationMethod)) {
                            equivalenceClass_TypeIncompatibleException = new DerivationMethodIncompatibleWithExamplarBlockException(globalElementDecl, globalElementDecl2);
                            equivalenceClass_TypeIncompatibleException.setSubstitutionChain(this.substitutionChain.toArray(new GlobalElementDecl[this.substitutionChain.size()]));
                            this.exs.add(equivalenceClass_TypeIncompatibleException);
                        }
                        if ((type = globalElementDecl2.getEffectiveType()) != null && type instanceof ComplexTypeDef && EquivalenceClass_Checker.this.contains(nArray = ((ComplexTypeDef)type).getBlockList(), this.rootTypeDerivationMethod)) {
                            equivalenceClass_TypeIncompatibleException = new DerivationMethodIncompatibleWithTypeExamplarBlockException(globalElementDecl, globalElementDecl2);
                            equivalenceClass_TypeIncompatibleException.setSubstitutionChain(this.substitutionChain.toArray(new GlobalElementDecl[this.substitutionChain.size()]));
                            this.exs.add(equivalenceClass_TypeIncompatibleException);
                        }
                        Object var9_10 = null;
                        this.substitutionChain.pop();
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        this.substitutionChain.pop();
                        throw throwable;
                    }
                    {
                    }
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    if (!Debug.DEBUG) break block12;
                    referenceResolutionException.printStackTrace(System.err);
                }
            }
        }

        private SchemaException[] getExceptions() {
            if (this.exs.size() > 0) {
                Object[] objectArray = new SchemaException[this.exs.size()];
                this.exs.copyInto(objectArray);
                return objectArray;
            }
            return null;
        }
    }
}

