/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.DuplicationFinder;
import com.ibm.xml.ecm.schema.ComponentDefinedMoreThanOnceException;
import com.ibm.xml.ecm.schema.OpenCloseManager;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.impl.Duplication_Checker;
import com.ibm.xml.ecm.schema.impl.OpenCloseManagerImpl;
import java.util.Comparator;

public class FastDuplication_Checker
extends Duplication_Checker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Comparator comparator;
    private boolean orderedArray = false;

    public FastDuplication_Checker(SchemaObject schemaObject, Object[] objectArray, Comparator comparator) {
        super(schemaObject, objectArray);
        this.comparator = comparator;
    }

    public FastDuplication_Checker(Comparator comparator) {
        this.comparator = comparator;
    }

    public boolean check(boolean bl) {
        this.exceptions.clear();
        if (this.allComponents == null) {
            return true;
        }
        OpenCloseManager openCloseManager = OpenCloseManagerImpl.getInstance();
        if (((OpenCloseManagerImpl)openCloseManager).isDisableDuplicationChecker()) {
            return true;
        }
        Object[][] objectArray = DuplicationFinder.getDuplications(this.allComponents, this.orderedArray, this.comparator);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.exceptions.addElement(new ComponentDefinedMoreThanOnceException((SchemaObject)this.subject, objectArray[n]));
                ++n;
            }
            return false;
        }
        return true;
    }

    public int getCost() {
        return 4;
    }

    public void setAllComponents(Object[] objectArray) {
        super.setAllComponents(objectArray);
        this.orderedArray = false;
    }

    public void setAllComponents(Object[] objectArray, boolean bl, Comparator comparator) {
        super.setAllComponents(objectArray);
        this.orderedArray = bl;
        this.comparator = comparator;
    }
}

